/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Deprecated;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class Employment {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * The job title of the employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("job_title")
    private JsonNullable<String> jobTitle;

    /**
     * The pay rate for the employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_rate")
    private JsonNullable<String> payRate;

    /**
     * The pay period
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_period")
    private JsonNullable<? extends PayPeriod> payPeriod;

    /**
     * The pay frequency
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_frequency")
    private JsonNullable<? extends PayFrequency> payFrequency;

    /**
     * The currency used for pay
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("pay_currency")
    private JsonNullable<String> payCurrency;

    /**
     * The effective date of the employment contract
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("effective_date")
    private JsonNullable<OffsetDateTime> effectiveDate;

    /**
     * The end date of employment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_date")
    private JsonNullable<OffsetDateTime> endDate;

    /**
     * Represents the employee’s position within the organizational hierarchy.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("grade")
    private JsonNullable<? extends Grade> grade;

    /**
     * The type of employment (e.g., contractor, permanent)
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employment_type")
    @Deprecated
    private JsonNullable<? extends EmploymentEmploymentType> employmentType;

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employment_contract_type")
    @Deprecated
    private JsonNullable<? extends EmploymentEmploymentContractType> employmentContractType;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("work_time")
    private JsonNullable<? extends WorkTime> workTime;

    /**
     * The payroll code of the employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("payroll_code")
    private JsonNullable<String> payrollCode;

    /**
     * The employee ID associated with this employment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("employee_id")
    private JsonNullable<String> employeeId;

    /**
     * Provider's unique identifier of the employee associated with this employment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_employee_id")
    private JsonNullable<String> remoteEmployeeId;

    /**
     * the employee's working percentage relative to a full-time employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("fte")
    private JsonNullable<Double> fte;

    /**
     * The created_at date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The updated_at date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * The start_date of employment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_date")
    @Deprecated
    private JsonNullable<OffsetDateTime> startDate;

    /**
     * The employment active status
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("active")
    private JsonNullable<Boolean> active;

    /**
     * The employee department
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("department")
    private JsonNullable<? extends EmploymentDepartment> department;

    /**
     * The employee cost_center
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cost_center")
    @Deprecated
    private JsonNullable<? extends CostCenter> costCenter;

    /**
     * The employee cost_centers
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("cost_centers")
    private JsonNullable<? extends List<HRISCostCenter>> costCenters;

    /**
     * The employee division
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("division")
    private JsonNullable<? extends Division> division;

    /**
     * The job of employee
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("job")
    private JsonNullable<? extends EmploymentJob> job;

    /**
     * The type of employment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends EmploymentType1> type;

    /**
     * The employment work schedule type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("contract_type")
    private JsonNullable<? extends ContractType> contractType;

    /**
     * The employee manager
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("manager")
    private JsonNullable<? extends List<EmploymentManagerApiModel>> manager;

    @JsonCreator
    public Employment(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("job_title") JsonNullable<String> jobTitle,
            @JsonProperty("pay_rate") JsonNullable<String> payRate,
            @JsonProperty("pay_period") JsonNullable<? extends PayPeriod> payPeriod,
            @JsonProperty("pay_frequency") JsonNullable<? extends PayFrequency> payFrequency,
            @JsonProperty("pay_currency") JsonNullable<String> payCurrency,
            @JsonProperty("effective_date") JsonNullable<OffsetDateTime> effectiveDate,
            @JsonProperty("end_date") JsonNullable<OffsetDateTime> endDate,
            @JsonProperty("grade") JsonNullable<? extends Grade> grade,
            @JsonProperty("employment_type") JsonNullable<? extends EmploymentEmploymentType> employmentType,
            @JsonProperty("employment_contract_type") JsonNullable<? extends EmploymentEmploymentContractType> employmentContractType,
            @JsonProperty("work_time") JsonNullable<? extends WorkTime> workTime,
            @JsonProperty("payroll_code") JsonNullable<String> payrollCode,
            @JsonProperty("employee_id") JsonNullable<String> employeeId,
            @JsonProperty("remote_employee_id") JsonNullable<String> remoteEmployeeId,
            @JsonProperty("fte") JsonNullable<Double> fte,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("start_date") JsonNullable<OffsetDateTime> startDate,
            @JsonProperty("active") JsonNullable<Boolean> active,
            @JsonProperty("department") JsonNullable<? extends EmploymentDepartment> department,
            @JsonProperty("cost_center") JsonNullable<? extends CostCenter> costCenter,
            @JsonProperty("cost_centers") JsonNullable<? extends List<HRISCostCenter>> costCenters,
            @JsonProperty("division") JsonNullable<? extends Division> division,
            @JsonProperty("job") JsonNullable<? extends EmploymentJob> job,
            @JsonProperty("type") JsonNullable<? extends EmploymentType1> type,
            @JsonProperty("contract_type") JsonNullable<? extends ContractType> contractType,
            @JsonProperty("manager") JsonNullable<? extends List<EmploymentManagerApiModel>> manager) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(jobTitle, "jobTitle");
        Utils.checkNotNull(payRate, "payRate");
        Utils.checkNotNull(payPeriod, "payPeriod");
        Utils.checkNotNull(payFrequency, "payFrequency");
        Utils.checkNotNull(payCurrency, "payCurrency");
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        Utils.checkNotNull(endDate, "endDate");
        Utils.checkNotNull(grade, "grade");
        Utils.checkNotNull(employmentType, "employmentType");
        Utils.checkNotNull(employmentContractType, "employmentContractType");
        Utils.checkNotNull(workTime, "workTime");
        Utils.checkNotNull(payrollCode, "payrollCode");
        Utils.checkNotNull(employeeId, "employeeId");
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        Utils.checkNotNull(fte, "fte");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(startDate, "startDate");
        Utils.checkNotNull(active, "active");
        Utils.checkNotNull(department, "department");
        Utils.checkNotNull(costCenter, "costCenter");
        Utils.checkNotNull(costCenters, "costCenters");
        Utils.checkNotNull(division, "division");
        Utils.checkNotNull(job, "job");
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(contractType, "contractType");
        Utils.checkNotNull(manager, "manager");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.jobTitle = jobTitle;
        this.payRate = payRate;
        this.payPeriod = payPeriod;
        this.payFrequency = payFrequency;
        this.payCurrency = payCurrency;
        this.effectiveDate = effectiveDate;
        this.endDate = endDate;
        this.grade = grade;
        this.employmentType = employmentType;
        this.employmentContractType = employmentContractType;
        this.workTime = workTime;
        this.payrollCode = payrollCode;
        this.employeeId = employeeId;
        this.remoteEmployeeId = remoteEmployeeId;
        this.fte = fte;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.startDate = startDate;
        this.active = active;
        this.department = department;
        this.costCenter = costCenter;
        this.costCenters = costCenters;
        this.division = division;
        this.job = job;
        this.type = type;
        this.contractType = contractType;
        this.manager = manager;
    }
    
    public Employment() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * The job title of the employee
     */
    @JsonIgnore
    public JsonNullable<String> jobTitle() {
        return jobTitle;
    }

    /**
     * The pay rate for the employee
     */
    @JsonIgnore
    public JsonNullable<String> payRate() {
        return payRate;
    }

    /**
     * The pay period
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<PayPeriod> payPeriod() {
        return (JsonNullable<PayPeriod>) payPeriod;
    }

    /**
     * The pay frequency
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<PayFrequency> payFrequency() {
        return (JsonNullable<PayFrequency>) payFrequency;
    }

    /**
     * The currency used for pay
     */
    @JsonIgnore
    public JsonNullable<String> payCurrency() {
        return payCurrency;
    }

    /**
     * The effective date of the employment contract
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> effectiveDate() {
        return effectiveDate;
    }

    /**
     * The end date of employment
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endDate() {
        return endDate;
    }

    /**
     * Represents the employee’s position within the organizational hierarchy.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Grade> grade() {
        return (JsonNullable<Grade>) grade;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmploymentEmploymentType> employmentType() {
        return (JsonNullable<EmploymentEmploymentType>) employmentType;
    }

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmploymentEmploymentContractType> employmentContractType() {
        return (JsonNullable<EmploymentEmploymentContractType>) employmentContractType;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<WorkTime> workTime() {
        return (JsonNullable<WorkTime>) workTime;
    }

    /**
     * The payroll code of the employee
     */
    @JsonIgnore
    public JsonNullable<String> payrollCode() {
        return payrollCode;
    }

    /**
     * The employee ID associated with this employment
     */
    @JsonIgnore
    public JsonNullable<String> employeeId() {
        return employeeId;
    }

    /**
     * Provider's unique identifier of the employee associated with this employment
     */
    @JsonIgnore
    public JsonNullable<String> remoteEmployeeId() {
        return remoteEmployeeId;
    }

    /**
     * the employee's working percentage relative to a full-time employee
     */
    @JsonIgnore
    public JsonNullable<Double> fte() {
        return fte;
    }

    /**
     * The created_at date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The updated_at date
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * The start_date of employment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startDate() {
        return startDate;
    }

    /**
     * The employment active status
     */
    @JsonIgnore
    public JsonNullable<Boolean> active() {
        return active;
    }

    /**
     * The employee department
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmploymentDepartment> department() {
        return (JsonNullable<EmploymentDepartment>) department;
    }

    /**
     * The employee cost_center
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<CostCenter> costCenter() {
        return (JsonNullable<CostCenter>) costCenter;
    }

    /**
     * The employee cost_centers
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<HRISCostCenter>> costCenters() {
        return (JsonNullable<List<HRISCostCenter>>) costCenters;
    }

    /**
     * The employee division
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Division> division() {
        return (JsonNullable<Division>) division;
    }

    /**
     * The job of employee
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmploymentJob> job() {
        return (JsonNullable<EmploymentJob>) job;
    }

    /**
     * The type of employment
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmploymentType1> type() {
        return (JsonNullable<EmploymentType1>) type;
    }

    /**
     * The employment work schedule type
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ContractType> contractType() {
        return (JsonNullable<ContractType>) contractType;
    }

    /**
     * The employee manager
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<EmploymentManagerApiModel>> manager() {
        return (JsonNullable<List<EmploymentManagerApiModel>>) manager;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public Employment withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Employment withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Employment withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Employment withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Employment withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public Employment withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * The job title of the employee
     */
    public Employment withJobTitle(String jobTitle) {
        Utils.checkNotNull(jobTitle, "jobTitle");
        this.jobTitle = JsonNullable.of(jobTitle);
        return this;
    }

    /**
     * The job title of the employee
     */
    public Employment withJobTitle(JsonNullable<String> jobTitle) {
        Utils.checkNotNull(jobTitle, "jobTitle");
        this.jobTitle = jobTitle;
        return this;
    }

    /**
     * The pay rate for the employee
     */
    public Employment withPayRate(String payRate) {
        Utils.checkNotNull(payRate, "payRate");
        this.payRate = JsonNullable.of(payRate);
        return this;
    }

    /**
     * The pay rate for the employee
     */
    public Employment withPayRate(JsonNullable<String> payRate) {
        Utils.checkNotNull(payRate, "payRate");
        this.payRate = payRate;
        return this;
    }

    /**
     * The pay period
     */
    public Employment withPayPeriod(PayPeriod payPeriod) {
        Utils.checkNotNull(payPeriod, "payPeriod");
        this.payPeriod = JsonNullable.of(payPeriod);
        return this;
    }

    /**
     * The pay period
     */
    public Employment withPayPeriod(JsonNullable<? extends PayPeriod> payPeriod) {
        Utils.checkNotNull(payPeriod, "payPeriod");
        this.payPeriod = payPeriod;
        return this;
    }

    /**
     * The pay frequency
     */
    public Employment withPayFrequency(PayFrequency payFrequency) {
        Utils.checkNotNull(payFrequency, "payFrequency");
        this.payFrequency = JsonNullable.of(payFrequency);
        return this;
    }

    /**
     * The pay frequency
     */
    public Employment withPayFrequency(JsonNullable<? extends PayFrequency> payFrequency) {
        Utils.checkNotNull(payFrequency, "payFrequency");
        this.payFrequency = payFrequency;
        return this;
    }

    /**
     * The currency used for pay
     */
    public Employment withPayCurrency(String payCurrency) {
        Utils.checkNotNull(payCurrency, "payCurrency");
        this.payCurrency = JsonNullable.of(payCurrency);
        return this;
    }

    /**
     * The currency used for pay
     */
    public Employment withPayCurrency(JsonNullable<String> payCurrency) {
        Utils.checkNotNull(payCurrency, "payCurrency");
        this.payCurrency = payCurrency;
        return this;
    }

    /**
     * The effective date of the employment contract
     */
    public Employment withEffectiveDate(OffsetDateTime effectiveDate) {
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        this.effectiveDate = JsonNullable.of(effectiveDate);
        return this;
    }

    /**
     * The effective date of the employment contract
     */
    public Employment withEffectiveDate(JsonNullable<OffsetDateTime> effectiveDate) {
        Utils.checkNotNull(effectiveDate, "effectiveDate");
        this.effectiveDate = effectiveDate;
        return this;
    }

    /**
     * The end date of employment
     */
    public Employment withEndDate(OffsetDateTime endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = JsonNullable.of(endDate);
        return this;
    }

    /**
     * The end date of employment
     */
    public Employment withEndDate(JsonNullable<OffsetDateTime> endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = endDate;
        return this;
    }

    /**
     * Represents the employee’s position within the organizational hierarchy.
     */
    public Employment withGrade(Grade grade) {
        Utils.checkNotNull(grade, "grade");
        this.grade = JsonNullable.of(grade);
        return this;
    }

    /**
     * Represents the employee’s position within the organizational hierarchy.
     */
    public Employment withGrade(JsonNullable<? extends Grade> grade) {
        Utils.checkNotNull(grade, "grade");
        this.grade = grade;
        return this;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Employment withEmploymentType(EmploymentEmploymentType employmentType) {
        Utils.checkNotNull(employmentType, "employmentType");
        this.employmentType = JsonNullable.of(employmentType);
        return this;
    }

    /**
     * The type of employment (e.g., contractor, permanent)
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Employment withEmploymentType(JsonNullable<? extends EmploymentEmploymentType> employmentType) {
        Utils.checkNotNull(employmentType, "employmentType");
        this.employmentType = employmentType;
        return this;
    }

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Employment withEmploymentContractType(EmploymentEmploymentContractType employmentContractType) {
        Utils.checkNotNull(employmentContractType, "employmentContractType");
        this.employmentContractType = JsonNullable.of(employmentContractType);
        return this;
    }

    /**
     * The employment work schedule type (e.g., full-time, part-time)
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Employment withEmploymentContractType(JsonNullable<? extends EmploymentEmploymentContractType> employmentContractType) {
        Utils.checkNotNull(employmentContractType, "employmentContractType");
        this.employmentContractType = employmentContractType;
        return this;
    }

    public Employment withWorkTime(WorkTime workTime) {
        Utils.checkNotNull(workTime, "workTime");
        this.workTime = JsonNullable.of(workTime);
        return this;
    }

    public Employment withWorkTime(JsonNullable<? extends WorkTime> workTime) {
        Utils.checkNotNull(workTime, "workTime");
        this.workTime = workTime;
        return this;
    }

    /**
     * The payroll code of the employee
     */
    public Employment withPayrollCode(String payrollCode) {
        Utils.checkNotNull(payrollCode, "payrollCode");
        this.payrollCode = JsonNullable.of(payrollCode);
        return this;
    }

    /**
     * The payroll code of the employee
     */
    public Employment withPayrollCode(JsonNullable<String> payrollCode) {
        Utils.checkNotNull(payrollCode, "payrollCode");
        this.payrollCode = payrollCode;
        return this;
    }

    /**
     * The employee ID associated with this employment
     */
    public Employment withEmployeeId(String employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = JsonNullable.of(employeeId);
        return this;
    }

    /**
     * The employee ID associated with this employment
     */
    public Employment withEmployeeId(JsonNullable<String> employeeId) {
        Utils.checkNotNull(employeeId, "employeeId");
        this.employeeId = employeeId;
        return this;
    }

    /**
     * Provider's unique identifier of the employee associated with this employment
     */
    public Employment withRemoteEmployeeId(String remoteEmployeeId) {
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        this.remoteEmployeeId = JsonNullable.of(remoteEmployeeId);
        return this;
    }

    /**
     * Provider's unique identifier of the employee associated with this employment
     */
    public Employment withRemoteEmployeeId(JsonNullable<String> remoteEmployeeId) {
        Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
        this.remoteEmployeeId = remoteEmployeeId;
        return this;
    }

    /**
     * the employee's working percentage relative to a full-time employee
     */
    public Employment withFte(double fte) {
        Utils.checkNotNull(fte, "fte");
        this.fte = JsonNullable.of(fte);
        return this;
    }

    /**
     * the employee's working percentage relative to a full-time employee
     */
    public Employment withFte(JsonNullable<Double> fte) {
        Utils.checkNotNull(fte, "fte");
        this.fte = fte;
        return this;
    }

    /**
     * The created_at date
     */
    public Employment withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The created_at date
     */
    public Employment withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The updated_at date
     */
    public Employment withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The updated_at date
     */
    public Employment withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * The start_date of employment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Employment withStartDate(OffsetDateTime startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = JsonNullable.of(startDate);
        return this;
    }

    /**
     * The start_date of employment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Employment withStartDate(JsonNullable<OffsetDateTime> startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    /**
     * The employment active status
     */
    public Employment withActive(boolean active) {
        Utils.checkNotNull(active, "active");
        this.active = JsonNullable.of(active);
        return this;
    }

    /**
     * The employment active status
     */
    public Employment withActive(JsonNullable<Boolean> active) {
        Utils.checkNotNull(active, "active");
        this.active = active;
        return this;
    }

    /**
     * The employee department
     */
    public Employment withDepartment(EmploymentDepartment department) {
        Utils.checkNotNull(department, "department");
        this.department = JsonNullable.of(department);
        return this;
    }

    /**
     * The employee department
     */
    public Employment withDepartment(JsonNullable<? extends EmploymentDepartment> department) {
        Utils.checkNotNull(department, "department");
        this.department = department;
        return this;
    }

    /**
     * The employee cost_center
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Employment withCostCenter(CostCenter costCenter) {
        Utils.checkNotNull(costCenter, "costCenter");
        this.costCenter = JsonNullable.of(costCenter);
        return this;
    }

    /**
     * The employee cost_center
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public Employment withCostCenter(JsonNullable<? extends CostCenter> costCenter) {
        Utils.checkNotNull(costCenter, "costCenter");
        this.costCenter = costCenter;
        return this;
    }

    /**
     * The employee cost_centers
     */
    public Employment withCostCenters(List<HRISCostCenter> costCenters) {
        Utils.checkNotNull(costCenters, "costCenters");
        this.costCenters = JsonNullable.of(costCenters);
        return this;
    }

    /**
     * The employee cost_centers
     */
    public Employment withCostCenters(JsonNullable<? extends List<HRISCostCenter>> costCenters) {
        Utils.checkNotNull(costCenters, "costCenters");
        this.costCenters = costCenters;
        return this;
    }

    /**
     * The employee division
     */
    public Employment withDivision(Division division) {
        Utils.checkNotNull(division, "division");
        this.division = JsonNullable.of(division);
        return this;
    }

    /**
     * The employee division
     */
    public Employment withDivision(JsonNullable<? extends Division> division) {
        Utils.checkNotNull(division, "division");
        this.division = division;
        return this;
    }

    /**
     * The job of employee
     */
    public Employment withJob(EmploymentJob job) {
        Utils.checkNotNull(job, "job");
        this.job = JsonNullable.of(job);
        return this;
    }

    /**
     * The job of employee
     */
    public Employment withJob(JsonNullable<? extends EmploymentJob> job) {
        Utils.checkNotNull(job, "job");
        this.job = job;
        return this;
    }

    /**
     * The type of employment
     */
    public Employment withType(EmploymentType1 type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The type of employment
     */
    public Employment withType(JsonNullable<? extends EmploymentType1> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * The employment work schedule type
     */
    public Employment withContractType(ContractType contractType) {
        Utils.checkNotNull(contractType, "contractType");
        this.contractType = JsonNullable.of(contractType);
        return this;
    }

    /**
     * The employment work schedule type
     */
    public Employment withContractType(JsonNullable<? extends ContractType> contractType) {
        Utils.checkNotNull(contractType, "contractType");
        this.contractType = contractType;
        return this;
    }

    /**
     * The employee manager
     */
    public Employment withManager(List<EmploymentManagerApiModel> manager) {
        Utils.checkNotNull(manager, "manager");
        this.manager = JsonNullable.of(manager);
        return this;
    }

    /**
     * The employee manager
     */
    public Employment withManager(JsonNullable<? extends List<EmploymentManagerApiModel>> manager) {
        Utils.checkNotNull(manager, "manager");
        this.manager = manager;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Employment other = (Employment) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Utils.enhancedDeepEquals(this.jobTitle, other.jobTitle) &&
            Utils.enhancedDeepEquals(this.payRate, other.payRate) &&
            Utils.enhancedDeepEquals(this.payPeriod, other.payPeriod) &&
            Utils.enhancedDeepEquals(this.payFrequency, other.payFrequency) &&
            Utils.enhancedDeepEquals(this.payCurrency, other.payCurrency) &&
            Utils.enhancedDeepEquals(this.effectiveDate, other.effectiveDate) &&
            Utils.enhancedDeepEquals(this.endDate, other.endDate) &&
            Utils.enhancedDeepEquals(this.grade, other.grade) &&
            Utils.enhancedDeepEquals(this.employmentType, other.employmentType) &&
            Utils.enhancedDeepEquals(this.employmentContractType, other.employmentContractType) &&
            Utils.enhancedDeepEquals(this.workTime, other.workTime) &&
            Utils.enhancedDeepEquals(this.payrollCode, other.payrollCode) &&
            Utils.enhancedDeepEquals(this.employeeId, other.employeeId) &&
            Utils.enhancedDeepEquals(this.remoteEmployeeId, other.remoteEmployeeId) &&
            Utils.enhancedDeepEquals(this.fte, other.fte) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.startDate, other.startDate) &&
            Utils.enhancedDeepEquals(this.active, other.active) &&
            Utils.enhancedDeepEquals(this.department, other.department) &&
            Utils.enhancedDeepEquals(this.costCenter, other.costCenter) &&
            Utils.enhancedDeepEquals(this.costCenters, other.costCenters) &&
            Utils.enhancedDeepEquals(this.division, other.division) &&
            Utils.enhancedDeepEquals(this.job, other.job) &&
            Utils.enhancedDeepEquals(this.type, other.type) &&
            Utils.enhancedDeepEquals(this.contractType, other.contractType) &&
            Utils.enhancedDeepEquals(this.manager, other.manager);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, unifiedCustomFields,
            jobTitle, payRate, payPeriod,
            payFrequency, payCurrency, effectiveDate,
            endDate, grade, employmentType,
            employmentContractType, workTime, payrollCode,
            employeeId, remoteEmployeeId, fte,
            createdAt, updatedAt, startDate,
            active, department, costCenter,
            costCenters, division, job,
            type, contractType, manager);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Employment.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "jobTitle", jobTitle,
                "payRate", payRate,
                "payPeriod", payPeriod,
                "payFrequency", payFrequency,
                "payCurrency", payCurrency,
                "effectiveDate", effectiveDate,
                "endDate", endDate,
                "grade", grade,
                "employmentType", employmentType,
                "employmentContractType", employmentContractType,
                "workTime", workTime,
                "payrollCode", payrollCode,
                "employeeId", employeeId,
                "remoteEmployeeId", remoteEmployeeId,
                "fte", fte,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "startDate", startDate,
                "active", active,
                "department", department,
                "costCenter", costCenter,
                "costCenters", costCenters,
                "division", division,
                "job", job,
                "type", type,
                "contractType", contractType,
                "manager", manager);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();

        private JsonNullable<String> jobTitle = JsonNullable.undefined();

        private JsonNullable<String> payRate = JsonNullable.undefined();

        private JsonNullable<? extends PayPeriod> payPeriod = JsonNullable.undefined();

        private JsonNullable<? extends PayFrequency> payFrequency = JsonNullable.undefined();

        private JsonNullable<String> payCurrency = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> effectiveDate = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> endDate = JsonNullable.undefined();

        private JsonNullable<? extends Grade> grade = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<? extends EmploymentEmploymentType> employmentType = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<? extends EmploymentEmploymentContractType> employmentContractType = JsonNullable.undefined();

        private JsonNullable<? extends WorkTime> workTime = JsonNullable.undefined();

        private JsonNullable<String> payrollCode = JsonNullable.undefined();

        private JsonNullable<String> employeeId = JsonNullable.undefined();

        private JsonNullable<String> remoteEmployeeId = JsonNullable.undefined();

        private JsonNullable<Double> fte = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<OffsetDateTime> startDate = JsonNullable.undefined();

        private JsonNullable<Boolean> active = JsonNullable.undefined();

        private JsonNullable<? extends EmploymentDepartment> department = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<? extends CostCenter> costCenter = JsonNullable.undefined();

        private JsonNullable<? extends List<HRISCostCenter>> costCenters = JsonNullable.undefined();

        private JsonNullable<? extends Division> division = JsonNullable.undefined();

        private JsonNullable<? extends EmploymentJob> job = JsonNullable.undefined();

        private JsonNullable<? extends EmploymentType1> type = JsonNullable.undefined();

        private JsonNullable<? extends ContractType> contractType = JsonNullable.undefined();

        private JsonNullable<? extends List<EmploymentManagerApiModel>> manager = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }


        /**
         * The job title of the employee
         */
        public Builder jobTitle(String jobTitle) {
            Utils.checkNotNull(jobTitle, "jobTitle");
            this.jobTitle = JsonNullable.of(jobTitle);
            return this;
        }

        /**
         * The job title of the employee
         */
        public Builder jobTitle(JsonNullable<String> jobTitle) {
            Utils.checkNotNull(jobTitle, "jobTitle");
            this.jobTitle = jobTitle;
            return this;
        }


        /**
         * The pay rate for the employee
         */
        public Builder payRate(String payRate) {
            Utils.checkNotNull(payRate, "payRate");
            this.payRate = JsonNullable.of(payRate);
            return this;
        }

        /**
         * The pay rate for the employee
         */
        public Builder payRate(JsonNullable<String> payRate) {
            Utils.checkNotNull(payRate, "payRate");
            this.payRate = payRate;
            return this;
        }


        /**
         * The pay period
         */
        public Builder payPeriod(PayPeriod payPeriod) {
            Utils.checkNotNull(payPeriod, "payPeriod");
            this.payPeriod = JsonNullable.of(payPeriod);
            return this;
        }

        /**
         * The pay period
         */
        public Builder payPeriod(JsonNullable<? extends PayPeriod> payPeriod) {
            Utils.checkNotNull(payPeriod, "payPeriod");
            this.payPeriod = payPeriod;
            return this;
        }


        /**
         * The pay frequency
         */
        public Builder payFrequency(PayFrequency payFrequency) {
            Utils.checkNotNull(payFrequency, "payFrequency");
            this.payFrequency = JsonNullable.of(payFrequency);
            return this;
        }

        /**
         * The pay frequency
         */
        public Builder payFrequency(JsonNullable<? extends PayFrequency> payFrequency) {
            Utils.checkNotNull(payFrequency, "payFrequency");
            this.payFrequency = payFrequency;
            return this;
        }


        /**
         * The currency used for pay
         */
        public Builder payCurrency(String payCurrency) {
            Utils.checkNotNull(payCurrency, "payCurrency");
            this.payCurrency = JsonNullable.of(payCurrency);
            return this;
        }

        /**
         * The currency used for pay
         */
        public Builder payCurrency(JsonNullable<String> payCurrency) {
            Utils.checkNotNull(payCurrency, "payCurrency");
            this.payCurrency = payCurrency;
            return this;
        }


        /**
         * The effective date of the employment contract
         */
        public Builder effectiveDate(OffsetDateTime effectiveDate) {
            Utils.checkNotNull(effectiveDate, "effectiveDate");
            this.effectiveDate = JsonNullable.of(effectiveDate);
            return this;
        }

        /**
         * The effective date of the employment contract
         */
        public Builder effectiveDate(JsonNullable<OffsetDateTime> effectiveDate) {
            Utils.checkNotNull(effectiveDate, "effectiveDate");
            this.effectiveDate = effectiveDate;
            return this;
        }


        /**
         * The end date of employment
         */
        public Builder endDate(OffsetDateTime endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = JsonNullable.of(endDate);
            return this;
        }

        /**
         * The end date of employment
         */
        public Builder endDate(JsonNullable<OffsetDateTime> endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = endDate;
            return this;
        }


        /**
         * Represents the employee’s position within the organizational hierarchy.
         */
        public Builder grade(Grade grade) {
            Utils.checkNotNull(grade, "grade");
            this.grade = JsonNullable.of(grade);
            return this;
        }

        /**
         * Represents the employee’s position within the organizational hierarchy.
         */
        public Builder grade(JsonNullable<? extends Grade> grade) {
            Utils.checkNotNull(grade, "grade");
            this.grade = grade;
            return this;
        }


        /**
         * The type of employment (e.g., contractor, permanent)
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder employmentType(EmploymentEmploymentType employmentType) {
            Utils.checkNotNull(employmentType, "employmentType");
            this.employmentType = JsonNullable.of(employmentType);
            return this;
        }

        /**
         * The type of employment (e.g., contractor, permanent)
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder employmentType(JsonNullable<? extends EmploymentEmploymentType> employmentType) {
            Utils.checkNotNull(employmentType, "employmentType");
            this.employmentType = employmentType;
            return this;
        }


        /**
         * The employment work schedule type (e.g., full-time, part-time)
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder employmentContractType(EmploymentEmploymentContractType employmentContractType) {
            Utils.checkNotNull(employmentContractType, "employmentContractType");
            this.employmentContractType = JsonNullable.of(employmentContractType);
            return this;
        }

        /**
         * The employment work schedule type (e.g., full-time, part-time)
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder employmentContractType(JsonNullable<? extends EmploymentEmploymentContractType> employmentContractType) {
            Utils.checkNotNull(employmentContractType, "employmentContractType");
            this.employmentContractType = employmentContractType;
            return this;
        }


        public Builder workTime(WorkTime workTime) {
            Utils.checkNotNull(workTime, "workTime");
            this.workTime = JsonNullable.of(workTime);
            return this;
        }

        public Builder workTime(JsonNullable<? extends WorkTime> workTime) {
            Utils.checkNotNull(workTime, "workTime");
            this.workTime = workTime;
            return this;
        }


        /**
         * The payroll code of the employee
         */
        public Builder payrollCode(String payrollCode) {
            Utils.checkNotNull(payrollCode, "payrollCode");
            this.payrollCode = JsonNullable.of(payrollCode);
            return this;
        }

        /**
         * The payroll code of the employee
         */
        public Builder payrollCode(JsonNullable<String> payrollCode) {
            Utils.checkNotNull(payrollCode, "payrollCode");
            this.payrollCode = payrollCode;
            return this;
        }


        /**
         * The employee ID associated with this employment
         */
        public Builder employeeId(String employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = JsonNullable.of(employeeId);
            return this;
        }

        /**
         * The employee ID associated with this employment
         */
        public Builder employeeId(JsonNullable<String> employeeId) {
            Utils.checkNotNull(employeeId, "employeeId");
            this.employeeId = employeeId;
            return this;
        }


        /**
         * Provider's unique identifier of the employee associated with this employment
         */
        public Builder remoteEmployeeId(String remoteEmployeeId) {
            Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
            this.remoteEmployeeId = JsonNullable.of(remoteEmployeeId);
            return this;
        }

        /**
         * Provider's unique identifier of the employee associated with this employment
         */
        public Builder remoteEmployeeId(JsonNullable<String> remoteEmployeeId) {
            Utils.checkNotNull(remoteEmployeeId, "remoteEmployeeId");
            this.remoteEmployeeId = remoteEmployeeId;
            return this;
        }


        /**
         * the employee's working percentage relative to a full-time employee
         */
        public Builder fte(double fte) {
            Utils.checkNotNull(fte, "fte");
            this.fte = JsonNullable.of(fte);
            return this;
        }

        /**
         * the employee's working percentage relative to a full-time employee
         */
        public Builder fte(JsonNullable<Double> fte) {
            Utils.checkNotNull(fte, "fte");
            this.fte = fte;
            return this;
        }


        /**
         * The created_at date
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The created_at date
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The updated_at date
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The updated_at date
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }


        /**
         * The start_date of employment
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder startDate(OffsetDateTime startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = JsonNullable.of(startDate);
            return this;
        }

        /**
         * The start_date of employment
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder startDate(JsonNullable<OffsetDateTime> startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = startDate;
            return this;
        }


        /**
         * The employment active status
         */
        public Builder active(boolean active) {
            Utils.checkNotNull(active, "active");
            this.active = JsonNullable.of(active);
            return this;
        }

        /**
         * The employment active status
         */
        public Builder active(JsonNullable<Boolean> active) {
            Utils.checkNotNull(active, "active");
            this.active = active;
            return this;
        }


        /**
         * The employee department
         */
        public Builder department(EmploymentDepartment department) {
            Utils.checkNotNull(department, "department");
            this.department = JsonNullable.of(department);
            return this;
        }

        /**
         * The employee department
         */
        public Builder department(JsonNullable<? extends EmploymentDepartment> department) {
            Utils.checkNotNull(department, "department");
            this.department = department;
            return this;
        }


        /**
         * The employee cost_center
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder costCenter(CostCenter costCenter) {
            Utils.checkNotNull(costCenter, "costCenter");
            this.costCenter = JsonNullable.of(costCenter);
            return this;
        }

        /**
         * The employee cost_center
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder costCenter(JsonNullable<? extends CostCenter> costCenter) {
            Utils.checkNotNull(costCenter, "costCenter");
            this.costCenter = costCenter;
            return this;
        }


        /**
         * The employee cost_centers
         */
        public Builder costCenters(List<HRISCostCenter> costCenters) {
            Utils.checkNotNull(costCenters, "costCenters");
            this.costCenters = JsonNullable.of(costCenters);
            return this;
        }

        /**
         * The employee cost_centers
         */
        public Builder costCenters(JsonNullable<? extends List<HRISCostCenter>> costCenters) {
            Utils.checkNotNull(costCenters, "costCenters");
            this.costCenters = costCenters;
            return this;
        }


        /**
         * The employee division
         */
        public Builder division(Division division) {
            Utils.checkNotNull(division, "division");
            this.division = JsonNullable.of(division);
            return this;
        }

        /**
         * The employee division
         */
        public Builder division(JsonNullable<? extends Division> division) {
            Utils.checkNotNull(division, "division");
            this.division = division;
            return this;
        }


        /**
         * The job of employee
         */
        public Builder job(EmploymentJob job) {
            Utils.checkNotNull(job, "job");
            this.job = JsonNullable.of(job);
            return this;
        }

        /**
         * The job of employee
         */
        public Builder job(JsonNullable<? extends EmploymentJob> job) {
            Utils.checkNotNull(job, "job");
            this.job = job;
            return this;
        }


        /**
         * The type of employment
         */
        public Builder type(EmploymentType1 type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The type of employment
         */
        public Builder type(JsonNullable<? extends EmploymentType1> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }


        /**
         * The employment work schedule type
         */
        public Builder contractType(ContractType contractType) {
            Utils.checkNotNull(contractType, "contractType");
            this.contractType = JsonNullable.of(contractType);
            return this;
        }

        /**
         * The employment work schedule type
         */
        public Builder contractType(JsonNullable<? extends ContractType> contractType) {
            Utils.checkNotNull(contractType, "contractType");
            this.contractType = contractType;
            return this;
        }


        /**
         * The employee manager
         */
        public Builder manager(List<EmploymentManagerApiModel> manager) {
            Utils.checkNotNull(manager, "manager");
            this.manager = JsonNullable.of(manager);
            return this;
        }

        /**
         * The employee manager
         */
        public Builder manager(JsonNullable<? extends List<EmploymentManagerApiModel>> manager) {
            Utils.checkNotNull(manager, "manager");
            this.manager = manager;
            return this;
        }

        public Employment build() {

            return new Employment(
                id, remoteId, unifiedCustomFields,
                jobTitle, payRate, payPeriod,
                payFrequency, payCurrency, effectiveDate,
                endDate, grade, employmentType,
                employmentContractType, workTime, payrollCode,
                employeeId, remoteEmployeeId, fte,
                createdAt, updatedAt, startDate,
                active, department, costCenter,
                costCenters, division, job,
                type, contractType, manager);
        }

    }
}
