/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.errors.BadGatewayResponse;
import com.stackone.stackone_client_java.models.errors.BadRequestResponse;
import com.stackone.stackone_client_java.models.errors.ConflictResponse;
import com.stackone.stackone_client_java.models.errors.ForbiddenResponse;
import com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse;
import com.stackone.stackone_client_java.models.errors.NotFoundResponse;
import com.stackone.stackone_client_java.models.errors.NotImplementedResponse;
import com.stackone.stackone_client_java.models.errors.PreconditionFailedResponse;
import com.stackone.stackone_client_java.models.errors.RequestTimedOutResponse;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse;
import com.stackone.stackone_client_java.models.errors.UnauthorizedResponse;
import com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse;
import com.stackone.stackone_client_java.models.operations.HrisDownloadEmployeeDocumentRequest;
import com.stackone.stackone_client_java.models.operations.HrisDownloadEmployeeDocumentResponse;
import com.stackone.stackone_client_java.operations.Operations;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class HrisDownloadEmployeeDocumentOperation
implements Operations.RequestOperation<HrisDownloadEmployeeDocumentRequest, HrisDownloadEmployeeDocumentResponse> {
    private final SDKConfiguration sdkConfiguration;
    private final String baseUrl;
    private final SecuritySource securitySource;
    private final RetryConfig retryConfig;
    private final List<String> retryStatusCodes;
    private final HTTPClient client;

    public HrisDownloadEmployeeDocumentOperation(SDKConfiguration sdkConfiguration, Optional<Options> options) {
        this.sdkConfiguration = sdkConfiguration;
        this.baseUrl = this.sdkConfiguration.serverUrl();
        this.securitySource = this.sdkConfiguration.securitySource();
        options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
        this.retryConfig = options.flatMap(Options::retryConfig).or(this.sdkConfiguration::retryConfig).orElse(RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        this.retryStatusCodes = List.of("429", "408");
        this.client = this.sdkConfiguration.client();
    }

    private Optional<SecuritySource> securitySource() {
        return Optional.ofNullable(this.securitySource);
    }

    public HttpRequest buildRequest(HrisDownloadEmployeeDocumentRequest request) throws Exception {
        String url = Utils.generateURL(HrisDownloadEmployeeDocumentRequest.class, this.baseUrl, "/unified/hris/employees/{id}/documents/{subResourceId}/download", request, null);
        HTTPRequest req = new HTTPRequest(url, "GET");
        req.addHeader("Accept", "application/octet-stream").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        req.addQueryParams(Utils.getQueryParams(HrisDownloadEmployeeDocumentRequest.class, request, null));
        req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());
        return this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, this.baseUrl, "hris_download_employee_document", Optional.of(List.of()), this.securitySource()), req.build());
    }

    private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
        return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, this.baseUrl, "hris_download_employee_document", Optional.of(List.of()), this.securitySource()), Optional.ofNullable(response), Optional.ofNullable(error));
    }

    private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
        return this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, this.baseUrl, "hris_download_employee_document", Optional.of(List.of()), this.securitySource()), response);
    }

    @Override
    public HttpResponse<InputStream> doRequest(HrisDownloadEmployeeDocumentRequest request) throws Exception {
        Retries retries = Retries.builder().action(() -> {
            HttpRequest r;
            try {
                r = this.buildRequest(request);
            }
            catch (Exception e) {
                throw new Retries.NonRetryableException(e);
            }
            try {
                return this.client.send(r);
            }
            catch (Exception e) {
                return this.onError(null, e);
            }
        }).retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).build();
        return this.onSuccess(retries.run());
    }

    @Override
    public HrisDownloadEmployeeDocumentResponse handleResponse(HttpResponse<InputStream> response) throws Exception {
        String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
        HrisDownloadEmployeeDocumentResponse.Builder resBuilder = HrisDownloadEmployeeDocumentResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
        if (Utils.statusCodeMatches(response.statusCode(), "200") && Utils.contentTypeMatches(contentType, "application/octet-stream")) {
            resBuilder.responseStream(response.body());
        }
        HrisDownloadEmployeeDocumentResponse res = resBuilder.build();
        if (Utils.statusCodeMatches(response.statusCode(), "200")) {
            if (Utils.contentTypeMatches(contentType, "application/octet-stream")) {
                return res;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "400")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                BadRequestResponse out = (BadRequestResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<BadRequestResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "401")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                UnauthorizedResponse out = (UnauthorizedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<UnauthorizedResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "403")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                ForbiddenResponse out = (ForbiddenResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ForbiddenResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "404")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                NotFoundResponse out = (NotFoundResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<NotFoundResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "408")) {
            res.withHeaders(response.headers().map());
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                RequestTimedOutResponse out = (RequestTimedOutResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<RequestTimedOutResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "409")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                ConflictResponse out = (ConflictResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ConflictResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "412")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                PreconditionFailedResponse out = (PreconditionFailedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<PreconditionFailedResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "422")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                UnprocessableEntityResponse out = (UnprocessableEntityResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<UnprocessableEntityResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "429")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                TooManyRequestsResponse out = (TooManyRequestsResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<TooManyRequestsResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "500")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                InternalServerErrorResponse out = (InternalServerErrorResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<InternalServerErrorResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "501")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                NotImplementedResponse out = (NotImplementedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<NotImplementedResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "502")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                BadGatewayResponse out = (BadGatewayResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<BadGatewayResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
            throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
            throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
        }
        throw new SDKError(response, response.statusCode(), "Unexpected status code received: " + response.statusCode(), Utils.extractByteArrayFromBody(response));
    }
}

