/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneListPlatformLogsRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListPlatformLogsResponse;
import com.stackone.stackone_client_java.operations.StackoneListPlatformLogs;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class StackoneListPlatformLogsRequestBuilder {
    private StackoneListPlatformLogsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public StackoneListPlatformLogsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneListPlatformLogsRequestBuilder request(StackoneListPlatformLogsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public StackoneListPlatformLogsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneListPlatformLogsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public StackoneListPlatformLogsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneListPlatformLogs.Sync operation = new StackoneListPlatformLogs.Sync(this.sdkConfiguration, options);
        return (StackoneListPlatformLogsResponse)operation.handleResponse(operation.doRequest(this.request));
    }
}

