/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.rest.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.taboola.rest.api.exceptions.factories.DefaultExceptionFactory;
import com.taboola.rest.api.exceptions.factories.ExceptionFactory;
import com.taboola.rest.api.internal.CommunicationFactory;
import com.taboola.rest.api.internal.StringResponseFactories;
import com.taboola.rest.api.internal.config.CommunicationConfig;
import com.taboola.rest.api.internal.config.SerializationConfig;
import com.taboola.rest.api.internal.config.UserAgentHeader;
import com.taboola.rest.api.internal.serialization.SerializationMapperCreator;
import com.taboola.rest.api.model.RequestHeader;
import com.taboola.rest.api.model.StringResponseFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class RestAPIClient {
    private static final Logger logger = LogManager.getLogger(RestAPIClient.class);
    private final CommunicationFactory communicator;

    private RestAPIClient(CommunicationFactory communicator) {
        this.communicator = communicator;
    }

    public <E> E createRetrofitEndpoint(Class<E> endpointClazz) {
        Objects.requireNonNull(endpointClazz, "clazz");
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = endpointClazz::toString;
        logger.debug("creating endpoint using retrofit for class [{}]", supplierArray);
        return this.communicator.createRetrofitEndpoint(endpointClazz);
    }

    public static RestAPIClientBuilder builder() {
        return new RestAPIClientBuilder();
    }

    public static class RestAPIClientBuilder {
        private static final String VERSION = "1.0.1";
        private static final Integer DEFAULT_MAX_IDLE_CONNECTIONS = 5;
        private static final Long DEFAULT_KEEP_ALIVE_DURATION_MILLIS = 300000L;
        private static final SerializationConfig DEFAULT_SERIALIZATION_CONFIG = new SerializationConfig();
        private static final String DEFAULT_REST_API_VERSION = "UNDEFINED";
        private static final String DEFAULT_USER_AGENT_SUFFIX = "UNDEFINED";
        private static final String DEFAULT_USER_AGENT_PREFIX = "UNDEFINED";
        private static final ExceptionFactory DEFAULT_EXCEPTION_FACTORY = new DefaultExceptionFactory();
        private String baseUrl;
        private Long writeTimeoutMillis;
        private Long connectionTimeoutMillis;
        private Long readTimeoutMillis;
        private Integer maxIdleConnections;
        private Long keepAliveDurationMillis;
        private Boolean debug;
        private SerializationConfig serializationConfig;
        private Collection<RequestHeader> headers;
        private String userAgentPrefix;
        private String userAgentSuffix;
        private String restAPIVersion;
        private ExceptionFactory exceptionFactory;
        private ObjectMapper objectMapper;
        private final StringResponseFactories stringResponseFactories = new StringResponseFactories();

        public RestAPIClientBuilder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public RestAPIClientBuilder setUserAgentSuffix(String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public RestAPIClientBuilder setUserAgentPrefix(String userAgentPrefix) {
            this.userAgentPrefix = userAgentPrefix;
            return this;
        }

        public RestAPIClientBuilder setConnectionTimeoutMillis(Long connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public RestAPIClientBuilder setReadTimeoutMillis(Long readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public RestAPIClientBuilder setWriteTimeoutMillis(Long writeTimeoutMillis) {
            this.writeTimeoutMillis = writeTimeoutMillis;
            return this;
        }

        public RestAPIClientBuilder setMaxIdleConnections(Integer maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
            return this;
        }

        public RestAPIClientBuilder setKeepAliveDurationMillis(Long keepAliveDurationMillis) {
            this.keepAliveDurationMillis = keepAliveDurationMillis;
            return this;
        }

        public RestAPIClientBuilder setDebug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public RestAPIClientBuilder setSerializationConfig(SerializationConfig serializationConfig) {
            this.serializationConfig = serializationConfig;
            return this;
        }

        public RestAPIClientBuilder setHeaders(Collection<RequestHeader> headers) {
            this.headers = headers;
            return this;
        }

        public RestAPIClientBuilder setAPIVersion(String restAPIVersion) {
            this.restAPIVersion = restAPIVersion;
            return this;
        }

        public RestAPIClientBuilder setExceptionFactory(ExceptionFactory exceptionFactory) {
            this.exceptionFactory = exceptionFactory;
            return this;
        }

        public RestAPIClientBuilder setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public RestAPIClientBuilder addStringBodyResponseFactory(Class<?> clazz, StringResponseFactory stringResponseFactory) {
            this.stringResponseFactories.addFactory(clazz, stringResponseFactory);
            return this;
        }

        public RestAPIClient build() {
            this.organizeState();
            String finalUserAgent = String.format("%s/%s/%s (%s)", this.userAgentPrefix, this.restAPIVersion, VERSION, this.userAgentSuffix);
            Collection<RequestHeader> headers = this.getAllHeaders(this.headers, finalUserAgent);
            CommunicationConfig config = new CommunicationConfig(this.baseUrl, this.connectionTimeoutMillis, this.readTimeoutMillis, this.writeTimeoutMillis, this.maxIdleConnections, this.keepAliveDurationMillis, headers, this.debug, this.exceptionFactory, this.objectMapper, this.stringResponseFactories);
            return new RestAPIClient(new CommunicationFactory(config));
        }

        private Collection<RequestHeader> getAllHeaders(Collection<RequestHeader> clientHeaders, String finalUserAgent) {
            ArrayList<RequestHeader> headers = new ArrayList<RequestHeader>();
            if (clientHeaders != null) {
                headers.addAll(clientHeaders.stream().filter(Objects::nonNull).collect(Collectors.toList()));
            }
            headers.add(new UserAgentHeader(finalUserAgent));
            return headers;
        }

        private void organizeState() {
            if (this.baseUrl == null) {
                throw new IllegalStateException("Missing base url");
            }
            if (this.connectionTimeoutMillis == null) {
                this.connectionTimeoutMillis = 0L;
            }
            if (this.readTimeoutMillis == null) {
                this.readTimeoutMillis = 0L;
            }
            if (this.writeTimeoutMillis == null) {
                this.writeTimeoutMillis = 0L;
            }
            if (this.maxIdleConnections == null) {
                this.maxIdleConnections = DEFAULT_MAX_IDLE_CONNECTIONS;
            }
            if (this.keepAliveDurationMillis == null) {
                this.keepAliveDurationMillis = DEFAULT_KEEP_ALIVE_DURATION_MILLIS;
            }
            if (this.userAgentSuffix == null) {
                this.userAgentSuffix = "UNDEFINED";
            }
            if (this.userAgentPrefix == null) {
                this.userAgentPrefix = "UNDEFINED";
            }
            if (this.restAPIVersion == null) {
                this.restAPIVersion = "UNDEFINED";
            }
            if (this.debug == null) {
                this.debug = false;
            }
            if (this.serializationConfig == null) {
                this.serializationConfig = DEFAULT_SERIALIZATION_CONFIG;
            }
            if (this.exceptionFactory == null) {
                this.exceptionFactory = DEFAULT_EXCEPTION_FACTORY;
            }
            if (this.objectMapper == null) {
                this.objectMapper = SerializationMapperCreator.createObjectMapper(this.serializationConfig);
            }
        }
    }
}

