/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.rest.api.internal;

import com.taboola.rest.api.annotations.Final;
import com.taboola.rest.api.annotations.ReadOnly;
import com.taboola.rest.api.annotations.Required;
import com.taboola.rest.api.exceptions.RestAPIRequestException;
import com.taboola.rest.api.internal.functional.BiFunction;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldsValidator {
    private static final Logger logger = LogManager.getLogger(FieldsValidator.class);
    private static final BiFunction<Object, Field, Boolean, IllegalAccessException> FAIL_ON_NULL_FUNC = (object, field) -> field.get(object) == null;
    private static final BiFunction<Object, Field, Boolean, IllegalAccessException> FAIL_ON_NOT_NULL_FUNC = (object, field) -> field.get(object) != null;
    private static final Map<Class<?>, BiFunction<Object, Field, Boolean, IllegalAccessException>> FAIL_ON_CREATION = new HashMap();
    private static final Map<Class<?>, BiFunction<Object, Field, Boolean, IllegalAccessException>> FAIL_ON_UPDATE;

    public static void validateCreateOperation(Object obj) {
        FieldsValidator.validate(obj, FAIL_ON_CREATION);
    }

    public static void validateUpdateOperation(Object obj) {
        FieldsValidator.validate(obj, FAIL_ON_UPDATE);
    }

    private static void validate(Object obj, Map<Class<?>, BiFunction<Object, Field, Boolean, IllegalAccessException>> failOn) {
        List<Field> declaredFields = FieldsValidator.getAllFields(obj.getClass());
        for (Field field : declaredFields) {
            for (Annotation fieldAnnotation : field.getDeclaredAnnotations()) {
                Class<? extends Annotation> annotation = fieldAnnotation.annotationType();
                BiFunction<Object, Field, Boolean, IllegalAccessException> func = failOn.get(annotation);
                if (func == null) continue;
                field.setAccessible(true);
                try {
                    if (!func.apply(obj, field).booleanValue()) continue;
                    throw new RestAPIRequestException("Field '%s' is '%s'", field.getName(), annotation.getSimpleName());
                }
                catch (IllegalAccessException e) {
                    logger.error("Failed to pull field data from field [{}] for annotation [{}]", (Object)field.getName(), (Object)annotation.toString());
                }
            }
        }
    }

    private static List<Field> getAllFields(Class<?> type) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    static {
        FAIL_ON_CREATION.put(Required.class, FAIL_ON_NULL_FUNC);
        FAIL_ON_CREATION.put(Final.class, FAIL_ON_NULL_FUNC);
        FAIL_ON_CREATION.put(ReadOnly.class, FAIL_ON_NOT_NULL_FUNC);
        FAIL_ON_UPDATE = new HashMap();
        FAIL_ON_UPDATE.put(ReadOnly.class, FAIL_ON_NOT_NULL_FUNC);
        FAIL_ON_UPDATE.put(Final.class, FAIL_ON_NOT_NULL_FUNC);
    }
}

