/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.rest.api.internal.interceptors;

import com.taboola.rest.api.model.RequestHeader;
import com.taboola.rest.api.model.RequestHeadersSupplier;
import java.io.IOException;
import java.util.Collection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeadersInterceptor
implements Interceptor {
    private final RequestHeadersSupplier requestHeadersSupplier;

    public HeadersInterceptor(RequestHeadersSupplier requestHeadersSupplier) {
        this.requestHeadersSupplier = requestHeadersSupplier;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        ((Collection)this.requestHeadersSupplier.get()).stream().filter(this::validateHeader).forEach(header -> builder.header(header.getName(), header.getValue()));
        return chain.proceed(builder.build());
    }

    private boolean validateHeader(RequestHeader header) {
        return header.getName() != null && header.getValue() != null;
    }
}

