/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.api.model.payment;

import com.velopayments.api.model.payment.FxSummary;
import com.velopayments.api.model.payment.SourceAccountSummary;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PayoutSummary {
    private UUID payoutId;
    private UUID payorId;
    private String status;
    private ZonedDateTime submittedDateTime;
    private ZonedDateTime instructedDateTime;
    private Long totalPayments;
    private Long totalIncompletePayments;
    private Long totalFailedPayments;
    private List<SourceAccountSummary> sourceAccountSummary = new ArrayList<SourceAccountSummary>();
    private List<FxSummary> fxSummaries = new ArrayList<FxSummary>();
    private String payoutMemo;

    public static PayoutSummaryBuilder builder() {
        return new PayoutSummaryBuilder();
    }

    public UUID getPayoutId() {
        return this.payoutId;
    }

    public UUID getPayorId() {
        return this.payorId;
    }

    public String getStatus() {
        return this.status;
    }

    public ZonedDateTime getSubmittedDateTime() {
        return this.submittedDateTime;
    }

    public ZonedDateTime getInstructedDateTime() {
        return this.instructedDateTime;
    }

    public Long getTotalPayments() {
        return this.totalPayments;
    }

    public Long getTotalIncompletePayments() {
        return this.totalIncompletePayments;
    }

    public Long getTotalFailedPayments() {
        return this.totalFailedPayments;
    }

    public List<SourceAccountSummary> getSourceAccountSummary() {
        return this.sourceAccountSummary;
    }

    public List<FxSummary> getFxSummaries() {
        return this.fxSummaries;
    }

    public String getPayoutMemo() {
        return this.payoutMemo;
    }

    public void setPayoutId(UUID payoutId) {
        this.payoutId = payoutId;
    }

    public void setPayorId(UUID payorId) {
        this.payorId = payorId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setSubmittedDateTime(ZonedDateTime submittedDateTime) {
        this.submittedDateTime = submittedDateTime;
    }

    public void setInstructedDateTime(ZonedDateTime instructedDateTime) {
        this.instructedDateTime = instructedDateTime;
    }

    public void setTotalPayments(Long totalPayments) {
        this.totalPayments = totalPayments;
    }

    public void setTotalIncompletePayments(Long totalIncompletePayments) {
        this.totalIncompletePayments = totalIncompletePayments;
    }

    public void setTotalFailedPayments(Long totalFailedPayments) {
        this.totalFailedPayments = totalFailedPayments;
    }

    public void setSourceAccountSummary(List<SourceAccountSummary> sourceAccountSummary) {
        this.sourceAccountSummary = sourceAccountSummary;
    }

    public void setFxSummaries(List<FxSummary> fxSummaries) {
        this.fxSummaries = fxSummaries;
    }

    public void setPayoutMemo(String payoutMemo) {
        this.payoutMemo = payoutMemo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayoutSummary)) {
            return false;
        }
        PayoutSummary other = (PayoutSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$payoutId = this.getPayoutId();
        UUID other$payoutId = other.getPayoutId();
        if (this$payoutId == null ? other$payoutId != null : !((Object)this$payoutId).equals(other$payoutId)) {
            return false;
        }
        UUID this$payorId = this.getPayorId();
        UUID other$payorId = other.getPayorId();
        if (this$payorId == null ? other$payorId != null : !((Object)this$payorId).equals(other$payorId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ZonedDateTime this$submittedDateTime = this.getSubmittedDateTime();
        ZonedDateTime other$submittedDateTime = other.getSubmittedDateTime();
        if (this$submittedDateTime == null ? other$submittedDateTime != null : !((Object)this$submittedDateTime).equals(other$submittedDateTime)) {
            return false;
        }
        ZonedDateTime this$instructedDateTime = this.getInstructedDateTime();
        ZonedDateTime other$instructedDateTime = other.getInstructedDateTime();
        if (this$instructedDateTime == null ? other$instructedDateTime != null : !((Object)this$instructedDateTime).equals(other$instructedDateTime)) {
            return false;
        }
        Long this$totalPayments = this.getTotalPayments();
        Long other$totalPayments = other.getTotalPayments();
        if (this$totalPayments == null ? other$totalPayments != null : !((Object)this$totalPayments).equals(other$totalPayments)) {
            return false;
        }
        Long this$totalIncompletePayments = this.getTotalIncompletePayments();
        Long other$totalIncompletePayments = other.getTotalIncompletePayments();
        if (this$totalIncompletePayments == null ? other$totalIncompletePayments != null : !((Object)this$totalIncompletePayments).equals(other$totalIncompletePayments)) {
            return false;
        }
        Long this$totalFailedPayments = this.getTotalFailedPayments();
        Long other$totalFailedPayments = other.getTotalFailedPayments();
        if (this$totalFailedPayments == null ? other$totalFailedPayments != null : !((Object)this$totalFailedPayments).equals(other$totalFailedPayments)) {
            return false;
        }
        List<SourceAccountSummary> this$sourceAccountSummary = this.getSourceAccountSummary();
        List<SourceAccountSummary> other$sourceAccountSummary = other.getSourceAccountSummary();
        if (this$sourceAccountSummary == null ? other$sourceAccountSummary != null : !((Object)this$sourceAccountSummary).equals(other$sourceAccountSummary)) {
            return false;
        }
        List<FxSummary> this$fxSummaries = this.getFxSummaries();
        List<FxSummary> other$fxSummaries = other.getFxSummaries();
        if (this$fxSummaries == null ? other$fxSummaries != null : !((Object)this$fxSummaries).equals(other$fxSummaries)) {
            return false;
        }
        String this$payoutMemo = this.getPayoutMemo();
        String other$payoutMemo = other.getPayoutMemo();
        return !(this$payoutMemo == null ? other$payoutMemo != null : !this$payoutMemo.equals(other$payoutMemo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PayoutSummary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $payoutId = this.getPayoutId();
        result = result * 59 + ($payoutId == null ? 43 : ((Object)$payoutId).hashCode());
        UUID $payorId = this.getPayorId();
        result = result * 59 + ($payorId == null ? 43 : ((Object)$payorId).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ZonedDateTime $submittedDateTime = this.getSubmittedDateTime();
        result = result * 59 + ($submittedDateTime == null ? 43 : ((Object)$submittedDateTime).hashCode());
        ZonedDateTime $instructedDateTime = this.getInstructedDateTime();
        result = result * 59 + ($instructedDateTime == null ? 43 : ((Object)$instructedDateTime).hashCode());
        Long $totalPayments = this.getTotalPayments();
        result = result * 59 + ($totalPayments == null ? 43 : ((Object)$totalPayments).hashCode());
        Long $totalIncompletePayments = this.getTotalIncompletePayments();
        result = result * 59 + ($totalIncompletePayments == null ? 43 : ((Object)$totalIncompletePayments).hashCode());
        Long $totalFailedPayments = this.getTotalFailedPayments();
        result = result * 59 + ($totalFailedPayments == null ? 43 : ((Object)$totalFailedPayments).hashCode());
        List<SourceAccountSummary> $sourceAccountSummary = this.getSourceAccountSummary();
        result = result * 59 + ($sourceAccountSummary == null ? 43 : ((Object)$sourceAccountSummary).hashCode());
        List<FxSummary> $fxSummaries = this.getFxSummaries();
        result = result * 59 + ($fxSummaries == null ? 43 : ((Object)$fxSummaries).hashCode());
        String $payoutMemo = this.getPayoutMemo();
        result = result * 59 + ($payoutMemo == null ? 43 : $payoutMemo.hashCode());
        return result;
    }

    public String toString() {
        return "PayoutSummary(payoutId=" + this.getPayoutId() + ", payorId=" + this.getPayorId() + ", status=" + this.getStatus() + ", submittedDateTime=" + this.getSubmittedDateTime() + ", instructedDateTime=" + this.getInstructedDateTime() + ", totalPayments=" + this.getTotalPayments() + ", totalIncompletePayments=" + this.getTotalIncompletePayments() + ", totalFailedPayments=" + this.getTotalFailedPayments() + ", sourceAccountSummary=" + this.getSourceAccountSummary() + ", fxSummaries=" + this.getFxSummaries() + ", payoutMemo=" + this.getPayoutMemo() + ")";
    }

    public PayoutSummary() {
    }

    public PayoutSummary(UUID payoutId, UUID payorId, String status, ZonedDateTime submittedDateTime, ZonedDateTime instructedDateTime, Long totalPayments, Long totalIncompletePayments, Long totalFailedPayments, List<SourceAccountSummary> sourceAccountSummary, List<FxSummary> fxSummaries, String payoutMemo) {
        this.payoutId = payoutId;
        this.payorId = payorId;
        this.status = status;
        this.submittedDateTime = submittedDateTime;
        this.instructedDateTime = instructedDateTime;
        this.totalPayments = totalPayments;
        this.totalIncompletePayments = totalIncompletePayments;
        this.totalFailedPayments = totalFailedPayments;
        this.sourceAccountSummary = sourceAccountSummary;
        this.fxSummaries = fxSummaries;
        this.payoutMemo = payoutMemo;
    }

    public static class PayoutSummaryBuilder {
        private UUID payoutId;
        private UUID payorId;
        private String status;
        private ZonedDateTime submittedDateTime;
        private ZonedDateTime instructedDateTime;
        private Long totalPayments;
        private Long totalIncompletePayments;
        private Long totalFailedPayments;
        private List<SourceAccountSummary> sourceAccountSummary;
        private List<FxSummary> fxSummaries;
        private String payoutMemo;

        PayoutSummaryBuilder() {
        }

        public PayoutSummaryBuilder payoutId(UUID payoutId) {
            this.payoutId = payoutId;
            return this;
        }

        public PayoutSummaryBuilder payorId(UUID payorId) {
            this.payorId = payorId;
            return this;
        }

        public PayoutSummaryBuilder status(String status) {
            this.status = status;
            return this;
        }

        public PayoutSummaryBuilder submittedDateTime(ZonedDateTime submittedDateTime) {
            this.submittedDateTime = submittedDateTime;
            return this;
        }

        public PayoutSummaryBuilder instructedDateTime(ZonedDateTime instructedDateTime) {
            this.instructedDateTime = instructedDateTime;
            return this;
        }

        public PayoutSummaryBuilder totalPayments(Long totalPayments) {
            this.totalPayments = totalPayments;
            return this;
        }

        public PayoutSummaryBuilder totalIncompletePayments(Long totalIncompletePayments) {
            this.totalIncompletePayments = totalIncompletePayments;
            return this;
        }

        public PayoutSummaryBuilder totalFailedPayments(Long totalFailedPayments) {
            this.totalFailedPayments = totalFailedPayments;
            return this;
        }

        public PayoutSummaryBuilder sourceAccountSummary(List<SourceAccountSummary> sourceAccountSummary) {
            this.sourceAccountSummary = sourceAccountSummary;
            return this;
        }

        public PayoutSummaryBuilder fxSummaries(List<FxSummary> fxSummaries) {
            this.fxSummaries = fxSummaries;
            return this;
        }

        public PayoutSummaryBuilder payoutMemo(String payoutMemo) {
            this.payoutMemo = payoutMemo;
            return this;
        }

        public PayoutSummary build() {
            return new PayoutSummary(this.payoutId, this.payorId, this.status, this.submittedDateTime, this.instructedDateTime, this.totalPayments, this.totalIncompletePayments, this.totalFailedPayments, this.sourceAccountSummary, this.fxSummaries, this.payoutMemo);
        }

        public String toString() {
            return "PayoutSummary.PayoutSummaryBuilder(payoutId=" + this.payoutId + ", payorId=" + this.payorId + ", status=" + this.status + ", submittedDateTime=" + this.submittedDateTime + ", instructedDateTime=" + this.instructedDateTime + ", totalPayments=" + this.totalPayments + ", totalIncompletePayments=" + this.totalIncompletePayments + ", totalFailedPayments=" + this.totalFailedPayments + ", sourceAccountSummary=" + this.sourceAccountSummary + ", fxSummaries=" + this.fxSummaries + ", payoutMemo=" + this.payoutMemo + ")";
        }
    }
}

