/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.api.model.payout.v2;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SubmitPayoutRequest {
    private UUID payorId;
    private String memo;
    private List<Payment> payments = new ArrayList<Payment>();

    public static SubmitPayoutRequestBuilder builder() {
        return new SubmitPayoutRequestBuilder();
    }

    public UUID getPayorId() {
        return this.payorId;
    }

    public String getMemo() {
        return this.memo;
    }

    public List<Payment> getPayments() {
        return this.payments;
    }

    public void setPayorId(UUID payorId) {
        this.payorId = payorId;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubmitPayoutRequest)) {
            return false;
        }
        SubmitPayoutRequest other = (SubmitPayoutRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$payorId = this.getPayorId();
        UUID other$payorId = other.getPayorId();
        if (this$payorId == null ? other$payorId != null : !((Object)this$payorId).equals(other$payorId)) {
            return false;
        }
        String this$memo = this.getMemo();
        String other$memo = other.getMemo();
        if (this$memo == null ? other$memo != null : !this$memo.equals(other$memo)) {
            return false;
        }
        List<Payment> this$payments = this.getPayments();
        List<Payment> other$payments = other.getPayments();
        return !(this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubmitPayoutRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $payorId = this.getPayorId();
        result = result * 59 + ($payorId == null ? 43 : ((Object)$payorId).hashCode());
        String $memo = this.getMemo();
        result = result * 59 + ($memo == null ? 43 : $memo.hashCode());
        List<Payment> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        return result;
    }

    public String toString() {
        return "SubmitPayoutRequest(payorId=" + this.getPayorId() + ", memo=" + this.getMemo() + ", payments=" + this.getPayments() + ")";
    }

    public SubmitPayoutRequest() {
    }

    public SubmitPayoutRequest(UUID payorId, String memo, List<Payment> payments) {
        this.payorId = payorId;
        this.memo = memo;
        this.payments = payments;
    }

    public static class SubmitPayoutRequestBuilder {
        private UUID payorId;
        private String memo;
        private List<Payment> payments;

        SubmitPayoutRequestBuilder() {
        }

        public SubmitPayoutRequestBuilder payorId(UUID payorId) {
            this.payorId = payorId;
            return this;
        }

        public SubmitPayoutRequestBuilder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public SubmitPayoutRequestBuilder payments(List<Payment> payments) {
            this.payments = payments;
            return this;
        }

        public SubmitPayoutRequest build() {
            return new SubmitPayoutRequest(this.payorId, this.memo, this.payments);
        }

        public String toString() {
            return "SubmitPayoutRequest.SubmitPayoutRequestBuilder(payorId=" + this.payorId + ", memo=" + this.memo + ", payments=" + this.payments + ")";
        }
    }

    public static class Payment {
        private String remoteId;
        private String currency;
        private BigDecimal amount;
        private String memo;
        private String sourceAccountName;
        private String payorPaymentId;

        public static PaymentBuilder builder() {
            return new PaymentBuilder();
        }

        public String getRemoteId() {
            return this.remoteId;
        }

        public String getCurrency() {
            return this.currency;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public String getMemo() {
            return this.memo;
        }

        public String getSourceAccountName() {
            return this.sourceAccountName;
        }

        public String getPayorPaymentId() {
            return this.payorPaymentId;
        }

        public void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public void setMemo(String memo) {
            this.memo = memo;
        }

        public void setSourceAccountName(String sourceAccountName) {
            this.sourceAccountName = sourceAccountName;
        }

        public void setPayorPaymentId(String payorPaymentId) {
            this.payorPaymentId = payorPaymentId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payment)) {
                return false;
            }
            Payment other = (Payment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$remoteId = this.getRemoteId();
            String other$remoteId = other.getRemoteId();
            if (this$remoteId == null ? other$remoteId != null : !this$remoteId.equals(other$remoteId)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            BigDecimal this$amount = this.getAmount();
            BigDecimal other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$memo = this.getMemo();
            String other$memo = other.getMemo();
            if (this$memo == null ? other$memo != null : !this$memo.equals(other$memo)) {
                return false;
            }
            String this$sourceAccountName = this.getSourceAccountName();
            String other$sourceAccountName = other.getSourceAccountName();
            if (this$sourceAccountName == null ? other$sourceAccountName != null : !this$sourceAccountName.equals(other$sourceAccountName)) {
                return false;
            }
            String this$payorPaymentId = this.getPayorPaymentId();
            String other$payorPaymentId = other.getPayorPaymentId();
            return !(this$payorPaymentId == null ? other$payorPaymentId != null : !this$payorPaymentId.equals(other$payorPaymentId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Payment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $remoteId = this.getRemoteId();
            result = result * 59 + ($remoteId == null ? 43 : $remoteId.hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            BigDecimal $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $memo = this.getMemo();
            result = result * 59 + ($memo == null ? 43 : $memo.hashCode());
            String $sourceAccountName = this.getSourceAccountName();
            result = result * 59 + ($sourceAccountName == null ? 43 : $sourceAccountName.hashCode());
            String $payorPaymentId = this.getPayorPaymentId();
            result = result * 59 + ($payorPaymentId == null ? 43 : $payorPaymentId.hashCode());
            return result;
        }

        public String toString() {
            return "SubmitPayoutRequest.Payment(remoteId=" + this.getRemoteId() + ", currency=" + this.getCurrency() + ", amount=" + this.getAmount() + ", memo=" + this.getMemo() + ", sourceAccountName=" + this.getSourceAccountName() + ", payorPaymentId=" + this.getPayorPaymentId() + ")";
        }

        public Payment() {
        }

        public Payment(String remoteId, String currency, BigDecimal amount, String memo, String sourceAccountName, String payorPaymentId) {
            this.remoteId = remoteId;
            this.currency = currency;
            this.amount = amount;
            this.memo = memo;
            this.sourceAccountName = sourceAccountName;
            this.payorPaymentId = payorPaymentId;
        }

        public static class PaymentBuilder {
            private String remoteId;
            private String currency;
            private BigDecimal amount;
            private String memo;
            private String sourceAccountName;
            private String payorPaymentId;

            PaymentBuilder() {
            }

            public PaymentBuilder remoteId(String remoteId) {
                this.remoteId = remoteId;
                return this;
            }

            public PaymentBuilder currency(String currency) {
                this.currency = currency;
                return this;
            }

            public PaymentBuilder amount(BigDecimal amount) {
                this.amount = amount;
                return this;
            }

            public PaymentBuilder memo(String memo) {
                this.memo = memo;
                return this;
            }

            public PaymentBuilder sourceAccountName(String sourceAccountName) {
                this.sourceAccountName = sourceAccountName;
                return this;
            }

            public PaymentBuilder payorPaymentId(String payorPaymentId) {
                this.payorPaymentId = payorPaymentId;
                return this;
            }

            public Payment build() {
                return new Payment(this.remoteId, this.currency, this.amount, this.memo, this.sourceAccountName, this.payorPaymentId);
            }

            public String toString() {
                return "SubmitPayoutRequest.Payment.PaymentBuilder(remoteId=" + this.remoteId + ", currency=" + this.currency + ", amount=" + this.amount + ", memo=" + this.memo + ", sourceAccountName=" + this.sourceAccountName + ", payorPaymentId=" + this.payorPaymentId + ")";
            }
        }
    }
}

