/*
 * Decompiled with CFR 0.152.
 */
package com.versionone;

import com.versionone.DB;
import com.versionone.apiclient.HashCode;
import com.versionone.apiclient.IAssetType;
import com.versionone.apiclient.IMetaModel;
import com.versionone.apiclient.OidException;

public class Oid {
    protected static final String NullOidToken = "NULL";
    public static final Oid Null = new Oid();
    private IAssetType _type;
    private int _id;
    private Integer _moment;
    private static final String SEPARATOR = ":";

    private Oid() {
    }

    public Oid(IAssetType assetType, DB.Int id, DB.Int moment) {
        if (assetType == null) {
            throw new IllegalArgumentException("assetType");
        }
        if (id.isNull()) {
            throw new IllegalArgumentException("id cannot be DB.Null");
        }
        if (moment == null) {
            moment = new DB.Int(DB.Null);
        }
        this._type = assetType;
        this._id = id.getValue();
        this._moment = moment.getValue();
    }

    public Oid(IAssetType assetType, int id, DB.Int moment) {
        this(assetType, new DB.Int(id), moment);
    }

    public Oid(IAssetType assetType, int id, int moment) {
        this(assetType, id);
        this._moment = moment;
    }

    public Oid(IAssetType assetType, int id) {
        if (assetType == null) {
            throw new IllegalArgumentException("assetType");
        }
        this._type = assetType;
        this._id = id;
    }

    public Oid(IAssetType assetType) {
        this(assetType, new DB.Int(0), new DB.Int(DB.Null));
    }

    public IAssetType getAssetType() {
        return this._type;
    }

    public Object getKey() {
        return this._id;
    }

    public Object getMoment() {
        return this._moment;
    }

    public boolean isNull() {
        return this == Null;
    }

    public String getToken() {
        if (this.isNull()) {
            return NullOidToken;
        }
        StringBuilder res = new StringBuilder();
        res.append(this._type.getToken()).append(SEPARATOR).append(this._id);
        if (this.hasMoment()) {
            res.append(SEPARATOR).append(this._moment);
        }
        return res.toString();
    }

    public String toString() {
        return this.getToken();
    }

    public static Oid fromToken(String oidtoken, IMetaModel meta) throws OidException {
        try {
            if (oidtoken.equals(NullOidToken)) {
                return Null;
            }
            String[] parts = oidtoken.split(SEPARATOR);
            IAssetType type = meta.getAssetType(parts[0]);
            int id = Integer.parseInt(parts[1]);
            if (parts.length > 2) {
                int moment = Integer.parseInt(parts[2]);
                return new Oid(type, id, moment);
            }
            return new Oid(type, id);
        }
        catch (Exception e) {
            throw new OidException("Invalid OID token", oidtoken, e);
        }
    }

    public Oid getMomentless() {
        return this.hasMoment() ? new Oid(this._type, this._id) : this;
    }

    public boolean hasMoment() {
        return this._moment != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Oid)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Oid other = (Oid)obj;
        if (this.isNull() || other.isNull()) {
            return false;
        }
        if (!this._type.getToken().equals(other._type.getToken()) || this._id != other._id) {
            return false;
        }
        if (!this.hasMoment()) {
            return !other.hasMoment();
        }
        return this._moment.equals(other._moment);
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        if (this._moment == null) {
            return HashCode.Hash((int)this._type.getToken().hashCode(), (int)this._id);
        }
        return HashCode.Hash((int)this._type.getToken().hashCode(), (int)this._id, (int)this._moment.hashCode());
    }

    public static boolean compare(Oid lhs, Oid rhs) {
        if (lhs == null || rhs == null) {
            return lhs == rhs;
        }
        return lhs.equals(rhs);
    }
}

