/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.AssetID;
import com.versionone.om.Entity;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.MetaRenamedAttribute;
import com.versionone.om.Project;
import com.versionone.om.TestSet;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.TestSetFilter;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Environment")
public class Environment
extends Entity {
    protected static final int STATE_CLOSED = 128;
    protected static final int STATE_ACTIVE = 64;

    protected Environment(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    protected Environment(V1Instance instance) {
        super(instance);
    }

    public String getName() {
        return (String)this.get("Name");
    }

    public void setName(String name) {
        this.set("Name", name);
    }

    @MetaRenamedAttribute(value="Scope")
    public Project getProject() {
        return this.getRelation(Project.class, "Scope");
    }

    public void setProject(Project project) {
        this.setRelation("Scope", project);
    }

    @MetaRenamedAttribute(value="Number")
    public String getDisplayID() {
        return (String)this.get("Number");
    }

    public Collection<TestSet> getTestSets(TestSetFilter filter) {
        filter = filter != null ? filter : new TestSetFilter();
        filter.environment.clear();
        filter.environment.add(this);
        return this.getInstance().get().testSets(filter);
    }

    public boolean isActive() {
        return this.isActiveImpl();
    }

    public boolean isClosed() {
        return this.isClosedImpl();
    }

    boolean isActiveImpl() {
        return this.get("AssetState", true).equals(64);
    }

    boolean isClosedImpl() {
        return this.get("AssetState", true).equals(128);
    }

    public boolean canClose() {
        return this.canCloseImpl();
    }

    boolean canCloseImpl() {
        return this.getInstance().canExecuteOperation(this, "Inactivate");
    }

    public void close() throws UnsupportedOperationException {
        this.save();
        this.closeImpl();
        this.clearCache("AssetState");
    }

    void closeImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Inactivate");
    }

    public boolean canReactivate() {
        return this.canReactivateImpl();
    }

    boolean canReactivateImpl() {
        return this.getInstance().canExecuteOperation(this, "Reactivate");
    }

    public void reactivate() throws UnsupportedOperationException {
        this.reactivateImpl();
        this.save();
        this.clearCache("AssetState");
    }

    void reactivateImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Reactivate");
    }
}

