/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.Oid;
import com.versionone.apiclient.APIException;
import com.versionone.apiclient.AndFilterTerm;
import com.versionone.apiclient.Asset;
import com.versionone.apiclient.AssetState;
import com.versionone.apiclient.AttachmentLengthException;
import com.versionone.apiclient.Attribute;
import com.versionone.apiclient.AttributeSelection;
import com.versionone.apiclient.ConnectionException;
import com.versionone.apiclient.FilterTerm;
import com.versionone.apiclient.IAssetType;
import com.versionone.apiclient.IAttachments;
import com.versionone.apiclient.IAttributeDefinition;
import com.versionone.apiclient.IFilterTerm;
import com.versionone.apiclient.ILocalizer;
import com.versionone.apiclient.IMetaModel;
import com.versionone.apiclient.IOperation;
import com.versionone.apiclient.IServices;
import com.versionone.apiclient.IV1Configuration;
import com.versionone.apiclient.MetaException;
import com.versionone.apiclient.OidException;
import com.versionone.apiclient.OrderBy;
import com.versionone.apiclient.Query;
import com.versionone.apiclient.QueryResult;
import com.versionone.apiclient.RequiredFieldValidator;
import com.versionone.apiclient.V1Exception;
import com.versionone.om.ApiClientInternals;
import com.versionone.om.ApplicationUnavailableException;
import com.versionone.om.AssetID;
import com.versionone.om.Attachment;
import com.versionone.om.AttachmentLengthExceededException;
import com.versionone.om.AuthenticationException;
import com.versionone.om.BaseAsset;
import com.versionone.om.CookiesManager;
import com.versionone.om.DataException;
import com.versionone.om.Defect;
import com.versionone.om.Entity;
import com.versionone.om.EntityCollection;
import com.versionone.om.EntityValidationException;
import com.versionone.om.EntityValidator;
import com.versionone.om.InstanceConfiguration;
import com.versionone.om.Member;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.Project;
import com.versionone.om.ProxySettings;
import com.versionone.om.Rank;
import com.versionone.om.SDKException;
import com.versionone.om.SecondaryWorkitem;
import com.versionone.om.Story;
import com.versionone.om.Team;
import com.versionone.om.TestSuite;
import com.versionone.om.TrackingLevel;
import com.versionone.om.V1InstanceCreator;
import com.versionone.om.V1InstanceGetter;
import com.versionone.om.Workitem;
import com.versionone.om.WrapperManager;
import com.versionone.om.filters.EntityFilter;
import com.versionone.om.listvalue.CustomListValue;
import com.versionone.om.listvalue.ListValue;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V1Instance {
    private static final String ATTACHMENT_V1 = "attachment.v1/";
    private static final String ASSETDETAIL_V1_OID = "assetdetail.v1/?oid=";
    private final Map<Object, Asset> assetCache = new HashMap<Object, Asset>();
    private ApiClientInternals apiClientInternals;
    private final WrapperManager wrapperManager;
    private V1InstanceGetter getter;
    private V1InstanceCreator creator;
    private InstanceConfiguration configuration;
    private boolean isValidationEnabled = false;

    public V1Instance(String applicationPath) {
        this(applicationPath, null, null);
    }

    public V1Instance(String applicationPath, String userName, String password) {
        this(applicationPath, userName, password, null);
    }

    public V1Instance(String applicationPath, String userName, String password, ProxySettings proxySettings) {
        if (!applicationPath.endsWith("/")) {
            applicationPath = applicationPath + "/";
        }
        this.apiClientInternals = new ApiClientInternals(applicationPath, userName, password, proxySettings);
        this.wrapperManager = new WrapperManager(this);
    }

    public Map<String, String> getCustomHttpHeaders() {
        return this.apiClientInternals.getCustomHttpHeaders();
    }

    public CookiesManager getCookiesJar() {
        return this.apiClientInternals.getCookiesJar();
    }

    public void validate() throws AuthenticationException, ApplicationUnavailableException {
        this.apiClientInternals.validate();
    }

    IMetaModel getMetaModel() {
        return this.apiClientInternals.getMetaModel();
    }

    private ILocalizer getLocalizer() {
        return this.apiClientInternals.getLocalizer();
    }

    IServices getServices() {
        return this.apiClientInternals.getServices();
    }

    private IAttachments getAttachments() {
        return this.apiClientInternals.getAttachments();
    }

    private IV1Configuration getV1Config() {
        return this.apiClientInternals.getV1Config();
    }

    public InstanceConfiguration getConfiguration() throws ApplicationUnavailableException, SDKException {
        if (this.configuration == null) {
            try {
                this.configuration = new InstanceConfiguration(this.getV1Config().isEffortTracking(), TrackingLevel.valueOf(this.getV1Config().getStoryTrackingLevel()), TrackingLevel.valueOf(this.getV1Config().getDefectTrackingLevel()), this.getV1Config().getMaxAttachmentSize());
            }
            catch (ConnectionException e) {
                throw new ApplicationUnavailableException(e);
            }
            catch (APIException e) {
                throw new SDKException("Cannot get configuration.", e);
            }
        }
        return this.configuration;
    }

    public boolean isValidationEnabled() {
        return this.isValidationEnabled;
    }

    public void setValidationEnabled(boolean status) {
        this.isValidationEnabled = status;
    }

    public Member getLoggedInMember() {
        try {
            return this.get().memberByID(AssetID.valueOf(this.getServices().getLoggedIn().getToken()));
        }
        catch (ConnectionException e) {
            throw new ApplicationUnavailableException(e);
        }
        catch (V1Exception e) {
            throw new SDKException("Cannot get logged in Members.", e);
        }
    }

    public Collection<Project> getProjects() {
        IAssetType projectAssetType = this.getMetaModel().getAssetType("Scope");
        Query query = new Query(projectAssetType, projectAssetType.getAttributeDefinition("Parent"));
        FilterTerm assetStateTerm = new FilterTerm(projectAssetType.getAttributeDefinition("AssetState"));
        assetStateTerm.notEqual(new Object[]{AssetState.Closed});
        query.setFilter((IFilterTerm)new AndFilterTerm(new IFilterTerm[]{assetStateTerm}));
        query.getOrderBy().majorSort(projectAssetType.getAttributeDefinition("Name"), OrderBy.Order.Ascending);
        return this.queryToEntityEnum(Project.class, query);
    }

    public Collection<Member> getMembers() {
        IAssetType memberAssetType = this.getMetaModel().getAssetType("Member");
        Query query = new Query(memberAssetType);
        FilterTerm assetStateTerm = new FilterTerm(memberAssetType.getAttributeDefinition("AssetState"));
        assetStateTerm.notEqual(new Object[]{AssetState.Closed});
        query.setFilter((IFilterTerm)new AndFilterTerm(new IFilterTerm[]{assetStateTerm}));
        query.getOrderBy().majorSort(memberAssetType.getAttributeDefinition("Name"), OrderBy.Order.Ascending);
        return this.queryToEntityEnum(Member.class, query);
    }

    public Collection<Team> getTeams() {
        IAssetType teamAssetType = this.getMetaModel().getAssetType("Team");
        Query query = new Query(teamAssetType);
        FilterTerm assetStateTerm = new FilterTerm(teamAssetType.getAttributeDefinition("AssetState"));
        assetStateTerm.notEqual(new Object[]{AssetState.Closed});
        query.setFilter((IFilterTerm)new AndFilterTerm(new IFilterTerm[]{assetStateTerm}));
        query.getOrderBy().majorSort(teamAssetType.getAttributeDefinition("Name"), OrderBy.Order.Ascending);
        return this.queryToEntityEnum(Team.class, query);
    }

    public Collection<TestSuite> getTestSuites() {
        IAssetType teamAssetType = this.getMetaModel().getAssetType("TestSuite");
        Query query = new Query(teamAssetType);
        FilterTerm assetStateTerm = new FilterTerm(teamAssetType.getAttributeDefinition("AssetState"));
        assetStateTerm.notEqual(new Object[]{AssetState.Closed});
        query.setFilter((IFilterTerm)new AndFilterTerm(new IFilterTerm[]{assetStateTerm}));
        query.getOrderBy().majorSort(teamAssetType.getAttributeDefinition("Name"), OrderBy.Order.Ascending);
        return this.queryToEntityEnum(TestSuite.class, query);
    }

    public ApiClientInternals getApiClient() {
        return this.apiClientInternals;
    }

    public void setApiClient(ApiClientInternals apiClient) {
        this.apiClientInternals = apiClient;
    }

    private static AttributeSelection flattenSelection(IAssetType querytype, List<IAttributeDefinition> orig) {
        AttributeSelection selection = new AttributeSelection();
        for (IAttributeDefinition definition : orig) {
            IAttributeDefinition newDefinition = null;
            if (definition.getAssetType().isA(querytype)) {
                newDefinition = definition.getBase() == null || definition.getAssetType().equals(querytype) ? definition : (definition.getBase().getAssetType().isA(querytype) ? definition.getBase() : querytype.getAttributeDefinition(definition.getName()));
            } else if (querytype.isA(definition.getAssetType())) {
                newDefinition = querytype.getAttributeDefinition(definition.getName());
            }
            if (newDefinition == null || selection.contains((Object)newDefinition)) continue;
            selection.add((Object)newDefinition);
        }
        return selection;
    }

    private static List<IAttributeDefinition> getSuggestedSelection(IAssetType assetType, Class<? extends Entity> type) {
        AttributeSelection result = new AttributeSelection();
        for (Class<? extends Entity> curType = type; curType != null; curType = curType.getSuperclass()) {
            String[] attributesNames;
            String names;
            MetaDataAttribute attributes = curType.getAnnotation(MetaDataAttribute.class);
            if (attributes == null || (names = attributes.defaultAttributeSelectionNames()) == null || names.trim().length() == 0) continue;
            for (String name : attributesNames = names.split(",")) {
                IAttributeDefinition def = assetType.getAttributeDefinition(name);
                if (def == null || result.contains((Object)def)) continue;
                result.add((Object)def);
            }
        }
        return result;
    }

    <T extends Entity> Collection<T> queryToEntityEnum(Class<T> clazz, Query query) throws ApplicationUnavailableException, SDKException {
        try {
            AttributeSelection assetStateSelection = new AttributeSelection();
            try {
                IAttributeDefinition assetStateDef = query.getAssetType().getAttributeDefinition("AssetState");
                assetStateSelection.add((Object)assetStateDef);
            }
            catch (MetaException e) {
                // empty catch block
            }
            List<IAttributeDefinition> suggestedSelection = V1Instance.getSuggestedSelection(query.getAssetType(), clazz);
            AttributeSelection flattenedSelection = V1Instance.flattenSelection(query.getAssetType(), (List<IAttributeDefinition>)query.getSelection());
            query.setSelection(AttributeSelection.merge((List[])new List[]{assetStateSelection, suggestedSelection, flattenedSelection}));
            return this.assetEnumToEntityEnum(clazz, this.getServices().retrieve(query).getAssets());
        }
        catch (ConnectionException e) {
            throw new ApplicationUnavailableException(e);
        }
        catch (V1Exception e) {
            throw new SDKException("Cannot execute query.", e);
        }
    }

    private <T extends Entity> Collection<T> assetEnumToEntityEnum(Class<T> clazz, Asset[] assets) {
        LinkedList<T> members = new LinkedList<T>();
        for (Asset asset : assets) {
            AssetID id = new AssetID(asset.getOid().getToken());
            this.setAsset(id, asset);
            T wrapped = this.createWrapper(clazz, id, false);
            if (wrapped == null) continue;
            members.add(wrapped);
        }
        return Collections.unmodifiableList(members);
    }

    RequiredFieldValidator getRequiredFieldValidator() {
        return new RequiredFieldValidator(this.getMetaModel(), this.getServices());
    }

    AssetID commit(Entity entity, String comment) throws DataException, ApplicationUnavailableException, EntityValidationException {
        try {
            Asset asset = this.getAsset(entity);
            this.validateEntity(entity, asset);
            this.getServices().save(asset, comment);
            asset.setOid(asset.getOid().getMomentless());
            AssetID assetId = new AssetID(asset.getOid().getToken());
            this.setAsset(assetId, asset);
            return assetId;
        }
        catch (ConnectionException e) {
            if (e.getServerResponseCode() == -1) {
                throw new ApplicationUnavailableException(this.getLocalizer().resolve(e.getMessage()), e);
            }
            throw new DataException(this.getLocalizer().resolve(e.getMessage()), e);
        }
        catch (V1Exception e) {
            throw new DataException(this.getLocalizer().resolve(e.getMessage()), e);
        }
    }

    private void validateEntity(Entity entity, Asset asset) throws ConnectionException, APIException, OidException {
        EntityValidator validator;
        List<String> invalidAttributes;
        if (this.isValidationEnabled && (invalidAttributes = (validator = new EntityValidator(this)).validate(asset)).size() > 0) {
            throw new EntityValidationException(entity, invalidAttributes);
        }
    }

    <T extends Entity> T createNew(Class<T> clazz, Entity inTheContextOf) throws SDKException {
        Asset shell;
        Oid contextOid = this.getOid(inTheContextOf);
        String assetTypeToken = V1Instance.getAssetTypeToken(clazz);
        IAssetType typeToCreate = this.getMetaModel().getAssetType(assetTypeToken);
        try {
            shell = this.getServices().createNew(typeToCreate, contextOid);
        }
        catch (V1Exception e) {
            throw new SDKException("Cannot create new Entity:" + clazz.getSimpleName(), e);
        }
        T result = this.createWrapper(clazz);
        this.setAsset(((Entity)result).getInstanceKey(), shell);
        return result;
    }

    String getEntityURL(Entity entity) {
        if (entity instanceof TestSuite) {
            return null;
        }
        if (entity instanceof BaseAsset || entity instanceof Attachment) {
            return this.apiClientInternals.getApplicationPath() + ASSETDETAIL_V1_OID + entity.getID();
        }
        return null;
    }

    String getAttachmentURL(Attachment attachment) {
        return this.apiClientInternals.getApplicationPath() + ATTACHMENT_V1 + this.getOid(attachment).getKey();
    }

    boolean canExecuteOperation(Entity subject, String operationName) throws SDKException {
        try {
            Asset asset = this.getAsset(subject);
            IOperation toExecute = asset.getAssetType().getOperation(operationName);
            return (Boolean)this.retrieveAttribute(asset.getOid(), toExecute.getValidatorAttribute(), false).getValue();
        }
        catch (APIException e) {
            throw new SDKException(e);
        }
    }

    <T extends Entity> T executeOperation(Class<T> clazz, Entity subject, String operationName) throws UnsupportedOperationException {
        Oid operationResult = this.executeOperation(subject, operationName);
        AssetID id = new AssetID(operationResult.getToken());
        return this.createWrapper(clazz, id, false);
    }

    Oid executeOperation(Entity subject, String operationName) throws UnsupportedOperationException {
        Asset asset = this.getAsset(subject);
        return this.executeOperation(asset, operationName);
    }

    private Oid executeOperation(Asset subject, String operationName) throws UnsupportedOperationException {
        try {
            IOperation toExecute = subject.getAssetType().getOperation(operationName);
            Oid result = this.getServices().executeOperation(toExecute, subject.getOid());
            return result.getMomentless();
        }
        catch (APIException e) {
            throw new UnsupportedOperationException(operationName, e);
        }
    }

    private Oid getOid(Entity entity) {
        if (entity == null) {
            return Oid.Null;
        }
        Asset contextAsset = this.getAsset(entity);
        return contextAsset.getOid();
    }

    private Asset getAsset(Oid oid) {
        return this.getAsset(new AssetID(oid.getToken()), oid.getAssetType().getToken());
    }

    private Asset getAsset(Entity entity) {
        return this.getAsset(entity.getInstanceKey(), V1Instance.getAssetTypeToken(entity.getClass()));
    }

    private Asset getAsset(Object id, String assetTypeToken) {
        Asset result = this.assetCache.get(id);
        if (result == null) {
            try {
                IAssetType assetType = this.getMetaModel().getAssetType(assetTypeToken);
                if (id instanceof AssetID) {
                    AssetID assetId = (AssetID)id;
                    result = new Asset(Oid.fromToken(assetId.getToken(), this.getMetaModel()));
                } else {
                    result = new Asset(assetType);
                }
                this.setAsset(id, result);
            }
            catch (OidException e) {
                throw new ApplicationUnavailableException(e);
            }
        }
        return result;
    }

    public Asset getAsset(Object id) {
        return this.assetCache.get(id);
    }

    public void setAsset(Object id, Asset asset) {
        this.assetCache.put(id, asset);
    }

    static <T extends Entity> String getDefaultOrderByToken(Class<T> entityType) {
        MetaDataAttribute attribute = entityType.getAnnotation(MetaDataAttribute.class);
        if (attribute != null) {
            return attribute.defaultOrderByToken();
        }
        throw new SDKException("Missing MetaDataAttribute on type " + entityType.getName());
    }

    static <T extends Entity> String getAssetTypeToken(Class<T> entityType) {
        MetaDataAttribute attribute = entityType.getAnnotation(MetaDataAttribute.class);
        if (attribute != null) {
            return attribute.value();
        }
        throw new SDKException("Missing MetaDataAttribute on type " + entityType.getName());
    }

    private <T extends Entity> T createWrapper(Class<T> clazz) {
        return this.wrapperManager.create(clazz);
    }

    private <T extends Entity> T createWrapper(Class<T> clazz, AssetID id, boolean validate) {
        return this.wrapperManager.create(clazz, id, validate);
    }

    private Attribute retrieveAttribute(Oid oid, IAttributeDefinition def, boolean cachable) throws SDKException {
        Query query = new Query(oid);
        query.getSelection().add((Object)def);
        try {
            QueryResult queryResult = this.getServices().retrieve(query);
            Asset asset = queryResult.getAssets()[0];
            if (!cachable) {
                return asset.getAttribute(def);
            }
            Asset cached = this.getAsset(asset.getOid());
            Attribute attribute = cached.ensureAttribute(def);
            if (def.isMultiValue()) {
                for (Object value : asset.getAttribute(def).getValues()) {
                    cached.loadAttributeValue(def, value);
                }
            } else {
                cached.loadAttributeValue(def, asset.getAttribute(def).getValue());
            }
            attribute.acceptChanges();
            return attribute;
        }
        catch (V1Exception e) {
            throw new SDKException(e);
        }
    }

    private Attribute getAttribute(Entity entity, String name, boolean cachable) {
        Attribute attribute;
        Asset asset = this.getAsset(entity);
        IAttributeDefinition def = asset.getAssetType().getAttributeDefinition(name);
        Attribute attribute2 = attribute = cachable ? asset.getAttribute(def) : null;
        if (attribute == null) {
            attribute = this.retrieveAttribute(asset.getOid(), def, cachable);
        }
        return attribute;
    }

    void clearCache(Entity entity, String name) {
        Asset asset = this.getAsset(entity);
        IAttributeDefinition def = null;
        if (name != null) {
            def = asset.getAssetType().getAttributeDefinition(name);
        }
        asset.clearAttributeCache(def);
    }

    boolean isAttributeExists(Entity entity, String name) {
        Asset asset = this.getAsset(entity);
        try {
            return asset.getAssetType().getAttributeDefinition(name) != null;
        }
        catch (MetaException e) {
            return false;
        }
    }

    InputStream getReader(Entity entity) throws ApplicationUnavailableException {
        Oid oid = this.getOid(entity);
        try {
            return this.getAttachments().getReader(oid.getKey().toString());
        }
        catch (ConnectionException e) {
            throw new ApplicationUnavailableException(e);
        }
    }

    OutputStream getWriter(Entity entity, String contentType) throws ApplicationUnavailableException {
        Oid oid = this.getOid(entity);
        try {
            return this.getAttachments().getWriter(oid.getKey().toString(), contentType);
        }
        catch (ConnectionException e) {
            throw new ApplicationUnavailableException(e);
        }
    }

    void commitWriteStream(Entity entity) throws ApplicationUnavailableException, AttachmentLengthExceededException {
        Oid oid = this.getOid(entity);
        try {
            this.getAttachments().setWriter(oid.getKey().toString());
        }
        catch (AttachmentLengthException e) {
            throw new AttachmentLengthExceededException(e);
        }
        catch (ConnectionException e) {
            throw new ApplicationUnavailableException(e);
        }
    }

    Object getProperty(Entity entity, String name, boolean cachable) throws SDKException {
        try {
            return this.getAttribute(entity, name, cachable).getValue();
        }
        catch (APIException e) {
            throw new SDKException("Cannot get property:" + name + " for:" + entity, e);
        }
    }

    void setProperty(Entity entity, String name, Object value) throws SDKException {
        Asset asset = this.getAsset(entity);
        IAttributeDefinition def = asset.getAssetType().getAttributeDefinition(name);
        try {
            asset.setAttributeValue(def, value);
        }
        catch (APIException e) {
            throw new SDKException("Cannot set property:" + name + " for:" + entity, e);
        }
    }

    <T extends Entity> T getRelation(Entity entity, Class<T> clazz, String name, boolean cachable) {
        Oid oid = (Oid)this.getProperty(entity, name, cachable);
        if (oid.isNull()) {
            return null;
        }
        return this.createWrapper(clazz, new AssetID(oid.getToken()), false);
    }

    <T extends Entity> void setRelation(Entity entity, String name, T value) throws SDKException {
        Oid oid;
        try {
            oid = value == null ? Oid.Null : Oid.fromToken(value.getID().getToken(), this.getMetaModel());
        }
        catch (OidException e) {
            throw new SDKException("Cannot set relation:" + name + " for:" + entity, e);
        }
        this.setProperty(entity, name, oid);
    }

    <T extends Entity> void addRelation(Entity entity, String name, T value) throws SDKException {
        Asset asset = this.getAsset(entity);
        IAttributeDefinition def = asset.getAssetType().getAttributeDefinition(name);
        try {
            Oid oid = Oid.fromToken(value.getID().getToken(), this.getMetaModel());
            asset.addAttributeValue(def, (Object)oid);
        }
        catch (V1Exception e) {
            throw new SDKException("Cannot add relation:" + name + " for:" + entity, e);
        }
    }

    <T extends Entity> void removeRelation(Entity entity, String name, T value) throws SDKException {
        Asset asset = this.getAsset(entity);
        IAttributeDefinition def = asset.getAssetType().getAttributeDefinition(name);
        try {
            Oid oid = Oid.fromToken(value.getID().getToken(), this.getMetaModel());
            asset.removeAttributeValue(def, (Object)oid);
        }
        catch (V1Exception e) {
            throw new SDKException("Cannot remove relation:" + name + " for:" + entity, e);
        }
    }

    <T extends Entity> EntityCollection<T> getMultiRelation(Entity entity, String name, boolean cachable) {
        return new EntityCollection(this, entity, name, name);
    }

    <T extends Entity> EntityCollection<T> getMultiRelation(Entity entity, String readName, String writeName, boolean cachable) {
        return new EntityCollection(this, entity, readName, writeName);
    }

    <T extends Entity> boolean multiRelationContains(Entity entity, String attributeName, T value) {
        return this.internalGetMultiRelation(entity, attributeName, value.getClass()).contains(value);
    }

    int getMultiRelationCount(Entity entity, String attributeName) {
        Double valueDouble = (Double)this.getProperty(entity, attributeName + ".@Count", false);
        return valueDouble.intValue();
    }

    <T extends Entity> Collection<T> internalGetMultiRelation(Entity entity, String attributeName, Class<T> clazz) {
        Object[] oids = this.getAttribute(entity, attributeName, false).getValues();
        return this.oidEnumToEntityCollection(Arrays.asList(oids), clazz);
    }

    private <T extends Entity> Collection<T> oidEnumToEntityCollection(List<Object> oids, Class<T> clazz) {
        LinkedList<T> members = new LinkedList<T>();
        for (Object oid : oids) {
            AssetID id = new AssetID(((Oid)oid).getToken());
            T tWrapper = this.createWrapper(clazz, id, false);
            if (tWrapper == null) continue;
            members.add(tWrapper);
        }
        return Collections.unmodifiableList(members);
    }

    boolean isMultiRelationIsReadOnly(Entity entity, String attributeName) {
        return this.getMetaModel().getAssetType(V1Instance.getAssetTypeToken(entity.getClass())).getAttributeDefinition(attributeName).isReadOnly();
    }

    public <T extends ListValue> T getListValueByName(Class<T> clazz, String value) {
        String typeToken = V1Instance.getAssetTypeToken(clazz);
        IAssetType listType = this.getMetaModel().getAssetType(typeToken);
        return this.getListValueByName(listType, value, clazz);
    }

    private <T extends ListValue> T getListValueByName(IAssetType listType, String value, Class<T> listValuesClass) throws SDKException {
        QueryResult result;
        IAttributeDefinition nameDef = listType.getAttributeDefinition("Name");
        Query query = new Query(listType);
        FilterTerm nameTerm = new FilterTerm(nameDef);
        nameTerm.equal(new Object[]{value});
        query.setFilter((IFilterTerm)nameTerm);
        query.getOrderBy().majorSort(nameDef, OrderBy.Order.Ascending);
        try {
            result = this.getServices().retrieve(query);
        }
        catch (V1Exception e) {
            throw new SDKException("Cannot getListValueByName:" + value, e);
        }
        if (result.getAssets().length == 0) {
            throw new IndexOutOfBoundsException("There is no " + value + " value with name: " + listType.getToken());
        }
        return (T)((ListValue)this.createWrapper(listValuesClass, new AssetID(result.getAssets()[0].getOid().getToken()), false));
    }

    <T extends ListValue> void setListRelation(Entity entity, String name, String value, Class<T> valuesClass) {
        T valueEntity = null;
        if (value != null) {
            valueEntity = this.getListValueByName(valuesClass, value);
        }
        this.setRelation(entity, name, valueEntity);
    }

    void setCustomListRelation(Entity entity, String name, String value) {
        CustomListValue valueEntity = null;
        if (value != null) {
            valueEntity = this.getCustomListValueByName(entity, name, value);
        }
        this.setRelation(entity, name, valueEntity);
    }

    CustomListValue getCustomListValueByName(Entity entity, String name, String value) {
        IAssetType relatedType = this.getRelatedType(entity, name);
        return this.getListValueByName(relatedType, value, CustomListValue.class);
    }

    private IAssetType getRelatedType(Entity entity, String name) {
        IAssetType owningType = this.getMetaModel().getAssetType(V1Instance.getAssetTypeToken(entity.getClass()));
        IAttributeDefinition listTypeDef = owningType.getAttributeDefinition(name);
        return listTypeDef.getRelatedAsset();
    }

    CustomListValue getCustomRelation(Entity entity, String name) {
        return this.getCustomRelation(entity, name, true);
    }

    CustomListValue getCustomRelation(Entity entity, String name, boolean cachable) {
        return this.getRelation(entity, CustomListValue.class, name, cachable);
    }

    public Object getPropertyOnCustomType(CustomListValue entity, String name, boolean cachable) throws SDKException {
        try {
            return this.getAttributeOnCustomType(entity, name, cachable).getValue();
        }
        catch (APIException e) {
            throw new SDKException("Cannot get property:" + name, e);
        }
    }

    private Attribute getAttributeOnCustomType(Entity entity, String name, boolean cachable) throws SDKException {
        Attribute attribute;
        Asset asset;
        try {
            asset = this.getAsset(Oid.fromToken(entity.getID().getToken(), this.getMetaModel()));
        }
        catch (OidException e) {
            throw new SDKException("Cannot get attribute:" + name, e);
        }
        IAttributeDefinition def = asset.getAssetType().getAttributeDefinition(name);
        Attribute attribute2 = attribute = cachable ? asset.getAttribute(def) : null;
        if (attribute == null) {
            attribute = this.retrieveAttribute(asset.getOid(), def, cachable);
        }
        return attribute;
    }

    Collection<CustomListValue> getCustomListTypeValues(Entity entity, String attributeName) throws SDKException {
        IAssetType typeToGet = this.getRelatedType(entity, attributeName);
        Query query = new Query(typeToGet);
        FilterTerm assetStateTerm = new FilterTerm(typeToGet.getAttributeDefinition("AssetState"));
        assetStateTerm.notEqual(new Object[]{AssetState.Closed});
        query.setFilter((IFilterTerm)new AndFilterTerm((IFilterTerm[])new FilterTerm[]{assetStateTerm}));
        LinkedList<CustomListValue> values = new LinkedList<CustomListValue>();
        try {
            for (Asset asset : this.getServices().retrieve(query).getAssets()) {
                values.add(this.createWrapper(CustomListValue.class, new AssetID(asset.getOid().getToken()), false));
            }
        }
        catch (V1Exception e) {
            throw new SDKException(e);
        }
        return values;
    }

    <T extends Entity> Rank<T> getRank(T entity, String attributeName) {
        return new Rank<T>(this, entity, attributeName);
    }

    void rankAbove(Entity entity, Entity aboveEntity, String attributeName) {
        com.versionone.apiclient.Rank rank = new com.versionone.apiclient.Rank(this.getProperty(aboveEntity, attributeName, false));
        this.setProperty(entity, attributeName, rank.before());
    }

    void rankBelow(Entity entity, Entity belowEntity, String attributeName) {
        com.versionone.apiclient.Rank rank = new com.versionone.apiclient.Rank(this.getProperty(belowEntity, attributeName, false));
        this.setProperty(entity, attributeName, rank.after());
    }

    boolean isRankAbove(Entity entity, Entity aboveEntity, String attributeName) {
        com.versionone.apiclient.Rank aboveRank;
        com.versionone.apiclient.Rank entityRank = new com.versionone.apiclient.Rank(this.getProperty(entity, attributeName, false));
        return entityRank.compareTo(aboveRank = new com.versionone.apiclient.Rank(this.getProperty(aboveEntity, attributeName, false))) < 0;
    }

    boolean isRankBelow(Entity entity, Entity belowEntity, String attributeName) {
        com.versionone.apiclient.Rank belowRank;
        com.versionone.apiclient.Rank entityRank = new com.versionone.apiclient.Rank(this.getProperty(entity, attributeName, false));
        return entityRank.compareTo(belowRank = new com.versionone.apiclient.Rank(this.getProperty(belowEntity, attributeName, false))) > 0;
    }

    Double getSum(Entity entity, String multiRelationName, EntityFilter filter, String numericAttributeName) throws SDKException {
        IFilterTerm term;
        Oid oid = this.getOid(entity);
        IAttributeDefinition multiRelation = oid.getAssetType().getAttributeDefinition(multiRelationName);
        IAssetType relatedType = multiRelation.getRelatedAsset();
        IAttributeDefinition filtered = multiRelation;
        if (filter != null && (term = filter.buildFilter(relatedType, this)) != null) {
            try {
                filtered = multiRelation.filter(term);
            }
            catch (APIException e) {
                throw new SDKException(e);
            }
        }
        IAttributeDefinition relatedAttribute = relatedType.getAttributeDefinition(numericAttributeName);
        IAttributeDefinition joined = filtered.join(relatedAttribute);
        IAttributeDefinition sum = joined.aggregate(IAttributeDefinition.Aggregate.Sum);
        try {
            return (Double)this.retrieveAttribute(oid, sum, false).getValue();
        }
        catch (APIException e) {
            throw new SDKException(e);
        }
    }

    boolean checkTracking(Workitem workitem) {
        TrackingLevel level = this.getTrackingLevel(workitem);
        if (workitem instanceof PrimaryWorkitem && level == TrackingLevel.SecondaryWorkitem) {
            return false;
        }
        return !(workitem instanceof SecondaryWorkitem) || level != TrackingLevel.PrimaryWorkitem;
    }

    void preventTrackingLevelAbuse(Workitem workitem) {
        TrackingLevel level = this.getTrackingLevel(workitem);
        if (workitem instanceof PrimaryWorkitem) {
            if (level == TrackingLevel.SecondaryWorkitem) {
                throw new IllegalStateException("You cannot set DetailEstimate or ToDo on this item, nor can you log effort, because the system is configured to track Detail Estimate and ToDo at the Task/Test level.");
            }
        } else if (level == TrackingLevel.PrimaryWorkitem) {
            throw new IllegalStateException("You cannot set DetailEstimate or ToDo on this item, nor can you log effort, because the system is configured to track Detail Estimate and ToDo at the Story/Defect level.");
        }
    }

    private TrackingLevel getTrackingLevel(Workitem workitem) {
        Workitem parent = workitem instanceof SecondaryWorkitem ? ((SecondaryWorkitem)workitem).getParent() : (PrimaryWorkitem)workitem;
        if (parent instanceof Story) {
            return this.getConfiguration().storyTrackingLevel;
        }
        if (parent instanceof Defect) {
            return this.getConfiguration().defectTrackingLevel;
        }
        throw new IllegalArgumentException("Expected a Story, a Defect or a child work item of one.");
    }

    public V1InstanceGetter get() {
        if (this.getter == null) {
            this.getter = new V1InstanceGetter(this);
        }
        return this.getter;
    }

    WrapperManager getWrapperManager() {
        return this.wrapperManager;
    }

    public V1InstanceCreator create() {
        if (this.creator == null) {
            this.creator = new V1InstanceCreator(this);
        }
        return this.creator;
    }
}

