/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.DB;
import com.versionone.om.AssetID;
import com.versionone.om.Effort;
import com.versionone.om.Member;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.ProjectAsset;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.EffortFilter;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Workitem")
public abstract class Workitem
extends ProjectAsset {
    Workitem(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Workitem(V1Instance instance) {
        super(instance);
    }

    public boolean canTrack() {
        return this.getInstance().checkTracking(this);
    }

    public Collection<Member> getOwners() {
        return this.getMultiRelation("Owners");
    }

    public Double getDetailEstimate() {
        return (Double)this.get("DetailEstimate");
    }

    public void setDetailEstimate(Double detailEstimate) {
        this.getInstance().preventTrackingLevelAbuse(this);
        this.set("DetailEstimate", detailEstimate);
    }

    public Double getDone() {
        return (Double)this.get("Actuals.Value.@Sum", false);
    }

    public Double getToDo() {
        return (Double)this.get("ToDo");
    }

    public void setToDo(Double toDo) throws IllegalStateException {
        this.getInstance().preventTrackingLevelAbuse(this);
        this.set("ToDo", toDo);
    }

    public Collection<Effort> getEffortRecords(EffortFilter filter) {
        filter = filter == null ? new EffortFilter() : filter;
        filter.workitem.clear();
        filter.workitem.add(this);
        return this.getInstance().get().effortRecords(filter);
    }

    public String getReference() {
        return (String)this.get("Reference");
    }

    public void setReference(String value) {
        this.set("Reference", value);
    }

    public Effort createEffort(double value) {
        return this.createEffort(value, null, null);
    }

    public Effort createEffort(double value, Map<String, Object> attributes) {
        return this.createEffort(value, null, null, attributes);
    }

    public Effort createEffort(double value, Member member) {
        return this.createEffort(value, member, DB.DateTime.now());
    }

    public Effort createEffort(double value, Member member, DB.DateTime date) {
        return this.getInstance().create().effort(value, this, member, date);
    }

    public Effort createEffort(double value, Member member, DB.DateTime date, Map<String, Object> attributes) {
        return this.getInstance().create().effort(value, this, member, date, attributes);
    }
}

