/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om.filters;

import com.versionone.apiclient.FilterTerm;
import com.versionone.om.filters.IComparisonSearcher;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonSearcher<T extends Comparable<T>>
implements IComparisonSearcher<T> {
    private HashMap<FilterTerm.Operator, T> terms = new HashMap();

    public void addTerm(FilterTerm.Operator op) throws IllegalStateException {
        this.addTerm(op, (T)null);
    }

    @Override
    public void addTerm(FilterTerm.Operator op, T value) throws IllegalStateException {
        boolean operatorNotExists = !this.terms.containsKey(op);
        Comparable old = operatorNotExists ? null : (Comparable)this.terms.get(op);
        switch (op) {
            case Exists: {
                if (this.terms.containsKey(FilterTerm.Operator.NotExists)) {
                    throw new IllegalStateException("Cannot contain both " + op + " and " + FilterTerm.Operator.NotExists + " terms.");
                }
                if (!operatorNotExists) break;
                this.terms.put(op, value);
                break;
            }
            case NotExists: {
                if (this.terms.containsKey(FilterTerm.Operator.Exists)) {
                    throw new IllegalStateException("Cannot contain both " + op + " and " + FilterTerm.Operator.Exists + " terms.");
                }
                if (!operatorNotExists) break;
                this.terms.put(op, value);
                break;
            }
            case Equal: 
            case NotEqual: {
                if (operatorNotExists) {
                    this.terms.put(op, value);
                    break;
                }
                throw new IllegalStateException("Cannot contain more than one " + op + " term.");
            }
            case GreaterThan: 
            case GreaterThanOrEqual: {
                if (operatorNotExists) {
                    this.terms.put(op, value);
                    break;
                }
                if (old.compareTo(value) >= 0) break;
                this.terms.put(op, value);
                break;
            }
            case LessThan: 
            case LessThanOrEqual: {
                if (operatorNotExists) {
                    this.terms.put(op, value);
                    break;
                }
                if (old.compareTo(value) <= 0) break;
                this.terms.put(op, value);
            }
        }
    }

    @Override
    public void range(T min, T max) {
        if (min == null || max == null) {
            throw new IllegalArgumentException("Range bound values cannot be null");
        }
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("Lower bound of a range cannot exceed upper bound");
        }
        this.addTerm(FilterTerm.Operator.GreaterThanOrEqual, min);
        this.addTerm(FilterTerm.Operator.LessThanOrEqual, max);
    }

    @Override
    public void clear() {
        this.terms.clear();
    }

    private void optimize() {
        Comparable less = (Comparable)this.terms.get(FilterTerm.Operator.LessThan);
        Comparable lessOrEqual = (Comparable)this.terms.get(FilterTerm.Operator.LessThanOrEqual);
        if (less != null && lessOrEqual != null) {
            if (lessOrEqual.compareTo(less) >= 0) {
                this.terms.remove(FilterTerm.Operator.LessThanOrEqual);
            } else {
                this.terms.remove(FilterTerm.Operator.LessThan);
            }
        }
        Comparable greater = (Comparable)this.terms.get(FilterTerm.Operator.GreaterThan);
        Comparable greaterOrEqual = (Comparable)this.terms.get(FilterTerm.Operator.GreaterThanOrEqual);
        if (greater != null && greaterOrEqual != null) {
            if (greaterOrEqual.compareTo(greater) <= 0) {
                this.terms.remove(FilterTerm.Operator.GreaterThanOrEqual);
            } else {
                this.terms.remove(FilterTerm.Operator.GreaterThan);
            }
        }
    }

    @Override
    public HashMap<FilterTerm.Operator, T> getTerms() {
        this.optimize();
        return this.terms;
    }
}

