/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om.filters;

import com.versionone.Oid;
import com.versionone.apiclient.AndFilterTerm;
import com.versionone.apiclient.FilterTerm;
import com.versionone.apiclient.GroupFilterTerm;
import com.versionone.apiclient.IAssetType;
import com.versionone.apiclient.IAttributeDefinition;
import com.versionone.apiclient.IFilterTerm;
import com.versionone.apiclient.V1Exception;
import com.versionone.om.AssetID;
import com.versionone.om.Entity;
import com.versionone.om.SDKException;
import com.versionone.om.TransformIterable;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.IComparisonSearcher;
import com.versionone.om.listvalue.ListValue;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterBuilder {
    private final IAssetType assetType;
    final V1Instance instance;
    public final GroupFilterTerm root = new AndFilterTerm(new IFilterTerm[0]);

    public FilterBuilder(IAssetType assetType, V1Instance instance) {
        this.assetType = assetType;
        this.instance = instance;
    }

    private IAttributeDefinition resolve(String name) {
        return this.assetType.getAttributeDefinition(name);
    }

    Oid getOid(AssetID id) throws SDKException {
        try {
            return this.instance.getApiClient().getServices().getOid(id.toString());
        }
        catch (V1Exception e) {
            throw new SDKException(e);
        }
    }

    public void simple(String name, List<?> values) {
        if (values.size() > 0) {
            this.root.Term(this.resolve(name)).equal(values.toArray());
        }
    }

    public <T extends Entity> void relation(String name, Collection<T> values) {
        if (values.size() > 0) {
            TransformIterable.ITransformerGeneric trans = new TransformIterable.ITransformerGeneric<T, Oid>(){

                @Override
                public Oid transform(T e, Class<Oid> dClass) {
                    return e == null ? Oid.Null : FilterBuilder.this.getOid(((Entity)e).getID());
                }
            };
            this.root.Term(this.resolve(name)).equal(new TransformIterable<T, Oid>(values, trans, Oid.class).toArray());
        }
    }

    public <T extends Entity> void multiRelation(String name, Collection<T> values) {
        if (values.size() > 0) {
            IAttributeDefinition def = this.resolve(name);
            FilterTerm valuesTerm = null;
            FilterTerm notExistsTerm = null;
            for (Entity t : values) {
                if (t == null) {
                    if (notExistsTerm != null) continue;
                    notExistsTerm = new FilterTerm(def);
                    notExistsTerm.notExists();
                    continue;
                }
                if (valuesTerm == null) {
                    valuesTerm = new FilterTerm(def);
                }
                valuesTerm.equal(new Object[]{this.getOid(t.getID())});
            }
            this.root.or(new IFilterTerm[]{valuesTerm, notExistsTerm});
        }
    }

    public <T extends ListValue> void listRelation(String name, Collection<String> values, final Class<T> listElementClass) {
        if (values.size() > 0) {
            TransformIterable.ITransformerGeneric<String, Oid> trans = new TransformIterable.ITransformerGeneric<String, Oid>(){

                @Override
                public Oid transform(String s, Class<Oid> dClass) {
                    if (s == null) {
                        return Oid.Null;
                    }
                    return FilterBuilder.this.getOid(((Entity)FilterBuilder.this.instance.getListValueByName(listElementClass, s)).getID());
                }
            };
            this.root.Term(this.resolve(name)).equal(new TransformIterable<String, Oid>(values, trans, Oid.class).toArray());
        }
    }

    public void simple(String name, boolean value) {
        this.root.Term(this.resolve(name)).equal(new Object[]{value});
    }

    public void comparison(String name, FilterTerm.Operator operator, Object value) {
        FilterTerm term = this.root.Term(this.resolve(name));
        switch (operator) {
            case Exists: {
                term.exists();
                break;
            }
            case NotExists: {
                term.notExists();
                break;
            }
            default: {
                term.operate(operator, new Object[]{value});
            }
        }
    }

    public void comparison(String attributeName, IComparisonSearcher searcher) {
        Map terms = searcher.getTerms();
        for (Map.Entry term : terms.entrySet()) {
            this.comparison(attributeName, term.getKey(), term.getValue());
        }
    }
}

