/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations;

import com.wavefront.integrations.AbstractProxyConnectionHandler;
import com.wavefront.integrations.WavefrontSender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.SocketFactory;

public class Wavefront
extends AbstractProxyConnectionHandler
implements WavefrontSender {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private AtomicInteger failures = new AtomicInteger();
    private String source;

    public Wavefront(String agentHostName, int port) {
        this(agentHostName, port, SocketFactory.getDefault());
    }

    public Wavefront(String agentHostName, int port, SocketFactory socketFactory) {
        this(new InetSocketAddress(agentHostName, port), socketFactory);
    }

    public Wavefront(InetSocketAddress agentAddress) {
        this(agentAddress, SocketFactory.getDefault());
    }

    public Wavefront(InetSocketAddress agentAddress, SocketFactory socketFactory) {
        this(agentAddress, socketFactory, null, null);
    }

    public Wavefront(InetSocketAddress agentAddress, SocketFactory socketFactory, @Nullable Long connectionTimeToLiveMillis, @Nullable Supplier<Long> timeSupplier) {
        super(agentAddress, socketFactory, connectionTimeToLiveMillis, timeSupplier);
    }

    private void initializeSource() throws UnknownHostException {
        if (this.source == null) {
            this.source = InetAddress.getLocalHost().getHostName();
        }
    }

    @Override
    public void send(String name, double value) throws IOException {
        this.initializeSource();
        this.internalSend(name, value, null, this.source, null);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp) throws IOException {
        this.initializeSource();
        this.internalSend(name, value, timestamp, this.source, null);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp, String source) throws IOException {
        this.internalSend(name, value, timestamp, source, null);
    }

    @Override
    public void send(String name, double value, String source, @Nullable Map<String, String> pointTags) throws IOException {
        this.internalSend(name, value, null, source, pointTags);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> pointTags) throws IOException {
        this.internalSend(name, value, timestamp, source, pointTags);
    }

    private void internalSend(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> pointTags) throws IOException {
        if (!this.isConnected()) {
            try {
                this.connect();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (Wavefront.isBlank(name)) {
            throw new IllegalArgumentException("metric name cannot be blank");
        }
        if (Wavefront.isBlank(source)) {
            throw new IllegalArgumentException("source cannot be blank");
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(Wavefront.sanitize(name));
            sb.append(' ');
            sb.append(Double.toString(value));
            if (timestamp != null) {
                sb.append(' ');
                sb.append(Long.toString(timestamp));
            }
            sb.append(" host=");
            sb.append(Wavefront.sanitize(source));
            if (pointTags != null) {
                for (Map.Entry<String, String> tag : pointTags.entrySet()) {
                    if (Wavefront.isBlank(tag.getKey())) {
                        throw new IllegalArgumentException("point tag key cannot be blank");
                    }
                    if (Wavefront.isBlank(tag.getValue())) {
                        throw new IllegalArgumentException("point tag value cannot be blank");
                    }
                    sb.append(' ');
                    sb.append(Wavefront.sanitize(tag.getKey()));
                    sb.append('=');
                    sb.append(Wavefront.sanitize(tag.getValue()));
                }
            }
            sb.append('\n');
            try {
                this.sendData(sb.toString());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            this.failures.incrementAndGet();
            throw e;
        }
    }

    @Override
    public int getFailureCount() {
        return this.failures.get();
    }

    static String sanitize(String s) {
        String whitespaceSanitized = WHITESPACE.matcher(s).replaceAll("-");
        if (s.contains("\"") || s.contains("'")) {
            return "\"" + whitespaceSanitized.replaceAll("\"", "\\\\\"") + "\"";
        }
        return "\"" + whitespaceSanitized + "\"";
    }

    private static boolean isBlank(String s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

