/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wavefront.common.Clock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import queryserver.parser.DSWrapperLexer;
import sunnylabs.report.Histogram;
import sunnylabs.report.HistogramType;
import sunnylabs.report.ReportPoint;

public class IngesterFormatter {
    private static final FormatterElement WHITESPACE_ELEMENT = new Whitespace();
    private static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile("\\'", 16);
    private static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile("\\\"", 16);
    private static final String DOUBLE_QUOTE_REPLACEMENT = Matcher.quoteReplacement("\"");
    private static final String SINGLE_QUOTE_REPLACEMENT = Matcher.quoteReplacement("'");
    private static final BaseErrorListener THROWING_ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new RuntimeException(msg, (Throwable)e);
        }
    };
    private final List<FormatterElement> elements;
    private final ThreadLocal<DSWrapperLexer> dsWrapperLexerThreadLocal = new ThreadLocal<DSWrapperLexer>(){

        @Override
        protected DSWrapperLexer initialValue() {
            DSWrapperLexer lexer = new DSWrapperLexer((CharStream)new ANTLRInputStream(""));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)THROWING_ERROR_LISTENER);
            return lexer;
        }
    };

    private IngesterFormatter(List<FormatterElement> elements) {
        this.elements = elements;
    }

    public ReportPoint drive(String input, String defaultHostName, String customerId, List<String> customSourceTags) {
        DSWrapperLexer lexer = this.dsWrapperLexerThreadLocal.get();
        lexer.setInputStream((IntStream)new ANTLRInputStream(input));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        commonTokenStream.getText();
        List tokens = commonTokenStream.getTokens();
        if (tokens.isEmpty()) {
            throw new RuntimeException("Could not parse: " + input);
        }
        Queue queue = tokens.stream().filter(t -> t.getType() != -1).collect(Collectors.toCollection(ArrayDeque::new));
        ReportPoint point = new ReportPoint();
        point.setTable(customerId);
        point.setTimestamp(Clock.now());
        try {
            for (FormatterElement element : this.elements) {
                element.consume(queue, point);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse: " + input, ex);
        }
        if (!queue.isEmpty()) {
            throw new RuntimeException("Could not parse: " + input);
        }
        String host = null;
        Map<String, String> annotations = point.getAnnotations();
        if (annotations != null) {
            host = annotations.remove("source");
            if (host == null) {
                host = annotations.remove("host");
            } else if (annotations.containsKey("host")) {
                annotations.put("_host", annotations.remove("host"));
            }
            if (annotations.containsKey("tag")) {
                annotations.put("_tag", annotations.remove("tag"));
            }
            if (host == null) {
                String tag;
                Iterator<String> iterator = customSourceTags.iterator();
                while (iterator.hasNext() && (host = annotations.get(tag = iterator.next())) == null) {
                }
            }
        }
        if (host == null) {
            host = defaultHostName;
        }
        point.setHost(host);
        return point;
    }

    public static IngesterFormatBuilder newBuilder() {
        return new IngesterFormatBuilder();
    }

    private static double parseValue(Queue<Token> tokenQueue, String name) {
        String value = "";
        Token current = tokenQueue.poll();
        if (current == null) {
            throw new RuntimeException("Invalid " + name + ", found EOF");
        }
        if (current.getType() == 4) {
            current = tokenQueue.poll();
            value = "-";
        }
        if (current == null) {
            throw new RuntimeException("Invalid " + name + ", found EOF");
        }
        if (current.getType() == 9) {
            if (!value.equals("")) {
                throw new RuntimeException("Invalid " + name + ": " + value + current.getText());
            }
            value = value + IngesterFormatter.unquote(current.getText());
        } else if (current.getType() == 8 || current.getType() == 10 || current.getType() == 7) {
            value = value + current.getText();
        } else {
            throw new RuntimeException("Invalid " + name + ": " + current.getText());
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nef) {
            throw new RuntimeException("Invalid " + name + ": " + value);
        }
    }

    private static Long parseTimestamp(Queue<Token> tokenQueue, boolean optional) {
        Token peek = tokenQueue.peek();
        if (peek == null || peek.getType() != 7) {
            if (optional) {
                return null;
            }
            throw new RuntimeException("Expected timestamp, found " + (peek == null ? "EOF" : peek.getText()));
        }
        try {
            Double timestamp = Double.parseDouble(tokenQueue.poll().getText());
            Long timestampLong = timestamp.longValue();
            if (timestampLong.toString().length() == 13) {
                return timestamp.longValue();
            }
            return (long)(1000.0 * timestamp);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Invalid timestamp value: " + peek.getText());
        }
    }

    private static String getLiteral(Queue<Token> tokens) {
        String toReturn = "";
        Token next = tokens.peek();
        if (next == null) {
            return "";
        }
        if (next.getType() == 9) {
            return IngesterFormatter.unquote(tokens.poll().getText());
        }
        while (next != null && (next.getType() == 8 || next.getType() == 7 || next.getType() == 14 || next.getType() == 10 || next.getType() == 3 || next.getType() == 4 || next.getType() == 6)) {
            toReturn = toReturn + tokens.poll().getText();
            next = tokens.peek();
        }
        return toReturn;
    }

    public static String unquote(String text) {
        if (text.startsWith("\"")) {
            text = DOUBLE_QUOTE_PATTERN.matcher(text.substring(1, text.length() - 1)).replaceAll(DOUBLE_QUOTE_REPLACEMENT);
        } else if (text.startsWith("'")) {
            text = SINGLE_QUOTE_PATTERN.matcher(text.substring(1, text.length() - 1)).replaceAll(SINGLE_QUOTE_REPLACEMENT);
        }
        return text;
    }

    public static class Literal
    implements FormatterElement {
        private final String literal;
        private final boolean caseSensitive;

        public Literal(String literal, boolean caseSensitive) {
            this.literal = literal;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            if (tokenQueue.isEmpty()) {
                throw new RuntimeException("Expecting a literal string: " + this.literal + " but found EOF");
            }
            String literal = IngesterFormatter.getLiteral(tokenQueue);
            if (this.caseSensitive ? !literal.equals(this.literal) : !literal.equalsIgnoreCase(this.literal)) {
                throw new RuntimeException("Expecting a literal string: " + literal + " but found: " + literal);
            }
        }
    }

    public static class Whitespace
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokens, ReportPoint point) {
            while (!tokens.isEmpty() && tokens.peek().getType() == 15) {
                tokens.poll();
            }
        }
    }

    public static class Metric
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            String metric = IngesterFormatter.getLiteral(tokenQueue);
            if (metric.length() == 0) {
                throw new RuntimeException("Invalid metric name");
            }
            point.setMetric(metric);
        }
    }

    public static class Timestamp
    implements FormatterElement {
        private final TimeUnit timeUnit;
        private final boolean optional;

        public Timestamp(TimeUnit timeUnit, boolean optional) {
            this.timeUnit = timeUnit;
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            Token peek = tokenQueue.peek();
            if (peek == null) {
                if (this.optional) {
                    return;
                }
                throw new RuntimeException("Expecting timestamp, found EOF");
            }
            if (peek.getType() == 7) {
                try {
                    long multiplier = this.timeUnit.toMillis(1L);
                    if (multiplier < 1L) {
                        point.setTimestamp(this.timeUnit.toMillis((long)Double.parseDouble(tokenQueue.poll().getText())));
                    }
                    point.setTimestamp((long)((double)multiplier * Double.parseDouble(tokenQueue.poll().getText())));
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Invalid timestamp value: " + peek.getText());
                }
            } else if (!this.optional) {
                throw new RuntimeException("Expecting timestamp, found: " + peek.getText());
            }
        }
    }

    public static class AdaptiveTimestamp
    implements FormatterElement {
        private final boolean optional;

        public AdaptiveTimestamp(boolean optional) {
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            Long timestamp = IngesterFormatter.parseTimestamp(tokenQueue, this.optional);
            if (timestamp != null) {
                point.setTimestamp(timestamp);
            }
        }
    }

    public static class Value
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            point.setValue(IngesterFormatter.parseValue(tokenQueue, "metric value"));
        }
    }

    public static class Tag
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> queue, ReportPoint point) {
            String tagk = IngesterFormatter.getLiteral(queue);
            if (tagk.length() == 0) {
                throw new RuntimeException("Invalid tag name");
            }
            WHITESPACE_ELEMENT.consume(queue, point);
            Token current = queue.poll();
            if (current == null || current.getType() != 1) {
                throw new RuntimeException("Tag keys and values must be separated by '='" + (current != null ? ", found: " + current.getText() : ", found EOF"));
            }
            WHITESPACE_ELEMENT.consume(queue, point);
            String tagv = IngesterFormatter.getLiteral(queue);
            if (tagv.length() == 0) {
                throw new RuntimeException("Invalid tag value for: " + tagk);
            }
            if (point.getAnnotations() == null) {
                point.setAnnotations(Maps.newHashMap());
            }
            point.getAnnotations().put(tagk, tagv);
        }
    }

    public static class TimestampAdjuster
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            Preconditions.checkArgument((point.getValue() != null && point.getTimestamp() != null && point.getValue() instanceof Histogram && ((Histogram)((Object)point.getValue())).getDuration() != null ? 1 : 0) != 0, (Object)"Expected a histogram point with timestamp and histogram duration");
            long duration = ((Histogram)((Object)point.getValue())).getDuration().intValue();
            point.setTimestamp(point.getTimestamp() / duration * duration);
        }
    }

    public static class GuardedLoop
    implements FormatterElement {
        private final FormatterElement element;
        private final int acceptedToken;
        private final boolean optional;

        public GuardedLoop(FormatterElement element, int acceptedToken, boolean optional) {
            this.element = element;
            this.acceptedToken = acceptedToken;
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            boolean satisfied = this.optional;
            while (!tokenQueue.isEmpty()) {
                WHITESPACE_ELEMENT.consume(tokenQueue, point);
                if (tokenQueue.peek() == null || tokenQueue.peek().getType() != this.acceptedToken) break;
                satisfied = true;
                this.element.consume(tokenQueue, point);
            }
            if (!satisfied) {
                throw new RuntimeException("Expected at least one element, got none");
            }
        }
    }

    public static class Centroid
    implements FormatterElement {
        public static int expectedToken() {
            return 12;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            int count;
            Token peek = tokenQueue.peek();
            Preconditions.checkNotNull((Object)peek, (Object)"Expected Count, got EOF");
            Preconditions.checkArgument((peek.getType() == 12 ? 1 : 0) != 0, (Object)("Expected Count, got " + peek.getText()));
            String countStr = tokenQueue.poll().getText();
            try {
                count = Integer.parseInt(countStr.substring(1));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Could not parse count " + countStr);
            }
            WHITESPACE_ELEMENT.consume(tokenQueue, point);
            double mean = IngesterFormatter.parseValue(tokenQueue, "centroid mean");
            Histogram h = (Histogram)((Object)MoreObjects.firstNonNull((Object)((Object)((Histogram)((Object)point.getValue()))), (Object)((Object)new Histogram())));
            List bins = (List)MoreObjects.firstNonNull(h.getBins(), new ArrayList());
            bins.add(mean);
            h.setBins(bins);
            List counts = (List)MoreObjects.firstNonNull(h.getCounts(), new ArrayList());
            counts.add(count);
            h.setCounts(counts);
            point.setValue(h);
        }
    }

    public static class BinType
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            String binType;
            Token peek = tokenQueue.peek();
            if (peek == null) {
                throw new RuntimeException("Expected BinType, found EOF");
            }
            if (peek.getType() != 11) {
                throw new RuntimeException("Expected BinType, found " + peek.getText());
            }
            int durationMillis = 0;
            switch (binType = tokenQueue.poll().getText()) {
                case "!M": {
                    durationMillis = 60000;
                    break;
                }
                case "!H": {
                    durationMillis = 3600000;
                    break;
                }
                case "!D": {
                    durationMillis = 86400000;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown BinType " + binType);
                }
            }
            Histogram h = (Histogram)((Object)MoreObjects.firstNonNull((Object)((Object)((Histogram)((Object)point.getValue()))), (Object)((Object)new Histogram())));
            h.setDuration(durationMillis);
            h.setType(HistogramType.TDIGEST);
            point.setValue(h);
        }
    }

    public static class Loop
    implements FormatterElement {
        private final FormatterElement element;

        public Loop(FormatterElement element) {
            this.element = element;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, ReportPoint point) {
            while (!tokenQueue.isEmpty()) {
                WHITESPACE_ELEMENT.consume(tokenQueue, point);
                if (tokenQueue.isEmpty()) {
                    return;
                }
                this.element.consume(tokenQueue, point);
            }
        }
    }

    private static interface FormatterElement {
        public void consume(Queue<Token> var1, ReportPoint var2);
    }

    public static class IngesterFormatBuilder {
        private final List<FormatterElement> elements = Lists.newArrayList();

        public IngesterFormatBuilder appendCaseSensitiveLiteral(String literal) {
            this.elements.add(new Literal(literal, true));
            return this;
        }

        public IngesterFormatBuilder appendCaseInsensitiveLiteral(String literal) {
            this.elements.add(new Literal(literal, false));
            return this;
        }

        public IngesterFormatBuilder appendMetricName() {
            this.elements.add(new Metric());
            return this;
        }

        public IngesterFormatBuilder appendValue() {
            this.elements.add(new Value());
            return this;
        }

        public IngesterFormatBuilder appendTimestamp() {
            this.elements.add(new AdaptiveTimestamp(false));
            return this;
        }

        public IngesterFormatBuilder appendOptionalTimestamp() {
            this.elements.add(new AdaptiveTimestamp(true));
            return this;
        }

        public IngesterFormatBuilder appendTimestamp(TimeUnit timeUnit) {
            this.elements.add(new Timestamp(timeUnit, false));
            return this;
        }

        public IngesterFormatBuilder appendOptionalTimestamp(TimeUnit timeUnit) {
            this.elements.add(new Timestamp(timeUnit, true));
            return this;
        }

        public IngesterFormatBuilder appendAnnotationsConsumer() {
            this.elements.add(new Loop(new Tag()));
            return this;
        }

        public IngesterFormatBuilder whiteSpace() {
            this.elements.add(new Whitespace());
            return this;
        }

        public IngesterFormatBuilder binType() {
            this.elements.add(new BinType());
            return this;
        }

        public IngesterFormatBuilder centroids() {
            this.elements.add(new GuardedLoop(new Centroid(), Centroid.expectedToken(), false));
            return this;
        }

        public IngesterFormatBuilder adjustTimestamp() {
            this.elements.add(new TimestampAdjuster());
            return this;
        }

        public IngesterFormatter build() {
            return new IngesterFormatter(this.elements);
        }
    }
}

