/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.sdk;

import com.wedeploy.api.sdk.ContentTypeHeaderResolver;

public class ContentType {
    public static final ContentType TEXT = new ContentType("text/plain", "UTF-8");
    public static final ContentType HTML = new ContentType("text/html", "UTF-8");
    public static final ContentType JSON = new ContentType("application/json", "UTF-8");
    public static final ContentType FORM_URLENCODED = new ContentType("application/x-www-form-urlencoded", "UTF-8");
    public static final ContentType MULTIPART_FORM = new ContentType("multipart/form-data", "UTF-8");
    private final String completeContentType;
    private final String contentType;
    private final String charset;

    public ContentType(String contentType) {
        ContentTypeHeaderResolver cthr = new ContentTypeHeaderResolver(contentType);
        this.contentType = cthr.getMimeType();
        this.charset = cthr.getEncoding();
        this.completeContentType = this.charset == null ? this.contentType : this.contentType + "; charset=" + this.charset;
    }

    public ContentType(String contentType, String charset) {
        this.contentType = contentType;
        this.charset = charset;
        this.completeContentType = charset == null ? contentType : contentType + "; charset=" + charset;
    }

    public String contentType() {
        return this.contentType;
    }

    public String charset() {
        return this.charset;
    }

    public String toString() {
        return this.completeContentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentType that = (ContentType)o;
        return this.completeContentType.equals(that.completeContentType);
    }

    public boolean isSame(String type) {
        if (type == null) {
            return false;
        }
        int ndx = type.indexOf(59);
        if (ndx != -1) {
            type = type.substring(0, ndx);
        }
        return type.equals(this.contentType);
    }

    public int hashCode() {
        return this.completeContentType.hashCode();
    }
}

