/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Dialog;
import fi.evolver.script.Environment;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Base64;
import java.util.Optional;
import java.util.SequencedMap;

public class Maven {
    private static final Dialog.DialogTextField DIALOG_FIELD_USERNAME = Dialog.textField("username");
    private static final Dialog.DialogTextField DIALOG_FIELD_PASSWORD = Dialog.passwordField("password");
    private static final String SUFFIX_USERNAME = "USERNAME";
    private static final String SUFFIX_PASSWORD = "PASSWORD";
    private static final Duration VALIDATION_TIMEOUT = Duration.ofSeconds(10L);

    public static void writeSettings(Path source) throws IOException {
        try (Step step = Step.start("Maven: write settings");){
            Path mavenSettingsPath = Shell.HOME.resolve(".m2/settings.xml");
            Files.createDirectories(mavenSettingsPath.getParent(), new FileAttribute[0]);
            Files.copy(source, mavenSettingsPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void setupMavenCredentials(Repo repo) {
        try (Step step = Step.start("Setup Maven credentials");){
            if (Maven.hasValidCredentials(repo)) {
                step.skip("Already valid");
                return;
            }
            Credentials credentials = Maven.readAndValidateCredentials(repo);
            Maven.setCredentials(repo, credentials);
        }
    }

    private static Credentials readAndValidateCredentials(Repo repo) {
        Optional<String> errorInfo = Optional.empty();
        while (true) {
            Dialog dialog = new Dialog("Maven credentials: %s".formatted(repo.name)).add(DIALOG_FIELD_USERNAME).add(DIALOG_FIELD_PASSWORD);
            errorInfo.map(arg_0 -> Maven.lambda$readAndValidateCredentials$0("Error: %s", arg_0)).map(Dialog::paragraph).ifPresent(dialog::add);
            SequencedMap<Dialog.DialogEntry, String> dialogResult = dialog.show();
            Credentials credentials = new Credentials((String)dialogResult.get(DIALOG_FIELD_USERNAME), (String)dialogResult.get(DIALOG_FIELD_PASSWORD));
            try {
                HttpResponse<String> validationResponse = Maven.validateCredentials(credentials, repo.pingUrl);
                if (validationResponse.statusCode() == 200) {
                    return credentials;
                }
                errorInfo = Optional.of("%s %s".formatted(validationResponse.statusCode(), validationResponse.body()));
                continue;
            }
            catch (IOException e) {
                errorInfo = Optional.of(e.toString());
                continue;
            }
            break;
        }
    }

    private static HttpResponse<String> validateCredentials(Credentials credentials, URI repoPingUrl) throws IOException {
        HttpClient client = HttpClient.newBuilder().connectTimeout(VALIDATION_TIMEOUT).build();
        try {
            String authHeader = "Basic " + Base64.getEncoder().encodeToString((credentials.username + ":" + credentials.password).getBytes());
            HttpRequest request = HttpRequest.newBuilder().uri(repoPingUrl).header("Authorization", authHeader).timeout(VALIDATION_TIMEOUT).GET().build();
            HttpResponse<String> httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (client != null) {
                client.close();
            }
            return httpResponse;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Credential validation interrupted", e);
            }
        }
    }

    private static boolean hasValidCredentials(Repo repo) {
        Optional<Credentials> existingCredentials = Maven.readExistingCredentials(repo);
        if (existingCredentials.isEmpty()) {
            return false;
        }
        try {
            return Maven.validateCredentials(existingCredentials.get(), repo.pingUrl).statusCode() == 200;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    private static Optional<Credentials> readExistingCredentials(Repo repo) {
        Optional<String> username = Environment.getPersonalVariable(repo.usernameVariable());
        Optional<String> password = Environment.getPersonalVariable(repo.passwordVariable());
        if (username.isEmpty() || password.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new Credentials(username.get(), password.get()));
    }

    private static void setCredentials(Repo repo, Credentials credentials) {
        Environment.setPersonalVariable(repo.usernameVariable(), credentials.username);
        Environment.setPersonalVariable(repo.passwordVariable(), credentials.password);
    }

    public static Repo repo(String name, URI pingUrl) {
        return new Repo(name, pingUrl);
    }

    private static /* synthetic */ String lambda$readAndValidateCredentials$0(String rec$, Object xva$0) {
        return "Error: %s".formatted(xva$0);
    }

    public record Repo(String name, URI pingUrl) {
        private String usernameVariable() {
            return this.createVariableKey(Maven.SUFFIX_USERNAME);
        }

        private String passwordVariable() {
            return this.createVariableKey(Maven.SUFFIX_PASSWORD);
        }

        private String createVariableKey(String suffix) {
            return "%s_MAVEN_%s".formatted(this.name, suffix).toUpperCase().replaceAll("[^A-Z_]", "_");
        }
    }

    private record Credentials(String username, String password) {
    }
}

