/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script;

import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Environment {
    private static final Pattern REGEX_EXPORT = Pattern.compile("^\\s*export +(?<name>\\w+)=(?<value>\"[^\"]*\"|'[^']*'|\\S*)\\s*(?:#\\s*(?<comment>\\S.*?)?\\s*)?$");

    public static void setPersonalVariable(String name, String value) {
        Environment.setPersonalVariable(name, value, null);
    }

    public static void setPersonalVariable(String name, String value, String comment) {
        try (Step step = Step.start("Set personal variable %s".formatted(name));){
            try {
                Path variableFile = Shell.HOME.resolve(".personal-variables");
                FileUtils.writeShellBlock(Shell.BASHRC, "Personal-ENV-variables", "source %s".formatted(variableFile));
                Map<String, Variable> variables = Environment.readVariables(variableFile);
                variables.put(name, new Variable(name, value, comment));
                Environment.writeVariables(variableFile, variables.values());
            }
            catch (IOException e) {
                step.fail(e);
            }
        }
    }

    public static Optional<String> getPersonalVariable(String name) {
        Step step = Step.start("Read personal variable %s".formatted(name));
        try {
            Path variableFile = Shell.HOME.resolve(".personal-variables");
            Optional<String> optional = Optional.ofNullable(Environment.readVariables(variableFile).get(name)).map(Variable::value);
            return optional;
        }
        catch (IOException e) {
            step.fail(e);
            throw new IllegalStateException("Should not reach this");
        }
        finally {
            if (step != null) {
                try {
                    step.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    static Map<String, Variable> readVariables(Path file) throws IOException {
        TreeMap<String, Variable> results = new TreeMap<String, Variable>();
        List<Object> lines = Files.exists(file, new LinkOption[0]) ? Files.readAllLines(file) : List.of();
        lines.stream().map(Variable::parseExportLine).filter(Optional::isPresent).map(Optional::get).forEach(v -> results.put(v.name(), (Variable)v));
        return results;
    }

    static void writeVariables(Path file, Collection<Variable> variables) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("# Generated programmatically: avoid invasive changes\n\n");
        for (Variable variable : variables) {
            builder.append(variable.toExportLine());
            builder.append("\n");
        }
        Files.writeString(file, (CharSequence)builder, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    }

    static String escapeValue(String value) {
        return "'" + value.replace("'", "'\\''") + "'";
    }

    static String unescapeValue(String value) {
        String result = value;
        if (result.startsWith("'")) {
            result = result.substring(1, result.length() - 1).replace("'\\''", "'");
        } else {
            if (result.startsWith("\"")) {
                result = result.substring(1, result.length() - 1);
            }
            result = result.replaceAll("\\\\([\\\"$])", "$1");
        }
        return result;
    }

    record Variable(String name, String value, String comment) {
        public static Optional<Variable> parseExportLine(String line) {
            Matcher matcher = REGEX_EXPORT.matcher(line);
            if (!matcher.find()) {
                return Optional.empty();
            }
            String name = matcher.group("name");
            String value = Environment.unescapeValue(matcher.group("value"));
            String comment = matcher.group("comment");
            return Optional.of(new Variable(name, value, comment));
        }

        public String toExportLine() {
            String result = "export %s=%s".formatted(this.name, Environment.escapeValue(this.value));
            if (this.comment != null) {
                result = "%-39s # %s".formatted(result, this.comment);
            }
            return result;
        }
    }
}

