/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt;
import fi.evolver.script.system.Architecture;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class AwsSsoCli {
    private static final URI AMD64_URL = URI.create("https://github.com/synfinatic/aws-sso-cli/releases/download/v2.0.0-beta4/aws-sso-cli_2.0.0-beta4-1_amd64.deb");
    private static final URI ARM64_URL = URI.create("https://github.com/synfinatic/aws-sso-cli/releases/download/v2.0.0-beta4/aws-sso-cli_2.0.0-beta4-1_arm64.deb");
    private static final Path AWS_DIR = Shell.HOME.resolve(".aws");
    private static final Path AWS_SSO_DIR = Shell.HOME.resolve(".aws-sso");
    private static final DateTimeFormatter BACKUP_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void install() {
        try (Step step = Step.start("AWS SSO CLI: install");){
            switch (Architecture.validated()) {
                case AMD64: {
                    Apt.installFromUrl(AMD64_URL);
                    return;
                }
                case ARM64: {
                    Apt.installFromUrl(ARM64_URL);
                    return;
                }
            }
            return;
        }
    }

    public static void installConfigFile(Path configFile) {
        FileUtils.copy(configFile, AWS_SSO_DIR.resolve("config.yaml"));
    }

    public static void configProfiles(String ... profiles) throws IOException {
        try (Step step = Step.start("AWS SSO CLI: config profiles");){
            Path AWS_CONFIG = AWS_DIR.resolve("config");
            if (Files.exists(AWS_CONFIG, new LinkOption[0])) {
                Files.move(AWS_CONFIG, AWS_DIR.resolve("config.bak.%s".formatted(LocalDateTime.now().format(BACKUP_DATETIME_FORMATTER))), new CopyOption[0]);
            }
            for (String profile : profiles) {
                Shell.user("aws-sso", "login", "-S", profile);
            }
            Shell.user("aws-sso", "setup", "profiles", "--force");
        }
    }

    public static void configCompletions() {
        try (Step step = Step.start("AWS SSO CLI: config completions");){
            String completions = Shell.user("aws-sso", "setup", "completions", "--source");
            FileUtils.writeShellBlock(Shell.BASHRC, "aws-sso-cli completions", completions);
        }
    }
}

