/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.util;

import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.Song;

public class SongUtil {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    public static boolean hasOutsideMinecraftOctaveRangeNotes(Song song) {
        return song.getNotes().testEach(Note::isOutsideMinecraftOctaveRange);
    }

    public static Set<MinecraftInstrument> getUsedVanillaInstruments(Song song) {
        EnumSet<MinecraftInstrument> usedInstruments = EnumSet.noneOf(MinecraftInstrument.class);
        song.getNotes().forEach(note -> {
            if (note.getInstrument() instanceof MinecraftInstrument) {
                usedInstruments.add((MinecraftInstrument)note.getInstrument());
            }
        });
        return usedInstruments;
    }

    public static Set<NbsCustomInstrument> getUsedNbsCustomInstruments(Song song) {
        HashSet<NbsCustomInstrument> usedInstruments = new HashSet<NbsCustomInstrument>();
        song.getNotes().forEach(note -> {
            if (note.getInstrument() instanceof NbsCustomInstrument) {
                usedInstruments.add((NbsCustomInstrument)note.getInstrument());
            }
        });
        return usedInstruments;
    }
}

