/*
 * Decompiled with CFR 0.152.
 */
package org.cloudi;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpErlangUInt;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.cloudi.Function9;

public class API {
    public static final PrintStream out = new PrintStream(System.out, true);
    public static final PrintStream err = new PrintStream(System.err, true);
    public static final int ASYNC = 1;
    public static final int SYNC = -1;
    private static final int MESSAGE_INIT = 1;
    private static final int MESSAGE_SEND_ASYNC = 2;
    private static final int MESSAGE_SEND_SYNC = 3;
    private static final int MESSAGE_RECV_ASYNC = 4;
    private static final int MESSAGE_RETURN_ASYNC = 5;
    private static final int MESSAGE_RETURN_SYNC = 6;
    private static final int MESSAGE_RETURNS_ASYNC = 7;
    private static final int MESSAGE_KEEPALIVE = 8;
    private static final int MESSAGE_REINIT = 9;
    private static final int MESSAGE_SUBSCRIBE_COUNT = 10;
    private static final int MESSAGE_TERM = 11;
    private FileDescriptor fd_in;
    private FileDescriptor fd_out;
    private boolean use_header;
    private FileOutputStream output;
    private FileInputStream input;
    private boolean initialization_complete;
    private boolean terminate;
    private HashMap<String, LinkedList<Function9<Integer, String, String, byte[], byte[], Integer, Byte, byte[], OtpErlangPid>>> callbacks;
    private final int buffer_size;
    private long request_timer;
    private Integer request_timeout;
    private int process_index;
    private int process_count;
    private int process_count_max;
    private int process_count_min;
    private String prefix;
    private int timeout_initialize;
    private int timeout_async;
    private int timeout_sync;
    private int timeout_terminate;
    private byte priority_default;
    private boolean request_timeout_adjustment;
    public static final byte[] TransIdNull = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public API(int thread_index) throws InvalidInputException, MessageDecodingException, TerminateException {
        String protocol = System.getenv("CLOUDI_API_INIT_PROTOCOL");
        if (protocol == null) {
            throw new InvalidInputException();
        }
        String buffer_size_str = System.getenv("CLOUDI_API_INIT_BUFFER_SIZE");
        if (buffer_size_str == null) {
            throw new InvalidInputException();
        }
        if (protocol.compareTo("tcp") == 0) {
            this.fd_in = this.fd_out = API.storeFD(thread_index + 3);
            this.use_header = true;
        } else if (protocol.compareTo("udp") == 0) {
            this.fd_in = this.fd_out = API.storeFD(thread_index + 3);
            this.use_header = false;
        } else if (protocol.compareTo("local") == 0) {
            this.fd_in = this.fd_out = API.storeFD(thread_index + 3);
            this.use_header = true;
        } else {
            throw new InvalidInputException();
        }
        assert (this.fd_in != null);
        assert (this.fd_out != null);
        this.output = new FileOutputStream(this.fd_out);
        this.input = new FileInputStream(this.fd_in);
        this.initialization_complete = false;
        this.terminate = false;
        this.callbacks = new HashMap();
        this.buffer_size = Integer.parseInt(buffer_size_str);
        this.process_index = 0;
        this.process_count = 0;
        this.process_count_max = 0;
        this.process_count_min = 0;
        this.timeout_initialize = 5000;
        this.timeout_async = 5000;
        this.timeout_sync = 5000;
        this.timeout_terminate = 1000;
        this.priority_default = 0;
        OtpOutputStream init = new OtpOutputStream();
        init.write(131);
        init.write_any((OtpErlangObject)new OtpErlangAtom("init"));
        this.send(init);
        this.poll_request(false);
    }

    public static int thread_count() throws InvalidInputException {
        String s = System.getenv("CLOUDI_API_INIT_THREAD_COUNT");
        if (s == null) {
            throw new InvalidInputException();
        }
        int thread_count = Integer.parseInt(s);
        return thread_count;
    }

    public void subscribe(String pattern, Object instance, String methodName) {
        String s = this.prefix + pattern;
        Function9 callback = new Function9(instance, methodName);
        LinkedList<Function9<Integer, String, String, Object, Object, Integer, Byte, Object, Object>> callback_list = this.callbacks.get(s);
        if (callback_list == null) {
            callback_list = new LinkedList();
            callback_list.addLast(callback);
            this.callbacks.put(s, callback_list);
        } else {
            callback_list.addLast(callback);
        }
        OtpOutputStream subscribe = new OtpOutputStream();
        subscribe.write(131);
        OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("subscribe"), new OtpErlangString(pattern)};
        subscribe.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
        this.send(subscribe);
    }

    public int subscribe_count(String pattern) throws MessageDecodingException, TerminateException {
        OtpOutputStream subscribe_count = new OtpOutputStream();
        subscribe_count.write(131);
        OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("subscribe_count"), new OtpErlangString(pattern)};
        subscribe_count.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
        this.send(subscribe_count);
        try {
            return (Integer)this.poll_request(false);
        }
        catch (MessageDecodingException e) {
            e.printStackTrace(err);
            return -1;
        }
    }

    public void unsubscribe(String pattern) throws InvalidInputException {
        String s = this.prefix + pattern;
        LinkedList<Function9<Integer, String, String, byte[], byte[], Integer, Byte, byte[], OtpErlangPid>> callback_list = this.callbacks.get(s);
        if (callback_list == null) {
            throw new InvalidInputException();
        }
        callback_list.removeFirst();
        if (callback_list.isEmpty()) {
            this.callbacks.remove(s);
        }
        OtpOutputStream unsubscribe = new OtpOutputStream();
        unsubscribe.write(131);
        OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("unsubscribe"), new OtpErlangString(pattern)};
        unsubscribe.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
        this.send(unsubscribe);
    }

    public TransId send_async(String name, byte[] request) throws MessageDecodingException, TerminateException {
        return this.send_async(name, "".getBytes(), request, this.timeout_async, this.priority_default);
    }

    public TransId send_async(String name, byte[] request_info, byte[] request, Integer timeout, Byte priority) throws MessageDecodingException, TerminateException {
        try {
            OtpOutputStream send_async = new OtpOutputStream();
            send_async.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("send_async"), new OtpErlangString(name), new OtpErlangBinary(request_info), new OtpErlangBinary(request), new OtpErlangUInt(timeout.intValue()), new OtpErlangInt((int)priority.byteValue())};
            send_async.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
            this.send(send_async);
            return (TransId)this.poll_request(false);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    public Response send_sync(String name, byte[] request) throws MessageDecodingException, TerminateException {
        return this.send_sync(name, "".getBytes(), request, this.timeout_sync, this.priority_default);
    }

    public Response send_sync(String name, byte[] request_info, byte[] request, Integer timeout, Byte priority) throws MessageDecodingException, TerminateException {
        try {
            OtpOutputStream send_sync = new OtpOutputStream();
            send_sync.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("send_sync"), new OtpErlangString(name), new OtpErlangBinary(request_info), new OtpErlangBinary(request), new OtpErlangUInt(timeout.intValue()), new OtpErlangInt((int)priority.byteValue())};
            send_sync.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
            this.send(send_sync);
            return (Response)this.poll_request(false);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    public List<TransId> mcast_async(String name, byte[] request) throws MessageDecodingException, TerminateException {
        return this.mcast_async(name, new byte[0], request, this.timeout_async, this.priority_default);
    }

    public List<TransId> mcast_async(String name, byte[] request_info, byte[] request, Integer timeout, Byte priority) throws MessageDecodingException, TerminateException {
        try {
            OtpOutputStream mcast_async = new OtpOutputStream();
            mcast_async.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("mcast_async"), new OtpErlangString(name), new OtpErlangBinary(request_info), new OtpErlangBinary(request), new OtpErlangUInt(timeout.intValue()), new OtpErlangInt((int)priority.byteValue())};
            mcast_async.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
            this.send(mcast_async);
            return (List)this.poll_request(false);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    public void forward_(Integer command, String name, byte[] request_info, byte[] request, Integer timeout, Byte priority, byte[] trans_id, OtpErlangPid pid) throws ForwardAsyncException, ForwardSyncException, InvalidInputException {
        if (command == 1) {
            this.forward_async(name, request_info, request, timeout, priority, trans_id, pid);
        } else if (command == -1) {
            this.forward_sync(name, request_info, request, timeout, priority, trans_id, pid);
        } else {
            throw new InvalidInputException();
        }
    }

    public void forward_async(String name, byte[] request_info, byte[] request, Integer timeout, Byte priority, byte[] trans_id, OtpErlangPid pid) throws ForwardAsyncException {
        if (this.request_timeout_adjustment && timeout == this.request_timeout) {
            int elapsed = (int)Math.max(0.0, (double)(System.nanoTime() - this.request_timer) * 1.0E-6);
            timeout = elapsed > timeout ? Integer.valueOf(0) : Integer.valueOf(timeout - elapsed);
        }
        try {
            OtpOutputStream forward_async = new OtpOutputStream();
            forward_async.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("forward_async"), new OtpErlangString(name), new OtpErlangBinary(request_info), new OtpErlangBinary(request), new OtpErlangUInt(timeout.intValue()), new OtpErlangInt((int)priority.byteValue()), new OtpErlangBinary(trans_id), pid};
            forward_async.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
            this.send(forward_async);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return;
        }
        throw new ForwardAsyncException();
    }

    public void forward_sync(String name, byte[] request_info, byte[] request, Integer timeout, Byte priority, byte[] trans_id, OtpErlangPid pid) throws ForwardSyncException {
        if (this.request_timeout_adjustment && timeout == this.request_timeout) {
            int elapsed = (int)Math.max(0.0, (double)(System.nanoTime() - this.request_timer) * 1.0E-6);
            timeout = elapsed > timeout ? Integer.valueOf(0) : Integer.valueOf(timeout - elapsed);
        }
        try {
            OtpOutputStream forward_sync = new OtpOutputStream();
            forward_sync.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("forward_sync"), new OtpErlangString(name), new OtpErlangBinary(request_info), new OtpErlangBinary(request), new OtpErlangUInt(timeout.intValue()), new OtpErlangInt((int)priority.byteValue()), new OtpErlangBinary(trans_id), pid};
            forward_sync.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
            this.send(forward_sync);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return;
        }
        throw new ForwardSyncException();
    }

    public void return_(Integer command, String name, String pattern, byte[] response_info, byte[] response, Integer timeout, byte[] trans_id, OtpErlangPid pid) throws ReturnAsyncException, ReturnSyncException, InvalidInputException {
        if (command == 1) {
            this.return_async(name, pattern, response_info, response, timeout, trans_id, pid);
        } else if (command == -1) {
            this.return_sync(name, pattern, response_info, response, timeout, trans_id, pid);
        } else {
            throw new InvalidInputException();
        }
    }

    public void return_async(String name, String pattern, byte[] response_info, byte[] response, Integer timeout, byte[] trans_id, OtpErlangPid pid) throws ReturnAsyncException {
        if (this.request_timeout_adjustment && timeout == this.request_timeout) {
            int elapsed = (int)Math.max(0.0, (double)(System.nanoTime() - this.request_timer) * 1.0E-6);
            if (elapsed > timeout) {
                response_info = new byte[]{};
                response = new byte[]{};
                timeout = 0;
            } else {
                timeout = timeout - elapsed;
            }
        }
        try {
            OtpOutputStream return_async = new OtpOutputStream();
            return_async.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("return_async"), new OtpErlangString(name), new OtpErlangString(pattern), new OtpErlangBinary(response_info), new OtpErlangBinary(response), new OtpErlangUInt(timeout.intValue()), new OtpErlangBinary(trans_id), pid};
            return_async.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
            this.send(return_async);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return;
        }
        throw new ReturnAsyncException();
    }

    public void return_sync(String name, String pattern, byte[] response_info, byte[] response, Integer timeout, byte[] trans_id, OtpErlangPid pid) throws ReturnSyncException {
        if (this.request_timeout_adjustment && timeout == this.request_timeout) {
            int elapsed = (int)Math.max(0.0, (double)(System.nanoTime() - this.request_timer) * 1.0E-6);
            if (elapsed > timeout) {
                response_info = new byte[]{};
                response = new byte[]{};
                timeout = 0;
            } else {
                timeout = timeout - elapsed;
            }
        }
        try {
            OtpOutputStream return_sync = new OtpOutputStream();
            return_sync.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("return_sync"), new OtpErlangString(name), new OtpErlangString(pattern), new OtpErlangBinary(response_info), new OtpErlangBinary(response), new OtpErlangUInt(timeout.intValue()), new OtpErlangBinary(trans_id), pid};
            return_sync.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
            this.send(return_sync);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return;
        }
        throw new ReturnSyncException();
    }

    public Response recv_async() throws MessageDecodingException, TerminateException {
        return this.recv_async(this.timeout_sync, TransIdNull, true);
    }

    public Response recv_async(Integer timeout) throws MessageDecodingException, TerminateException {
        return this.recv_async(timeout, TransIdNull, true);
    }

    public Response recv_async(byte[] trans_id) throws MessageDecodingException, TerminateException {
        return this.recv_async(this.timeout_sync, trans_id, true);
    }

    public Response recv_async(boolean consume) throws MessageDecodingException, TerminateException {
        return this.recv_async(this.timeout_sync, TransIdNull, consume);
    }

    public Response recv_async(Integer timeout, byte[] trans_id) throws MessageDecodingException, TerminateException {
        return this.recv_async(timeout, trans_id, true);
    }

    public Response recv_async(Integer timeout, boolean consume) throws MessageDecodingException, TerminateException {
        return this.recv_async(timeout, TransIdNull, consume);
    }

    public Response recv_async(byte[] trans_id, boolean consume) throws MessageDecodingException, TerminateException {
        return this.recv_async(this.timeout_sync, trans_id, consume);
    }

    public Response recv_async(Integer timeout, byte[] trans_id, boolean consume) throws MessageDecodingException, TerminateException {
        try {
            OtpOutputStream recv_async = new OtpOutputStream();
            recv_async.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("recv_async"), new OtpErlangUInt(timeout.intValue()), new OtpErlangBinary(trans_id), consume ? new OtpErlangAtom("true") : new OtpErlangAtom("false")};
            recv_async.write_any((OtpErlangObject)new OtpErlangTuple(tuple));
            this.send(recv_async);
            return (Response)this.poll_request(false);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    public int process_index() {
        return this.process_index;
    }

    public int process_count() {
        return this.process_count;
    }

    public int process_count_max() {
        return this.process_count_max;
    }

    public int process_count_min() {
        return this.process_count_min;
    }

    public String prefix() {
        return this.prefix;
    }

    public int timeout_initialize() {
        return this.timeout_initialize;
    }

    public int timeout_async() {
        return this.timeout_async;
    }

    public int timeout_sync() {
        return this.timeout_sync;
    }

    public int timeout_terminate() {
        return this.timeout_terminate;
    }

    private void callback(int command, String name, String pattern, byte[] request_info, byte[] request, Integer timeout, Byte priority, byte[] trans_id, OtpErlangPid pid) throws MessageDecodingException, TerminateException {
        long request_time_start = 0L;
        if (this.request_timeout_adjustment) {
            this.request_timer = System.nanoTime();
            this.request_timeout = timeout;
        }
        LinkedList<Function9<Integer, String, String, byte[], byte[], Integer, Byte, byte[], OtpErlangPid>> callback_list = this.callbacks.get(pattern);
        callback_list.addLast(callback_list.removeFirst());
        Function9<Integer, String, String, byte[], byte[], Integer, Byte, byte[], OtpErlangPid> callback = callback_list.peekLast();
        if (command == 2) {
            try {
                Object response = callback.invoke(1, name, pattern, request_info, request, timeout, priority, trans_id, pid);
                if (response.getClass() == byte[][].class) {
                    byte[][] response_array = (byte[][])response;
                    assert (response_array.length == 2) : "invalid response";
                    this.return_async(name, pattern, response_array[0], response_array[1], timeout, trans_id, pid);
                } else if (response.getClass() == byte[].class) {
                    this.return_async(name, pattern, "".getBytes(), (byte[])response, timeout, trans_id, pid);
                } else {
                    this.return_async(name, pattern, "".getBytes(), response.toString().getBytes(), timeout, trans_id, pid);
                }
                return;
            }
            catch (ReturnAsyncException e_return) {
                return;
            }
            catch (ForwardAsyncException e_forward) {
                return;
            }
            catch (Throwable e) {
                e.printStackTrace(err);
                try {
                    this.return_async(name, pattern, "".getBytes(), "".getBytes(), timeout, trans_id, pid);
                }
                catch (ReturnAsyncException e_return) {
                    // empty catch block
                }
                return;
            }
        }
        if (command == 3) {
            try {
                Object response = callback.invoke(-1, name, pattern, request_info, request, timeout, priority, trans_id, pid);
                if (response.getClass() == byte[][].class) {
                    byte[][] response_array = (byte[][])response;
                    assert (response_array.length == 2) : "invalid response";
                    this.return_sync(name, pattern, response_array[0], response_array[1], timeout, trans_id, pid);
                } else if (response.getClass() == byte[].class) {
                    this.return_sync(name, pattern, "".getBytes(), (byte[])response, timeout, trans_id, pid);
                } else {
                    this.return_sync(name, pattern, "".getBytes(), response.toString().getBytes(), timeout, trans_id, pid);
                }
                return;
            }
            catch (ReturnSyncException e_return) {
                return;
            }
            catch (ForwardSyncException e_forward) {
                return;
            }
            catch (Throwable e) {
                e.printStackTrace(err);
                try {
                    this.return_sync(name, pattern, "".getBytes(), "".getBytes(), timeout, trans_id, pid);
                }
                catch (ReturnSyncException e_return) {
                    // empty catch block
                }
                return;
            }
        }
        throw new MessageDecodingException();
    }

    private boolean handle_events(boolean external, ByteBuffer buffer) throws MessageDecodingException, TerminateException {
        return this.handle_events(external, buffer, 0);
    }

    private boolean handle_events(boolean external, ByteBuffer buffer, int command) throws MessageDecodingException, TerminateException, BufferUnderflowException {
        if (command == 0) {
            command = buffer.getInt();
        }
        while (true) {
            switch (command) {
                case 11: {
                    this.terminate = true;
                    if (external) {
                        return false;
                    }
                    throw new TerminateException(this.timeout_terminate);
                }
                case 9: {
                    this.process_count = buffer.getInt();
                    break;
                }
                case 8: {
                    OtpOutputStream keepalive = new OtpOutputStream();
                    keepalive.write(131);
                    keepalive.write_any((OtpErlangObject)new OtpErlangAtom("keepalive"));
                    this.send(keepalive);
                    break;
                }
                default: {
                    throw new MessageDecodingException();
                }
            }
            if (!buffer.hasRemaining()) {
                return true;
            }
            command = buffer.getInt();
        }
    }

    private Object poll_request(boolean external) throws MessageDecodingException, TerminateException {
        ByteBuffer buffer;
        if (this.terminate) {
            return null;
        }
        if (external && !this.initialization_complete) {
            OtpOutputStream polling = new OtpOutputStream();
            polling.write(131);
            polling.write_any((OtpErlangObject)new OtpErlangAtom("polling"));
            this.send(polling);
            this.initialization_complete = true;
        }
        if ((buffer = this.recv(null)) == null || buffer.remaining() == 0) {
            return null;
        }
        try {
            block13: while (true) {
                int command = buffer.getInt();
                switch (command) {
                    case 1: {
                        this.process_index = buffer.getInt();
                        this.process_count = buffer.getInt();
                        this.process_count_max = buffer.getInt();
                        this.process_count_min = buffer.getInt();
                        int prefix_size = buffer.getInt();
                        this.prefix = API.getString(buffer, prefix_size);
                        this.timeout_initialize = buffer.getInt();
                        this.timeout_async = buffer.getInt();
                        this.timeout_sync = buffer.getInt();
                        this.timeout_terminate = buffer.getInt();
                        this.priority_default = buffer.get();
                        boolean bl = this.request_timeout_adjustment = (buffer.get() & 0xFF) != 0;
                        if (buffer.hasRemaining()) {
                            assert (!external);
                            this.handle_events(external, buffer);
                        }
                        return null;
                    }
                    case 2: 
                    case 3: {
                        int name_size = buffer.getInt();
                        String name = API.getString(buffer, name_size);
                        int pattern_size = buffer.getInt();
                        String pattern = API.getString(buffer, pattern_size);
                        int request_info_size = buffer.getInt();
                        byte[] request_info = API.getBytes(buffer, request_info_size);
                        buffer.get();
                        int request_size = buffer.getInt();
                        byte[] request = API.getBytes(buffer, request_size);
                        buffer.get();
                        int timeout = buffer.getInt();
                        byte priority = buffer.get();
                        byte[] trans_id = API.getBytes(buffer, 16);
                        int pid_size = buffer.getInt();
                        OtpErlangPid pid = API.getPid(buffer, pid_size);
                        if (buffer.hasRemaining()) {
                            assert (external);
                            if (!this.handle_events(external, buffer)) {
                                return null;
                            }
                        }
                        this.callback(command, name, pattern, request_info, request, timeout, priority, trans_id, pid);
                        break;
                    }
                    case 4: 
                    case 6: {
                        int response_info_size = buffer.getInt();
                        byte[] response_info = API.getBytes(buffer, response_info_size);
                        buffer.get();
                        int response_size = buffer.getInt();
                        byte[] response = API.getBytes(buffer, response_size);
                        buffer.get();
                        byte[] trans_id = API.getBytes(buffer, 16);
                        if (buffer.hasRemaining()) {
                            assert (!external);
                            this.handle_events(external, buffer);
                        }
                        return new Response(response_info, response, trans_id);
                    }
                    case 5: {
                        byte[] trans_id = API.getBytes(buffer, 16);
                        if (buffer.hasRemaining()) {
                            assert (!external);
                            this.handle_events(external, buffer);
                        }
                        return new TransId(trans_id);
                    }
                    case 7: {
                        int trans_id_count = buffer.getInt();
                        ArrayList<TransId> trans_ids = new ArrayList<TransId>();
                        for (int i = 0; i < trans_id_count; ++i) {
                            byte[] trans_id = API.getBytes(buffer, 16);
                            trans_ids.add(new TransId(trans_id));
                        }
                        if (buffer.hasRemaining()) {
                            assert (!external);
                            this.handle_events(external, buffer);
                        }
                        return trans_ids;
                    }
                    case 10: {
                        int count = buffer.getInt();
                        if (buffer.hasRemaining()) {
                            assert (!external);
                            this.handle_events(external, buffer);
                        }
                        return count;
                    }
                    case 11: {
                        if (!this.handle_events(external, buffer, command)) {
                            return null;
                        }
                        assert (false);
                        break;
                    }
                    case 9: {
                        this.process_count = buffer.getInt();
                        if (!buffer.hasRemaining()) break;
                        continue block13;
                    }
                    case 8: {
                        OtpOutputStream keepalive = new OtpOutputStream();
                        keepalive.write(131);
                        keepalive.write_any((OtpErlangObject)new OtpErlangAtom("keepalive"));
                        this.send(keepalive);
                        if (!buffer.hasRemaining()) break;
                        continue block13;
                    }
                    default: {
                        throw new MessageDecodingException();
                    }
                }
                if ((buffer = this.recv(buffer)) == null || buffer.remaining() == 0) break;
            }
            return null;
        }
        catch (BufferUnderflowException e) {
            throw new MessageDecodingException();
        }
    }

    public Object poll() throws MessageDecodingException, TerminateException {
        return this.poll_request(true);
    }

    private HashMap<String, List<String>> binary_key_value_parse(byte[] binary) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        String key = null;
        int binary_i = 0;
        for (int binary_j = 0; binary_j < binary.length; ++binary_j) {
            if (binary[binary_j] != 0) continue;
            if (key == null) {
                key = new String(binary, binary_i, binary_j - binary_i);
            } else {
                List<String> value = result.get(key);
                String element = new String(binary, binary_i, binary_j - binary_i);
                if (value == null) {
                    value = new ArrayList<String>();
                    value.add(element);
                    result.put(key, value);
                } else {
                    value.add(element);
                }
                key = null;
            }
            binary_i = binary_j + 1;
        }
        return result;
    }

    public HashMap<String, List<String>> request_http_qs_parse(byte[] request) {
        return this.binary_key_value_parse(request);
    }

    public HashMap<String, List<String>> info_key_value_parse(byte[] info) {
        return this.binary_key_value_parse(info);
    }

    private void send(OtpOutputStream command) {
        try {
            if (this.use_header) {
                long length = command.size();
                byte[] header = new byte[]{(byte)((length & 0xFFFFFFFFFF000000L) >> 24), (byte)((length & 0xFF0000L) >> 16), (byte)((length & 0xFF00L) >> 8), (byte)(length & 0xFFL)};
                this.output.write(header);
            }
            command.writeTo((OutputStream)this.output);
        }
        catch (IOException e) {
            e.printStackTrace(err);
            return;
        }
    }

    private ByteBuffer recv(ByteBuffer buffer_in) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            if (buffer_in != null && buffer_in.hasRemaining()) {
                output.write(buffer_in.array(), buffer_in.position(), buffer_in.limit());
            }
            int read = 0;
            byte[] bytes = new byte[this.buffer_size];
            boolean consume = true;
            while (consume) {
                while ((read = this.input.read(bytes)) == this.buffer_size && this.input.available() > 0) {
                    output.write(bytes, 0, this.buffer_size);
                }
                if (read == -1) {
                    return null;
                }
                output.write(bytes, 0, read);
                if (!this.use_header) {
                    consume = false;
                    continue;
                }
                if (output.size() < 4) continue;
                consume = false;
            }
            byte[] result = output.toByteArray();
            ByteBuffer buffer_out = null;
            if (this.use_header) {
                long length = result[0] << 24 | result[1] << 16 | result[2] << 8 | result[3];
                if ((long)output.size() != length + 4L) {
                    assert ((long)output.size() < length + 4L) : "recv overflow";
                    output = new ByteArrayOutputStream();
                    output.write(result, 4, result.length - 4);
                    while ((long)output.size() < length) {
                        read = this.input.read(bytes, 0, Math.min((int)(length - (long)output.size()), this.buffer_size));
                        if (read == -1) {
                            return null;
                        }
                        output.write(bytes, 0, read);
                    }
                    result = output.toByteArray();
                    buffer_out = ByteBuffer.wrap(result);
                } else {
                    buffer_out = ByteBuffer.wrap(result, 4, result.length - 4);
                }
            } else {
                buffer_out = ByteBuffer.wrap(result);
            }
            buffer_out.order(ByteOrder.nativeOrder());
            return buffer_out;
        }
        catch (IOException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    private static String getString(ByteBuffer buffer, int size) {
        String value = new String(API.getBytes(buffer, size - 1));
        buffer.position(buffer.position() + 1);
        return value;
    }

    private static OtpErlangPid getPid(ByteBuffer buffer, int size) {
        try {
            return new OtpInputStream(API.getBytes(buffer, size)).read_pid();
        }
        catch (OtpErlangDecodeException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    private static byte[] getBytes(ByteBuffer buffer, int size) {
        byte[] data = new byte[size];
        buffer.get(data, 0, size);
        return data;
    }

    private static FileDescriptor storeFD(int fd) {
        FileDescriptor object;
        Constructor c;
        Class<FileDescriptor> clazz = FileDescriptor.class;
        try {
            Class[] intarg = new Class[]{Integer.TYPE};
            c = clazz.getDeclaredConstructor(intarg);
        }
        catch (SecurityException e) {
            e.printStackTrace(err);
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace(err);
            return null;
        }
        c.setAccessible(true);
        try {
            object = (FileDescriptor)c.newInstance(new Integer(fd));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(err);
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace(err);
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(err);
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace(err);
            return null;
        }
        return object;
    }

    public static class TerminateException
    extends Exception {
        private static final long serialVersionUID = 0L;
        private int timeout;

        TerminateException(int timeout) {
            super("Terminate");
            this.timeout = timeout;
        }

        public int timeout() {
            return this.timeout;
        }
    }

    public static class MessageDecodingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        MessageDecodingException() {
            super("Message Decoding Error");
        }
    }

    public static class ForwardAsyncException
    extends Exception {
        private static final long serialVersionUID = 3L;

        ForwardAsyncException() {
            super("Asynchronous Call Forward Invalid");
        }
    }

    public static class ForwardSyncException
    extends Exception {
        private static final long serialVersionUID = 3L;

        ForwardSyncException() {
            super("Synchronous Call Forward Invalid");
        }
    }

    public static class ReturnAsyncException
    extends Exception {
        private static final long serialVersionUID = 3L;

        ReturnAsyncException() {
            super("Asynchronous Call Return Invalid");
        }
    }

    public static class ReturnSyncException
    extends Exception {
        private static final long serialVersionUID = 3L;

        ReturnSyncException() {
            super("Synchronous Call Return Invalid");
        }
    }

    public static class InvalidInputException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidInputException() {
            super("Invalid Input");
        }
    }

    public class TransId {
        public final byte[] id;

        TransId(byte[] trans_id) {
            this.id = trans_id;
        }

        public boolean equals(byte[] bytes) {
            return Arrays.equals(this.id, bytes);
        }

        public boolean isTimeout() {
            return this.equals(TransIdNull);
        }

        public String toString() {
            return new String(this.id);
        }
    }

    public class Response {
        public final byte[] response_info;
        public final byte[] response;
        public final byte[] id;

        Response(byte[] info, byte[] resp, byte[] trans_id) {
            this.response_info = info;
            this.response = resp;
            this.id = trans_id;
        }

        public boolean isEmpty() {
            return this.response.length == 0;
        }

        public boolean isTimeout() {
            return Arrays.equals(this.id, TransIdNull);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("('");
            result.append(new String(this.response_info));
            result.append("', '");
            result.append(new String(this.response));
            result.append("', '");
            result.append(new String(this.id));
            result.append("')");
            return result.toString();
        }
    }
}

