/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpInputStream;

public class OtpMsg {
    public static final int linkTag = 1;
    public static final int sendTag = 2;
    public static final int exitTag = 3;
    public static final int unlinkTag = 4;
    public static final int regSendTag = 6;
    public static final int exit2Tag = 8;
    protected int tag;
    protected OtpInputStream paybuf;
    protected OtpErlangObject payload;
    protected OtpErlangPid from;
    protected OtpErlangPid to;
    protected String toName;

    OtpMsg(OtpErlangPid to, OtpInputStream paybuf) {
        this.tag = 2;
        this.from = null;
        this.to = to;
        this.toName = null;
        this.paybuf = paybuf;
        this.payload = null;
    }

    OtpMsg(OtpErlangPid to, OtpErlangObject payload) {
        this.tag = 2;
        this.from = null;
        this.to = to;
        this.toName = null;
        this.paybuf = null;
        this.payload = payload;
    }

    OtpMsg(OtpErlangPid from, String toName, OtpInputStream paybuf) {
        this.tag = 6;
        this.from = from;
        this.toName = toName;
        this.to = null;
        this.paybuf = paybuf;
        this.payload = null;
    }

    OtpMsg(OtpErlangPid from, String toName, OtpErlangObject payload) {
        this.tag = 6;
        this.from = from;
        this.toName = toName;
        this.to = null;
        this.paybuf = null;
        this.payload = payload;
    }

    OtpMsg(int tag, OtpErlangPid from, OtpErlangPid to, OtpErlangObject reason) {
        this.tag = tag;
        this.from = from;
        this.to = to;
        this.paybuf = null;
        this.payload = reason;
    }

    OtpMsg(int tag, OtpErlangPid from, OtpErlangPid to, String reason) {
        this.tag = tag;
        this.from = from;
        this.to = to;
        this.paybuf = null;
        this.payload = new OtpErlangAtom(reason);
    }

    OtpMsg(int tag, OtpErlangPid from, OtpErlangPid to) {
        int atag = tag;
        if (tag > 10) {
            atag -= 10;
        }
        this.tag = atag;
        this.from = from;
        this.to = to;
    }

    OtpInputStream getMsgBuf() {
        return this.paybuf;
    }

    public int type() {
        return this.tag;
    }

    public OtpErlangObject getMsg() throws OtpErlangDecodeException {
        if (this.payload == null) {
            this.payload = this.paybuf.read_any();
        }
        return this.payload;
    }

    public String getRecipientName() {
        return this.toName;
    }

    public OtpErlangPid getRecipientPid() {
        return this.to;
    }

    public Object getRecipient() {
        if (this.toName != null) {
            return this.toName;
        }
        return this.to;
    }

    public OtpErlangPid getSenderPid() {
        return this.from;
    }
}

