/*
 * Decompiled with CFR 0.152.
 */
package org.cloudi;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangBinary;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpErlangUInt;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cloudi.FunctionInterface10;
import org.cloudi.FunctionInterface9;
import org.cloudi.FunctionObject10;
import org.cloudi.FunctionObject9;

public class API {
    public static final PrintStream out = API.unbuffered(System.out);
    public static final PrintStream err = API.unbuffered(System.err);
    public static final int ASYNC = 1;
    public static final int SYNC = -1;
    private static final int MESSAGE_INIT = 1;
    private static final int MESSAGE_SEND_ASYNC = 2;
    private static final int MESSAGE_SEND_SYNC = 3;
    private static final int MESSAGE_RECV_ASYNC = 4;
    private static final int MESSAGE_RETURN_ASYNC = 5;
    private static final int MESSAGE_RETURN_SYNC = 6;
    private static final int MESSAGE_RETURNS_ASYNC = 7;
    private static final int MESSAGE_KEEPALIVE = 8;
    private static final int MESSAGE_REINIT = 9;
    private static final int MESSAGE_SUBSCRIBE_COUNT = 10;
    private static final int MESSAGE_TERM = 11;
    private final FileDescriptor fd_in;
    private final FileDescriptor fd_out;
    private final boolean use_header;
    private final FileOutputStream output;
    private final FileInputStream input;
    private final ExecutorService poll_timer_executor;
    private boolean initialization_complete;
    private boolean terminate;
    private final HashMap<String, LinkedList<FunctionInterface9>> callbacks;
    private final FunctionInterface9 null_response;
    private final int buffer_size;
    private int process_index;
    private int process_count;
    private int process_count_max;
    private int process_count_min;
    private String prefix;
    private int timeout_initialize;
    private int timeout_async;
    private int timeout_sync;
    private int timeout_terminate;
    private byte priority_default;
    public static final byte[] TransIdNull = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private static PrintStream unbuffered(PrintStream stream) {
        try {
            return new PrintStream((OutputStream)stream, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new PrintStream(stream, true);
        }
    }

    public API(int thread_index) throws InvalidInputException, MessageDecodingException, TerminateException {
        String protocol = System.getenv("CLOUDI_API_INIT_PROTOCOL");
        if (protocol == null) {
            throw new InvalidInputException();
        }
        String buffer_size_str = System.getenv("CLOUDI_API_INIT_BUFFER_SIZE");
        if (buffer_size_str == null) {
            throw new InvalidInputException();
        }
        if (protocol.compareTo("tcp") == 0) {
            this.fd_in = this.fd_out = API.storeFD(thread_index + 3);
            this.use_header = true;
        } else if (protocol.compareTo("udp") == 0) {
            this.fd_in = this.fd_out = API.storeFD(thread_index + 3);
            this.use_header = false;
        } else if (protocol.compareTo("local") == 0) {
            this.fd_in = this.fd_out = API.storeFD(thread_index + 3);
            this.use_header = true;
        } else {
            throw new InvalidInputException();
        }
        assert (this.fd_in != null);
        assert (this.fd_out != null);
        this.output = new FileOutputStream(this.fd_out);
        this.input = new FileInputStream(this.fd_in);
        this.poll_timer_executor = Executors.newFixedThreadPool(1);
        this.initialization_complete = false;
        this.terminate = false;
        this.callbacks = new HashMap();
        this.null_response = new NullResponse();
        this.buffer_size = Integer.parseInt(buffer_size_str);
        this.process_index = 0;
        this.process_count = 0;
        this.process_count_max = 0;
        this.process_count_min = 0;
        this.timeout_initialize = 5000;
        this.timeout_async = 5000;
        this.timeout_sync = 5000;
        this.timeout_terminate = 1000;
        this.priority_default = 0;
        OtpOutputStream init = new OtpOutputStream();
        init.write(131);
        init.write_any(new OtpErlangAtom("init"));
        this.send(init);
        this.poll_request(null, false);
    }

    public static int thread_count() throws InvalidInputException {
        String s = System.getenv("CLOUDI_API_INIT_THREAD_COUNT");
        if (s == null) {
            throw new InvalidInputException();
        }
        int thread_count = Integer.parseInt(s);
        return thread_count;
    }

    public void subscribe(String pattern, Object instance, String methodName) throws NoSuchMethodException {
        this.subscribe(pattern, new FunctionObject9(instance, methodName));
    }

    public void subscribe(String pattern, Class<?> clazz, String methodName) throws NoSuchMethodException {
        this.subscribe(pattern, new FunctionObject9(this, clazz, methodName));
    }

    public void subscribe(String pattern, FunctionInterface10 callback) {
        this.subscribe(pattern, new FunctionObject10(this, callback));
    }

    public void subscribe(String pattern, FunctionInterface9 callback) {
        String s = this.prefix + pattern;
        LinkedList<FunctionInterface9> callback_list = this.callbacks.get(s);
        if (callback_list == null) {
            callback_list = new LinkedList();
            callback_list.addLast(callback);
            this.callbacks.put(s, callback_list);
        } else {
            callback_list.addLast(callback);
        }
        OtpOutputStream subscribe = new OtpOutputStream();
        subscribe.write(131);
        OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("subscribe"), new OtpErlangString(pattern)};
        subscribe.write_any(new OtpErlangTuple(tuple));
        this.send(subscribe);
    }

    public int subscribe_count(String pattern) throws InvalidInputException, TerminateException {
        OtpOutputStream subscribe_count = new OtpOutputStream();
        subscribe_count.write(131);
        OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("subscribe_count"), new OtpErlangString(pattern)};
        subscribe_count.write_any(new OtpErlangTuple(tuple));
        this.send(subscribe_count);
        try {
            return (Integer)this.poll_request(null, false);
        }
        catch (MessageDecodingException e) {
            e.printStackTrace(err);
            return -1;
        }
    }

    public void unsubscribe(String pattern) throws InvalidInputException {
        String s = this.prefix + pattern;
        LinkedList<FunctionInterface9> callback_list = this.callbacks.get(s);
        if (callback_list == null) {
            throw new InvalidInputException();
        }
        callback_list.removeFirst();
        if (callback_list.isEmpty()) {
            this.callbacks.remove(s);
        }
        OtpOutputStream unsubscribe = new OtpOutputStream();
        unsubscribe.write(131);
        OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("unsubscribe"), new OtpErlangString(pattern)};
        unsubscribe.write_any(new OtpErlangTuple(tuple));
        this.send(unsubscribe);
    }

    public TransId send_async(String name, byte[] request) throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.send_async(name, "".getBytes(), request, this.timeout_async, this.priority_default);
    }

    public TransId send_async(String name, byte[] request_info, byte[] request, Integer timeout, Byte priority) throws InvalidInputException, MessageDecodingException, TerminateException {
        try {
            OtpOutputStream send_async = new OtpOutputStream();
            send_async.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("send_async"), new OtpErlangString(name), new OtpErlangBinary(request_info), new OtpErlangBinary(request), new OtpErlangUInt(timeout), new OtpErlangInt(priority.byteValue())};
            send_async.write_any(new OtpErlangTuple(tuple));
            this.send(send_async);
            return (TransId)this.poll_request(null, false);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    public Response send_sync(String name, byte[] request) throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.send_sync(name, "".getBytes(), request, this.timeout_sync, this.priority_default);
    }

    public Response send_sync(String name, byte[] request_info, byte[] request, Integer timeout, Byte priority) throws InvalidInputException, MessageDecodingException, TerminateException {
        try {
            OtpOutputStream send_sync = new OtpOutputStream();
            send_sync.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("send_sync"), new OtpErlangString(name), new OtpErlangBinary(request_info), new OtpErlangBinary(request), new OtpErlangUInt(timeout), new OtpErlangInt(priority.byteValue())};
            send_sync.write_any(new OtpErlangTuple(tuple));
            this.send(send_sync);
            return (Response)this.poll_request(null, false);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    public ArrayList<TransId> mcast_async(String name, byte[] request) throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.mcast_async(name, new byte[0], request, this.timeout_async, this.priority_default);
    }

    public ArrayList<TransId> mcast_async(String name, byte[] request_info, byte[] request, Integer timeout, Byte priority) throws InvalidInputException, MessageDecodingException, TerminateException {
        try {
            OtpOutputStream mcast_async = new OtpOutputStream();
            mcast_async.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("mcast_async"), new OtpErlangString(name), new OtpErlangBinary(request_info), new OtpErlangBinary(request), new OtpErlangUInt(timeout), new OtpErlangInt(priority.byteValue())};
            mcast_async.write_any(new OtpErlangTuple(tuple));
            this.send(mcast_async);
            return (ArrayList)this.poll_request(null, false);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    public void forward_(Integer request_type, String name, byte[] request_info, byte[] request, Integer timeout, Byte priority, byte[] trans_id, OtpErlangPid pid) throws ForwardAsyncException, ForwardSyncException, InvalidInputException {
        if (request_type == 1) {
            this.forward_async(name, request_info, request, timeout, priority, trans_id, pid);
        } else if (request_type == -1) {
            this.forward_sync(name, request_info, request, timeout, priority, trans_id, pid);
        } else {
            throw new InvalidInputException();
        }
    }

    public void forward_async(String name, byte[] request_info, byte[] request, Integer timeout, Byte priority, byte[] trans_id, OtpErlangPid pid) throws ForwardAsyncException {
        try {
            OtpOutputStream forward_async = new OtpOutputStream();
            forward_async.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("forward_async"), new OtpErlangString(name), new OtpErlangBinary(request_info), new OtpErlangBinary(request), new OtpErlangUInt(timeout), new OtpErlangInt(priority.byteValue()), new OtpErlangBinary(trans_id), pid};
            forward_async.write_any(new OtpErlangTuple(tuple));
            this.send(forward_async);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return;
        }
        throw new ForwardAsyncException();
    }

    public void forward_sync(String name, byte[] request_info, byte[] request, Integer timeout, Byte priority, byte[] trans_id, OtpErlangPid pid) throws ForwardSyncException {
        try {
            OtpOutputStream forward_sync = new OtpOutputStream();
            forward_sync.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("forward_sync"), new OtpErlangString(name), new OtpErlangBinary(request_info), new OtpErlangBinary(request), new OtpErlangUInt(timeout), new OtpErlangInt(priority.byteValue()), new OtpErlangBinary(trans_id), pid};
            forward_sync.write_any(new OtpErlangTuple(tuple));
            this.send(forward_sync);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return;
        }
        throw new ForwardSyncException();
    }

    public void return_(Integer request_type, String name, String pattern, byte[] response_info, byte[] response, Integer timeout, byte[] trans_id, OtpErlangPid pid) throws ReturnAsyncException, ReturnSyncException, InvalidInputException {
        if (request_type == 1) {
            this.return_async(name, pattern, response_info, response, timeout, trans_id, pid);
        } else if (request_type == -1) {
            this.return_sync(name, pattern, response_info, response, timeout, trans_id, pid);
        } else {
            throw new InvalidInputException();
        }
    }

    public void return_async(String name, String pattern, byte[] response_info, byte[] response, Integer timeout, byte[] trans_id, OtpErlangPid pid) throws ReturnAsyncException {
        try {
            OtpOutputStream return_async = new OtpOutputStream();
            return_async.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("return_async"), new OtpErlangString(name), new OtpErlangString(pattern), new OtpErlangBinary(response_info), new OtpErlangBinary(response), new OtpErlangUInt(timeout), new OtpErlangBinary(trans_id), pid};
            return_async.write_any(new OtpErlangTuple(tuple));
            this.send(return_async);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return;
        }
        throw new ReturnAsyncException();
    }

    public void return_sync(String name, String pattern, byte[] response_info, byte[] response, Integer timeout, byte[] trans_id, OtpErlangPid pid) throws ReturnSyncException {
        try {
            OtpOutputStream return_sync = new OtpOutputStream();
            return_sync.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("return_sync"), new OtpErlangString(name), new OtpErlangString(pattern), new OtpErlangBinary(response_info), new OtpErlangBinary(response), new OtpErlangUInt(timeout), new OtpErlangBinary(trans_id), pid};
            return_sync.write_any(new OtpErlangTuple(tuple));
            this.send(return_sync);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return;
        }
        throw new ReturnSyncException();
    }

    public Response recv_async() throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.recv_async(this.timeout_sync, TransIdNull, true);
    }

    public Response recv_async(Integer timeout) throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.recv_async(timeout, TransIdNull, true);
    }

    public Response recv_async(byte[] trans_id) throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.recv_async(this.timeout_sync, trans_id, true);
    }

    public Response recv_async(boolean consume) throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.recv_async(this.timeout_sync, TransIdNull, consume);
    }

    public Response recv_async(Integer timeout, byte[] trans_id) throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.recv_async(timeout, trans_id, true);
    }

    public Response recv_async(Integer timeout, boolean consume) throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.recv_async(timeout, TransIdNull, consume);
    }

    public Response recv_async(byte[] trans_id, boolean consume) throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.recv_async(this.timeout_sync, trans_id, consume);
    }

    public Response recv_async(Integer timeout, byte[] trans_id, boolean consume) throws InvalidInputException, MessageDecodingException, TerminateException {
        try {
            OtpOutputStream recv_async = new OtpOutputStream();
            recv_async.write(131);
            OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("recv_async"), new OtpErlangUInt(timeout), new OtpErlangBinary(trans_id), consume ? new OtpErlangAtom("true") : new OtpErlangAtom("false")};
            recv_async.write_any(new OtpErlangTuple(tuple));
            this.send(recv_async);
            return (Response)this.poll_request(null, false);
        }
        catch (OtpErlangRangeException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    public int process_index() {
        return this.process_index;
    }

    public int process_count() {
        return this.process_count;
    }

    public int process_count_max() {
        return this.process_count_max;
    }

    public int process_count_min() {
        return this.process_count_min;
    }

    public String prefix() {
        return this.prefix;
    }

    public int timeout_initialize() {
        return this.timeout_initialize;
    }

    public int timeout_async() {
        return this.timeout_async;
    }

    public int timeout_sync() {
        return this.timeout_sync;
    }

    public int timeout_terminate() {
        return this.timeout_terminate;
    }

    private void callback(int command, String name, String pattern, byte[] request_info, byte[] request, Integer timeout, Byte priority, byte[] trans_id, OtpErlangPid pid) throws InvalidInputException, MessageDecodingException, TerminateException {
        LinkedList<FunctionInterface9> callback_list = this.callbacks.get(pattern);
        FunctionInterface9 callback = null;
        if (callback_list == null) {
            callback = this.null_response;
        } else {
            callback_list.addLast(callback_list.removeFirst());
            callback = callback_list.peekLast();
        }
        if (command == 2) {
            try {
                Object response = callback.invoke(1, name, pattern, request_info, request, timeout, priority, trans_id, pid);
                if (response == null) {
                    this.return_async(name, pattern, "".getBytes(), "".getBytes(), timeout, trans_id, pid);
                } else if (response.getClass() == byte[][].class) {
                    byte[][] response_array = (byte[][])response;
                    assert (response_array.length == 2) : "invalid response";
                    this.return_async(name, pattern, response_array[0], response_array[1], timeout, trans_id, pid);
                } else if (response.getClass() == byte[].class) {
                    this.return_async(name, pattern, "".getBytes(), (byte[])response, timeout, trans_id, pid);
                } else {
                    this.return_async(name, pattern, "".getBytes(), response.toString().getBytes(), timeout, trans_id, pid);
                }
                return;
            }
            catch (InvalidInputException e) {
                throw e;
            }
            catch (MessageDecodingException e) {
                throw e;
            }
            catch (TerminateException e) {
                throw e;
            }
            catch (ReturnAsyncException e_return) {
                return;
            }
            catch (ForwardAsyncException e_forward) {
                return;
            }
            catch (Throwable e) {
                e.printStackTrace(err);
                try {
                    this.return_async(name, pattern, "".getBytes(), "".getBytes(), timeout, trans_id, pid);
                }
                catch (ReturnAsyncException response_array) {
                    // empty catch block
                }
                return;
            }
        }
        if (command == 3) {
            try {
                Object response = callback.invoke(-1, name, pattern, request_info, request, timeout, priority, trans_id, pid);
                if (response == null) {
                    this.return_sync(name, pattern, "".getBytes(), "".getBytes(), timeout, trans_id, pid);
                } else if (response.getClass() == byte[][].class) {
                    byte[][] response_array = (byte[][])response;
                    assert (response_array.length == 2) : "invalid response";
                    this.return_sync(name, pattern, response_array[0], response_array[1], timeout, trans_id, pid);
                } else if (response.getClass() == byte[].class) {
                    this.return_sync(name, pattern, "".getBytes(), (byte[])response, timeout, trans_id, pid);
                } else {
                    this.return_sync(name, pattern, "".getBytes(), response.toString().getBytes(), timeout, trans_id, pid);
                }
                return;
            }
            catch (InvalidInputException e) {
                throw e;
            }
            catch (MessageDecodingException e) {
                throw e;
            }
            catch (TerminateException e) {
                throw e;
            }
            catch (ReturnSyncException e_return) {
                return;
            }
            catch (ForwardSyncException e_forward) {
                return;
            }
            catch (Throwable e) {
                e.printStackTrace(err);
                try {
                    this.return_sync(name, pattern, "".getBytes(), "".getBytes(), timeout, trans_id, pid);
                }
                catch (ReturnSyncException returnSyncException) {
                    // empty catch block
                }
                return;
            }
        }
        throw new MessageDecodingException();
    }

    private boolean handle_events(boolean external, ByteBuffer buffer) throws MessageDecodingException, TerminateException {
        return this.handle_events(external, buffer, 0);
    }

    private boolean handle_events(boolean external, ByteBuffer buffer, int command) throws MessageDecodingException, TerminateException, BufferUnderflowException {
        if (command == 0) {
            command = buffer.getInt();
        }
        while (true) {
            switch (command) {
                case 11: {
                    this.terminate = true;
                    if (external) {
                        return false;
                    }
                    throw new TerminateException(this.timeout_terminate);
                }
                case 9: {
                    this.process_count = buffer.getInt();
                    this.timeout_async = buffer.getInt();
                    this.timeout_sync = buffer.getInt();
                    this.priority_default = buffer.get();
                    break;
                }
                case 8: {
                    OtpOutputStream keepalive = new OtpOutputStream();
                    keepalive.write(131);
                    keepalive.write_any(new OtpErlangAtom("keepalive"));
                    this.send(keepalive);
                    break;
                }
                default: {
                    throw new MessageDecodingException();
                }
            }
            if (!buffer.hasRemaining()) {
                return true;
            }
            command = buffer.getInt();
        }
    }

    private Object poll_request(Integer timeout, boolean external) throws InvalidInputException, MessageDecodingException, TerminateException {
        if (this.terminate) {
            return Boolean.FALSE;
        }
        if (external && !this.initialization_complete) {
            OtpOutputStream polling = new OtpOutputStream();
            polling.write(131);
            polling.write_any(new OtpErlangAtom("polling"));
            this.send(polling);
            this.initialization_complete = true;
        }
        int timeout_min = 10;
        Integer timeout_value = null;
        Long poll_timer = null;
        if (timeout != null && timeout >= 0 && timeout >= 0) {
            poll_timer = System.nanoTime();
            timeout_value = Math.max(10, timeout);
        }
        try {
            ByteBuffer buffer = null;
            buffer = this.recv(buffer, timeout_value);
            if (buffer == null) {
                return Boolean.TRUE;
            }
            block14: while (true) {
                int command = buffer.getInt();
                switch (command) {
                    case 1: {
                        this.process_index = buffer.getInt();
                        this.process_count = buffer.getInt();
                        this.process_count_max = buffer.getInt();
                        this.process_count_min = buffer.getInt();
                        int prefix_size = buffer.getInt();
                        this.prefix = API.getString(buffer, prefix_size);
                        this.timeout_initialize = buffer.getInt();
                        this.timeout_async = buffer.getInt();
                        this.timeout_sync = buffer.getInt();
                        this.timeout_terminate = buffer.getInt();
                        this.priority_default = buffer.get();
                        if (buffer.hasRemaining()) {
                            assert (!external);
                            this.handle_events(external, buffer);
                        }
                        return Boolean.FALSE;
                    }
                    case 2: 
                    case 3: {
                        int name_size = buffer.getInt();
                        String name = API.getString(buffer, name_size);
                        int pattern_size = buffer.getInt();
                        String pattern = API.getString(buffer, pattern_size);
                        int request_info_size = buffer.getInt();
                        byte[] request_info = API.getBytes(buffer, request_info_size);
                        buffer.get();
                        int request_size = buffer.getInt();
                        byte[] request = API.getBytes(buffer, request_size);
                        buffer.get();
                        int request_timeout = buffer.getInt();
                        byte priority = buffer.get();
                        byte[] trans_id = API.getBytes(buffer, 16);
                        int pid_size = buffer.getInt();
                        OtpErlangPid pid = API.getPid(buffer, pid_size);
                        if (buffer.hasRemaining()) {
                            assert (external);
                            if (!this.handle_events(external, buffer)) {
                                return Boolean.FALSE;
                            }
                        }
                        this.callback(command, name, pattern, request_info, request, request_timeout, priority, trans_id, pid);
                        break;
                    }
                    case 4: 
                    case 6: {
                        int response_info_size = buffer.getInt();
                        byte[] response_info = API.getBytes(buffer, response_info_size);
                        buffer.get();
                        int response_size = buffer.getInt();
                        byte[] response = API.getBytes(buffer, response_size);
                        buffer.get();
                        byte[] trans_id = API.getBytes(buffer, 16);
                        if (buffer.hasRemaining()) {
                            assert (!external);
                            this.handle_events(external, buffer);
                        }
                        return new Response(response_info, response, trans_id);
                    }
                    case 5: {
                        byte[] trans_id = API.getBytes(buffer, 16);
                        if (buffer.hasRemaining()) {
                            assert (!external);
                            this.handle_events(external, buffer);
                        }
                        return new TransId(trans_id);
                    }
                    case 7: {
                        int trans_id_count = buffer.getInt();
                        ArrayList<TransId> trans_ids = new ArrayList<TransId>();
                        for (int i = 0; i < trans_id_count; ++i) {
                            byte[] trans_id = API.getBytes(buffer, 16);
                            trans_ids.add(new TransId(trans_id));
                        }
                        if (buffer.hasRemaining()) {
                            assert (!external);
                            this.handle_events(external, buffer);
                        }
                        return trans_ids;
                    }
                    case 10: {
                        int count = buffer.getInt();
                        if (buffer.hasRemaining()) {
                            assert (!external);
                            this.handle_events(external, buffer);
                        }
                        return count;
                    }
                    case 11: {
                        if (!this.handle_events(external, buffer, command)) {
                            return Boolean.FALSE;
                        }
                        assert (false);
                        break;
                    }
                    case 9: {
                        this.process_count = buffer.getInt();
                        this.timeout_async = buffer.getInt();
                        this.timeout_sync = buffer.getInt();
                        this.priority_default = buffer.get();
                        if (!buffer.hasRemaining()) break;
                        continue block14;
                    }
                    case 8: {
                        OtpOutputStream keepalive = new OtpOutputStream();
                        keepalive.write(131);
                        keepalive.write_any(new OtpErlangAtom("keepalive"));
                        this.send(keepalive);
                        if (!buffer.hasRemaining()) break;
                        continue block14;
                    }
                    default: {
                        throw new MessageDecodingException();
                    }
                }
                if (poll_timer != null) {
                    long poll_timer_new = System.nanoTime();
                    int elapsed = (int)Math.max(0.0, (double)(poll_timer_new - poll_timer) * 1.0E-6);
                    poll_timer = poll_timer_new;
                    timeout = elapsed >= timeout ? Integer.valueOf(0) : Integer.valueOf(timeout - elapsed);
                }
                if (timeout_value != null) {
                    if (timeout == 0) {
                        return Boolean.TRUE;
                    }
                    if (timeout > 0) {
                        timeout_value = Math.max(10, timeout);
                    }
                }
                if ((buffer = this.recv(buffer, timeout_value)) == null) break;
            }
            return Boolean.TRUE;
        }
        catch (IOException e) {
            e.printStackTrace(err);
            throw new MessageDecodingException();
        }
        catch (BufferUnderflowException e) {
            throw new MessageDecodingException();
        }
    }

    public boolean poll() throws InvalidInputException, MessageDecodingException, TerminateException {
        return this.poll(-1);
    }

    public boolean poll(int timeout) throws InvalidInputException, MessageDecodingException, TerminateException {
        return Boolean.TRUE == this.poll_request(timeout, true);
    }

    public void shutdown() {
        this.shutdown("");
    }

    public void shutdown(String reason) {
        OtpOutputStream shutdown = new OtpOutputStream();
        shutdown.write(131);
        OtpErlangObject[] tuple = new OtpErlangObject[]{new OtpErlangAtom("shutdown"), new OtpErlangString(reason)};
        shutdown.write_any(new OtpErlangTuple(tuple));
        this.send(shutdown);
    }

    private HashMap<String, ArrayList<String>> binary_key_value_parse(byte[] b) {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        String key = null;
        int binary_i = 0;
        for (int binary_j = 0; binary_j < b.length; ++binary_j) {
            if (b[binary_j] != 0) continue;
            if (key == null) {
                key = new String(b, binary_i, binary_j - binary_i);
            } else {
                ArrayList<String> value = result.get(key);
                String element = new String(b, binary_i, binary_j - binary_i);
                if (value == null) {
                    value = new ArrayList();
                    value.add(element);
                    result.put(key, value);
                } else {
                    value.add(element);
                }
                key = null;
            }
            binary_i = binary_j + 1;
        }
        return result;
    }

    public HashMap<String, ArrayList<String>> info_key_value_parse(byte[] info) {
        return this.binary_key_value_parse(info);
    }

    private void send(OtpOutputStream command) {
        try {
            if (this.use_header) {
                long length = command.size();
                byte[] header = new byte[]{(byte)((length & 0xFFFFFFFFFF000000L) >> 24), (byte)((length & 0xFF0000L) >> 16), (byte)((length & 0xFF00L) >> 8), (byte)(length & 0xFFL)};
                this.output.write(header);
            }
            command.writeTo(this.output);
        }
        catch (IOException e) {
            e.printStackTrace(err);
            return;
        }
    }

    private ByteBuffer recv(ByteBuffer buffer_in, Integer timeout) throws IOException {
        boolean buffer_in_data;
        boolean bl = buffer_in_data = buffer_in != null && buffer_in.hasRemaining();
        if (!buffer_in_data && timeout != null) {
            final FileInputStream input = this.input;
            Callable<Boolean> poll_timer_task = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    while (input.available() == 0) {
                        Thread.sleep(10L);
                    }
                    return Boolean.TRUE;
                }
            };
            Future<Boolean> poll_timer_future = this.poll_timer_executor.submit(poll_timer_task);
            try {
                poll_timer_future.get(timeout.intValue(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                return null;
            }
            catch (Exception e) {
                e.printStackTrace(err);
                throw new IOException("poll exception");
            }
        }
        int read = 0;
        byte[] bytes = new byte[this.buffer_size];
        ByteBuffer buffer_out = null;
        if (this.use_header) {
            byte[] header = new byte[4];
            int header_i = 0;
            while (header_i < 4) {
                read = this.input.read(header, header_i, 4 - header_i);
                if (read == -1) {
                    throw new IOException("consume read eof");
                }
                if (read <= 0) continue;
                header_i += read;
            }
            int length = (header[0] & 0xFF) << 24 | (header[1] & 0xFF) << 16 | (header[2] & 0xFF) << 8 | header[3] & 0xFF;
            if (length < 0) {
                throw new IOException("negative length");
            }
            int total = length;
            if (buffer_in_data) {
                total += buffer_in.limit() - buffer_in.position();
            }
            buffer_out = ByteBuffer.allocate(total);
            if (buffer_in_data) {
                buffer_out.put(buffer_in);
            }
            int i = 0;
            while (i < length) {
                read = this.input.read(bytes, 0, Math.min(length - i, this.buffer_size));
                if (read == -1) {
                    throw new IOException("remaining read eof");
                }
                if (read <= 0) continue;
                i += read;
                buffer_out.put(bytes, 0, read);
            }
            buffer_out.rewind();
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream(this.buffer_size);
            int i = 0;
            if (buffer_in_data) {
                output.write(buffer_in.array(), buffer_in.position(), i += buffer_in.limit() - buffer_in.position());
            }
            while ((read = this.input.read(bytes)) == this.buffer_size && this.input.available() > 0) {
                i += this.buffer_size;
                output.write(bytes, 0, this.buffer_size);
            }
            if (read == -1) {
                throw new IOException("consume read eof");
            }
            if (read > 0) {
                i += read;
                output.write(bytes, 0, read);
            }
            buffer_out = ByteBuffer.wrap(output.toByteArray());
        }
        buffer_out.order(ByteOrder.nativeOrder());
        return buffer_out;
    }

    private static String getString(ByteBuffer buffer, int size) {
        String value = new String(API.getBytes(buffer, size - 1));
        buffer.position(buffer.position() + 1);
        return value;
    }

    private static OtpErlangPid getPid(ByteBuffer buffer, int size) {
        try {
            return new OtpInputStream(API.getBytes(buffer, size)).read_pid();
        }
        catch (OtpErlangDecodeException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    private static byte[] getBytes(ByteBuffer buffer, int size) {
        byte[] data = new byte[size];
        buffer.get(data, 0, size);
        return data;
    }

    private static FileDescriptor storeFD(int fd) {
        FileDescriptor object;
        Constructor c;
        Class<FileDescriptor> clazz = FileDescriptor.class;
        try {
            Class[] intarg = new Class[]{Integer.TYPE};
            c = clazz.getDeclaredConstructor(intarg);
        }
        catch (SecurityException e) {
            e.printStackTrace(err);
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace(err);
            return null;
        }
        c.setAccessible(true);
        try {
            object = (FileDescriptor)c.newInstance(fd);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(err);
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace(err);
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(err);
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace(err);
            return null;
        }
        return object;
    }

    public static class TerminateException
    extends Exception {
        private static final long serialVersionUID = 0L;
        private int timeout;

        TerminateException(int timeout) {
            super("Terminate");
            this.timeout = timeout;
        }

        public int timeout() {
            return this.timeout;
        }
    }

    public static class MessageDecodingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        MessageDecodingException() {
            super("Message Decoding Error");
        }
    }

    public static class ForwardAsyncException
    extends Exception {
        private static final long serialVersionUID = 3L;

        ForwardAsyncException() {
            super("Asynchronous Call Forward Invalid");
        }
    }

    public static class ForwardSyncException
    extends Exception {
        private static final long serialVersionUID = 3L;

        ForwardSyncException() {
            super("Synchronous Call Forward Invalid");
        }
    }

    public static class ReturnAsyncException
    extends Exception {
        private static final long serialVersionUID = 3L;

        ReturnAsyncException() {
            super("Asynchronous Call Return Invalid");
        }
    }

    public static class ReturnSyncException
    extends Exception {
        private static final long serialVersionUID = 3L;

        ReturnSyncException() {
            super("Synchronous Call Return Invalid");
        }
    }

    public static class InvalidInputException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidInputException() {
            super("Invalid Input");
        }
    }

    public static class TransId {
        public final byte[] id;

        public TransId(byte[] trans_id) {
            this.id = trans_id;
        }

        public boolean equals(byte[] bytes) {
            return Arrays.equals(this.id, bytes);
        }

        public boolean isTimeout() {
            return this.equals(TransIdNull);
        }

        public UUID toObject() {
            return new UUID((long)(this.id[0] & 0xFF) << 56 | (long)(this.id[1] & 0xFF) << 48 | (long)(this.id[2] & 0xFF) << 40 | (long)(this.id[3] & 0xFF) << 32 | (long)(this.id[4] & 0xFF) << 24 | (long)(this.id[5] & 0xFF) << 16 | (long)(this.id[6] & 0xFF) << 8 | (long)(this.id[7] & 0xFF), (long)(this.id[8] & 0xFF) << 56 | (long)(this.id[9] & 0xFF) << 48 | (long)(this.id[10] & 0xFF) << 40 | (long)(this.id[11] & 0xFF) << 32 | (long)(this.id[12] & 0xFF) << 24 | (long)(this.id[13] & 0xFF) << 16 | (long)(this.id[14] & 0xFF) << 8 | (long)(this.id[15] & 0xFF));
        }

        public Date toDate() {
            return new Date(this.toTimestampMicroSeconds() / 1000L);
        }

        public String toTimestamp() {
            return this.toTimestampString(false);
        }

        public String toTimestampSQL() {
            return this.toTimestampString(true);
        }

        public long toTimestampMicroSeconds() {
            return (((long)(this.id[6] & 0xF) << 56 | (long)(this.id[7] & 0xFF) << 48 | (long)(this.id[4] & 0xFF) << 40 | (long)(this.id[5] & 0xFF) << 32 | (long)(this.id[0] & 0xFF) << 24 | (long)(this.id[1] & 0xFF) << 16 | (long)(this.id[2] & 0xFF) << 8 | (long)(this.id[3] & 0xFF)) - 122192928000000000L) / 10L;
        }

        private String toTimestampString(boolean SQL) {
            long micro = this.toTimestampMicroSeconds();
            Date date = new Date(micro / 1000L);
            String str = new SimpleDateFormat("yyyy-MM-ddHH:mm:ss.SSS").format(date);
            StringBuilder ISO8601 = new StringBuilder();
            ISO8601.append(str.substring(0, 10));
            if (SQL) {
                ISO8601.append(" ");
            } else {
                ISO8601.append("T");
            }
            ISO8601.append(str.substring(10, 22));
            ISO8601.append(String.format("%03d", micro % 1000L));
            ISO8601.append("Z");
            return ISO8601.toString();
        }

        public String toString() {
            return this.toObject().toString().replace("-", "");
        }
    }

    public static class Response {
        public final byte[] response_info;
        public final byte[] response;
        public final byte[] id;

        Response(byte[] info, byte[] resp, byte[] trans_id) {
            this.response_info = info;
            this.response = resp;
            this.id = trans_id;
        }

        public boolean isEmpty() {
            return this.response.length == 0;
        }

        public boolean isTimeout() {
            return Arrays.equals(this.id, TransIdNull);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("('");
            result.append(new String(this.response_info));
            result.append("', '");
            result.append(new String(this.response));
            result.append("', '");
            result.append(new String(this.id));
            result.append("')");
            return result.toString();
        }
    }

    private static class NullResponse
    implements FunctionInterface9 {
        private NullResponse() {
        }

        @Override
        public Object invoke(Integer request_type, String name, String pattern, byte[] request_info, byte[] request, Integer timeout, Byte priority, byte[] trans_id, OtpErlangPid pid) {
            return "".getBytes();
        }
    }
}

