/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.AbstractNode;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangPort;
import com.ericsson.otp.erlang.OtpErlangRef;
import com.ericsson.otp.erlang.OtpTransport;
import com.ericsson.otp.erlang.OtpTransportFactory;

public class OtpLocalNode
extends AbstractNode {
    private int serial = 0;
    private int pidCount = 1;
    private int portCount = 1;
    private int[] refId;
    protected int port;
    protected OtpTransport epmd;

    protected OtpLocalNode(String node) {
        super(node);
        this.init();
    }

    protected OtpLocalNode(String node, OtpTransportFactory transportFactory) {
        super(node, transportFactory);
        this.init();
    }

    protected OtpLocalNode(String node, String cookie) {
        super(node, cookie);
        this.init();
    }

    protected OtpLocalNode(String node, String cookie, OtpTransportFactory transportFactory) {
        super(node, cookie, transportFactory);
        this.init();
    }

    private void init() {
        this.serial = 0;
        this.pidCount = 1;
        this.portCount = 1;
        this.refId = new int[3];
        this.refId[0] = 1;
        this.refId[1] = 0;
        this.refId[2] = 0;
    }

    public int port() {
        return this.port;
    }

    protected void setEpmd(OtpTransport s) {
        this.epmd = s;
    }

    protected OtpTransport getEpmd() {
        return this.epmd;
    }

    public synchronized OtpErlangPid createPid() {
        OtpErlangPid p = new OtpErlangPid(this.node, this.pidCount, this.serial, this.creation);
        ++this.pidCount;
        if (this.pidCount > Short.MAX_VALUE) {
            this.pidCount = 0;
            ++this.serial;
            if (this.serial > 8191) {
                this.serial = 0;
            }
        }
        return p;
    }

    public synchronized OtpErlangPort createPort() {
        OtpErlangPort p = new OtpErlangPort(this.node, this.portCount, this.creation);
        ++this.portCount;
        if (this.portCount > 0xFFFFFFF) {
            this.portCount = 0;
        }
        return p;
    }

    public synchronized OtpErlangRef createRef() {
        OtpErlangRef r = new OtpErlangRef(this.node, this.refId, this.creation);
        this.refId[0] = this.refId[0] + 1;
        if (this.refId[0] > 262143) {
            this.refId[0] = 0;
            this.refId[1] = this.refId[1] + 1;
            if (this.refId[1] == 0) {
                this.refId[2] = this.refId[2] + 1;
            }
        }
        return r;
    }
}

