/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.AbstractConnection;
import com.ericsson.otp.erlang.Link;
import com.ericsson.otp.erlang.Links;
import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpNode;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpTransport;
import java.io.IOException;

public class OtpCookedConnection
extends AbstractConnection {
    protected OtpNode self;
    protected Links links = null;

    OtpCookedConnection(OtpNode self, OtpTransport s) throws IOException, OtpAuthException {
        super((OtpLocalNode)self, s);
        this.self = self;
        this.links = new Links(25);
        this.start();
    }

    OtpCookedConnection(OtpNode self, OtpPeer other) throws IOException, OtpAuthException {
        super((OtpLocalNode)self, other);
        this.self = self;
        this.links = new Links(25);
        this.start();
    }

    @Override
    public void deliver(Exception e) {
        this.self.deliverError(this, e);
    }

    @Override
    public void deliver(OtpMsg msg) {
        boolean delivered = this.self.deliver(msg);
        switch (msg.type()) {
            case 1: {
                if (delivered) {
                    this.links.addLink(msg.getRecipientPid(), msg.getSenderPid());
                    break;
                }
                try {
                    super.sendExit(msg.getRecipientPid(), msg.getSenderPid(), new OtpErlangAtom("noproc"));
                }
                catch (IOException iOException) {}
                break;
            }
            case 3: 
            case 4: {
                this.links.removeLink(msg.getRecipientPid(), msg.getSenderPid());
                break;
            }
        }
    }

    void send(OtpErlangPid from, OtpErlangPid dest, OtpErlangObject msg) throws IOException {
        this.sendBuf(from, dest, new OtpOutputStream(msg));
    }

    void send(OtpErlangPid from, String dest, OtpErlangObject msg) throws IOException {
        this.sendBuf(from, dest, new OtpOutputStream(msg));
    }

    @Override
    public void close() {
        super.close();
        this.breakLinks();
    }

    @Override
    protected void finalize() {
        this.close();
    }

    void exit(OtpErlangPid from, OtpErlangPid to, OtpErlangObject reason) {
        try {
            super.sendExit(from, to, reason);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void exit2(OtpErlangPid from, OtpErlangPid to, OtpErlangObject reason) {
        try {
            super.sendExit2(from, to, reason);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void link(OtpErlangPid from, OtpErlangPid to) throws OtpErlangExit {
        try {
            super.sendLink(from, to);
            this.links.addLink(from, to);
        }
        catch (IOException e) {
            throw new OtpErlangExit("noproc", to);
        }
    }

    synchronized void unlink(OtpErlangPid from, OtpErlangPid to) {
        this.links.removeLink(from, to);
        try {
            super.sendUnlink(from, to);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void breakLinks() {
        Link[] l;
        if (this.links != null && (l = this.links.clearLinks()) != null) {
            int len = l.length;
            for (int i = 0; i < len; ++i) {
                this.self.deliver(new OtpMsg(3, l[i].remote(), l[i].local(), new OtpErlangAtom("noconnection")));
            }
        }
    }
}

