/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpOutputStream;

public class OtpErlangRef
extends OtpErlangObject {
    private static final long serialVersionUID = -7022666480768586521L;
    private final int tag;
    private final String node;
    private final int creation;
    private int[] ids = null;

    @Deprecated
    public OtpErlangRef(OtpLocalNode self) {
        OtpErlangRef r = self.createRef();
        this.tag = r.tag;
        this.ids = r.ids;
        this.creation = r.creation;
        this.node = r.node;
    }

    public OtpErlangRef(OtpInputStream buf) throws OtpErlangDecodeException {
        OtpErlangRef r = buf.read_ref();
        this.tag = r.tag;
        this.node = r.node();
        this.creation = r.creation();
        this.ids = r.ids();
    }

    public OtpErlangRef(String node, int id, int creation) {
        this.tag = 114;
        this.node = node;
        this.ids = new int[1];
        this.ids[0] = id & 0x3FFFF;
        this.creation = creation & 3;
    }

    public OtpErlangRef(String node, int[] ids, int creation) {
        this(114, node, ids, creation);
    }

    public OtpErlangRef(int tag, String node, int[] ids, int creation) {
        this.tag = tag;
        this.node = node;
        int len = ids.length;
        this.ids = new int[3];
        this.ids[0] = 0;
        this.ids[1] = 0;
        this.ids[2] = 0;
        if (len > 3) {
            len = 3;
        }
        System.arraycopy(ids, 0, this.ids, 0, len);
        if (tag == 114) {
            this.creation = creation & 3;
            this.ids[0] = this.ids[0] & 0x3FFFF;
        } else {
            this.creation = creation;
        }
    }

    protected int tag() {
        return this.tag;
    }

    public int id() {
        return this.ids[0];
    }

    public int[] ids() {
        return this.ids;
    }

    public boolean isNewRef() {
        return this.ids.length > 1;
    }

    public int creation() {
        return this.creation;
    }

    public String node() {
        return this.node;
    }

    @Override
    public String toString() {
        String s = "#Ref<" + this.node;
        for (int i = 0; i < this.ids.length; ++i) {
            s = s + "." + this.ids[i];
        }
        s = s + ">";
        return s;
    }

    @Override
    public void encode(OtpOutputStream buf) {
        buf.write_ref(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangRef)) {
            return false;
        }
        OtpErlangRef ref = (OtpErlangRef)o;
        if (!this.node.equals(ref.node()) || this.creation != ref.creation()) {
            return false;
        }
        if (this.isNewRef() && ref.isNewRef()) {
            return this.ids[0] == ref.ids[0] && this.ids[1] == ref.ids[1] && this.ids[2] == ref.ids[2];
        }
        return this.ids[0] == ref.ids[0];
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(7);
        hash.combine(this.creation, this.ids[0]);
        if (this.isNewRef()) {
            hash.combine(this.ids[1], this.ids[2]);
        }
        return hash.valueOf();
    }

    @Override
    public Object clone() {
        OtpErlangRef newRef = (OtpErlangRef)super.clone();
        newRef.ids = (int[])this.ids.clone();
        return newRef;
    }
}

