/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangException;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.UnsupportedEncodingException;

public class OtpErlangString
extends OtpErlangObject {
    private static final long serialVersionUID = -7053595217604929233L;
    private final String str;

    public OtpErlangString(String str) {
        this.str = str;
    }

    public OtpErlangString(OtpErlangList list) throws OtpErlangException {
        String s = list.stringValue();
        int n = s.length();
        int i = 0;
        while (i < n) {
            int cp = s.codePointAt(i);
            if (!OtpErlangString.isValidCodePoint(cp)) {
                throw new OtpErlangRangeException("Invalid CodePoint: " + cp);
            }
            i = s.offsetByCodePoints(i, 1);
        }
        this.str = s;
    }

    public OtpErlangString(OtpInputStream buf) throws OtpErlangDecodeException {
        this.str = buf.read_string();
    }

    public String stringValue() {
        return this.str;
    }

    @Override
    public String toString() {
        return "\"" + this.str + "\"";
    }

    @Override
    public void encode(OtpOutputStream buf) {
        buf.write_string(this.str);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.str.compareTo((String)o) == 0;
        }
        if (o instanceof OtpErlangString) {
            return this.str.compareTo(((OtpErlangString)o).str) == 0;
        }
        return false;
    }

    @Override
    protected int doHashCode() {
        return this.str.hashCode();
    }

    public static int[] stringToCodePoints(String s) {
        int codepoint;
        int m = s.codePointCount(0, s.length());
        int[] codePoints = new int[m];
        int j = 0;
        for (int offset = 0; offset < s.length(); offset += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(offset);
            codePoints[j++] = codepoint;
        }
        return codePoints;
    }

    public static boolean isValidCodePoint(int cp) {
        return cp >>> 16 <= 16 && (cp & 0xFFFFF800) != 55296;
    }

    public static String newString(byte[] bytes) {
        try {
            return new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(bytes);
        }
    }
}

