/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;

public class OtpErlangTuple
extends OtpErlangObject {
    private static final long serialVersionUID = 9163498658004915935L;
    private static final OtpErlangObject[] NO_ELEMENTS = new OtpErlangObject[0];
    private OtpErlangObject[] elems = NO_ELEMENTS;

    public OtpErlangTuple(OtpErlangObject elem) {
        if (elem == null) {
            throw new IllegalArgumentException("Tuple element cannot be null");
        }
        this.elems = new OtpErlangObject[]{elem};
    }

    public OtpErlangTuple(OtpErlangObject[] elems) {
        this(elems, 0, elems.length);
    }

    public OtpErlangTuple(OtpErlangObject[] elems, int start, int count) {
        if (elems == null) {
            throw new IllegalArgumentException("Tuple content can't be null");
        }
        if (count < 1) {
            this.elems = NO_ELEMENTS;
        } else {
            this.elems = new OtpErlangObject[count];
            for (int i = 0; i < count; ++i) {
                if (elems[start + i] == null) {
                    throw new IllegalArgumentException("Tuple element cannot be null (element" + (start + i) + ")");
                }
                this.elems[i] = elems[start + i];
            }
        }
    }

    public OtpErlangTuple(OtpInputStream buf) throws OtpErlangDecodeException {
        int arity = buf.read_tuple_head();
        if (arity > 0) {
            this.elems = new OtpErlangObject[arity];
            for (int i = 0; i < arity; ++i) {
                this.elems[i] = buf.read_any();
            }
        } else {
            this.elems = NO_ELEMENTS;
        }
    }

    public int arity() {
        return this.elems.length;
    }

    public OtpErlangObject elementAt(int i) {
        if (i >= this.arity() || i < 0) {
            return null;
        }
        return this.elems[i];
    }

    public OtpErlangObject[] elements() {
        OtpErlangObject[] res = new OtpErlangObject[this.arity()];
        System.arraycopy(this.elems, 0, res, 0, res.length);
        return res;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        int arity = this.elems.length;
        s.append("{");
        for (int i = 0; i < arity; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this.elems[i].toString());
        }
        s.append("}");
        return s.toString();
    }

    @Override
    public void encode(OtpOutputStream buf) {
        int arity = this.elems.length;
        buf.write_tuple_head(arity);
        for (int i = 0; i < arity; ++i) {
            buf.write_any(this.elems[i]);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangTuple)) {
            return false;
        }
        OtpErlangTuple t = (OtpErlangTuple)o;
        int a = this.arity();
        if (a != t.arity()) {
            return false;
        }
        for (int i = 0; i < a; ++i) {
            if (this.elems[i].equals(t.elems[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> boolean match(OtpErlangObject term, T bindings) {
        if (!(term instanceof OtpErlangTuple)) {
            return false;
        }
        OtpErlangTuple t = (OtpErlangTuple)term;
        int a = this.elems.length;
        if (a != t.elems.length) {
            return false;
        }
        for (int i = 0; i < a; ++i) {
            if (this.elems[i].match(t.elems[i], bindings)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> OtpErlangObject bind(T binds) throws OtpErlangException {
        OtpErlangTuple tuple = (OtpErlangTuple)this.clone();
        for (OtpErlangObject e : tuple.elems) {
            tuple.elems[i] = e.bind(binds);
        }
        return tuple;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(9);
        int a = this.arity();
        hash.combine(a);
        for (int i = 0; i < a; ++i) {
            hash.combine(this.elems[i].hashCode());
        }
        return hash.valueOf();
    }

    @Override
    public Object clone() {
        OtpErlangTuple newTuple = (OtpErlangTuple)super.clone();
        newTuple.elems = (OtpErlangObject[])this.elems.clone();
        return newTuple;
    }
}

