/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpEpmd;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpGenericTransportFactory;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMD5;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpTransport;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;

public abstract class AbstractConnection
extends Thread {
    protected static final int headerLen = 2048;
    protected static final byte passThrough = 112;
    protected static final byte version = -125;
    protected static final int linkTag = 1;
    protected static final int sendTag = 2;
    protected static final int exitTag = 3;
    protected static final int unlinkTag = 4;
    protected static final int regSendTag = 6;
    protected static final int groupLeaderTag = 7;
    protected static final int exit2Tag = 8;
    protected static final int sendTTTag = 12;
    protected static final int exitTTTag = 13;
    protected static final int regSendTTTag = 16;
    protected static final int exit2TTTag = 18;
    protected static final int unlinkIdTag = 35;
    protected static final int unlinkIdAckTag = 36;
    protected static final int ChallengeReply = 114;
    protected static final int ChallengeAck = 97;
    protected static final int ChallengeStatus = 115;
    private volatile boolean done = false;
    protected boolean connected = false;
    protected OtpTransport socket;
    protected OtpPeer peer;
    protected OtpLocalNode localNode;
    String name;
    protected boolean cookieOk = false;
    protected boolean sendCookie = true;
    protected int traceLevel = 0;
    protected static int defaultLevel = 0;
    protected static int sendThreshold = 1;
    protected static int ctrlThreshold = 2;
    protected static int handshakeThreshold = 3;
    protected static Random random = null;
    private int flags = 0;

    protected AbstractConnection(OtpLocalNode self, OtpTransport s) throws IOException, OtpAuthException {
        this.localNode = self;
        this.peer = new OtpPeer(self.transportFactory);
        this.socket = s;
        this.traceLevel = defaultLevel;
        this.setDaemon(true);
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- ACCEPT FROM " + s);
        }
        this.doAccept();
        this.name = this.peer.node();
    }

    protected AbstractConnection(OtpLocalNode self, OtpPeer other) throws IOException, OtpAuthException {
        this.peer = other;
        this.localNode = self;
        this.traceLevel = defaultLevel;
        this.setDaemon(true);
        if (this.peer.proto != self.proto || self.distHigh < this.peer.distLow || self.distLow > this.peer.distHigh) {
            throw new IOException("No common protocol found - cannot connect");
        }
        int n = this.peer.distChoose = this.peer.distHigh > self.distHigh ? self.distHigh : this.peer.distHigh;
        if (self.transportFactory instanceof OtpGenericTransportFactory) {
            this.doGenericConnect();
        } else {
            int port = OtpEpmd.lookupPort(this.peer);
            if (port == 0) {
                throw new IOException("No remote node found - cannot connect");
            }
            this.doPortConnect(port);
        }
        this.name = this.peer.node();
        this.connected = true;
    }

    public abstract void deliver(Exception var1);

    public abstract void deliver(OtpMsg var1);

    protected void sendBuf(OtpErlangPid from, String dest, OtpOutputStream payload) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(4);
        header.write_long(6L);
        header.write_any(from);
        if (this.sendCookie) {
            header.write_atom(this.localNode.cookie());
        } else {
            header.write_atom("");
        }
        header.write_atom(dest);
        header.write1(-125L);
        header.poke4BE(0, header.size() + payload.size() - 4);
        this.do_send(header, payload);
    }

    protected void sendBuf(OtpErlangPid from, OtpErlangPid dest, OtpOutputStream payload) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(3);
        header.write_long(2L);
        if (this.sendCookie) {
            header.write_atom(this.localNode.cookie());
        } else {
            header.write_atom("");
        }
        header.write_any(dest);
        header.write1(-125L);
        header.poke4BE(0, header.size() + payload.size() - 4);
        this.do_send(header, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cookieError(OtpLocalNode local, OtpErlangAtom cookie) throws OtpAuthException {
        try {
            OtpOutputStream header = new OtpOutputStream(2048);
            header.write4BE(0L);
            header.write1(112L);
            header.write1(-125L);
            header.write_tuple_head(4);
            header.write_long(6L);
            header.write_any(local.createPid());
            header.write_atom(cookie.atomValue());
            header.write_atom("auth");
            header.write1(-125L);
            OtpErlangObject[] msg = new OtpErlangObject[2];
            OtpErlangObject[] msgbody = new OtpErlangObject[]{new OtpErlangAtom("print"), new OtpErlangString("~n** Bad cookie sent to " + local + " **~n"), new OtpErlangList()};
            msg[0] = new OtpErlangAtom("$gen_cast");
            msg[1] = new OtpErlangTuple(msgbody);
            OtpOutputStream payload = new OtpOutputStream(new OtpErlangTuple(msg));
            header.poke4BE(0, header.size() + payload.size() - 4);
            try {
                this.do_send(header, payload);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.close();
        }
        throw new OtpAuthException("Remote cookie not authorized: " + cookie.atomValue());
    }

    protected void sendLink(OtpErlangPid from, OtpErlangPid dest) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(3);
        header.write_long(1L);
        header.write_any(from);
        header.write_any(dest);
        header.poke4BE(0, header.size() - 4);
        this.do_send(header);
    }

    protected void sendUnlink(OtpErlangPid from, OtpErlangPid dest, long unlink_id) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(4);
        header.write_long(35L);
        header.write_long(unlink_id);
        header.write_any(from);
        header.write_any(dest);
        header.poke4BE(0, header.size() - 4);
        this.do_send(header);
    }

    protected void sendUnlinkAck(OtpErlangPid from, OtpErlangPid dest, long unlink_id) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(4);
        header.write_long(36L);
        header.write_long(unlink_id);
        header.write_any(from);
        header.write_any(dest);
        header.poke4BE(0, header.size() - 4);
        this.do_send(header);
    }

    protected void sendExit(OtpErlangPid from, OtpErlangPid dest, OtpErlangObject reason) throws IOException {
        this.sendExit(3, from, dest, reason);
    }

    protected void sendExit2(OtpErlangPid from, OtpErlangPid dest, OtpErlangObject reason) throws IOException {
        this.sendExit(8, from, dest, reason);
    }

    private void sendExit(int tag, OtpErlangPid from, OtpErlangPid dest, OtpErlangObject reason) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream header = new OtpOutputStream(2048);
        header.write4BE(0L);
        header.write1(112L);
        header.write1(-125L);
        header.write_tuple_head(4);
        header.write_long(tag);
        header.write_any(from);
        header.write_any(dest);
        header.write_any(reason);
        header.poke4BE(0, header.size() - 4);
        this.do_send(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (!this.connected) {
            this.deliver(new IOException("Not connected"));
            return;
        }
        byte[] lbuf = new byte[4];
        byte[] tock = new byte[]{0, 0, 0, 0};
        try {
            block20: while (!this.done) {
                OtpInputStream ibuf;
                int len;
                do {
                    this.readSock(this.socket, lbuf);
                    ibuf = new OtpInputStream(lbuf, this.flags);
                    len = ibuf.read4BE();
                    if (len != 0) continue;
                    AbstractConnection abstractConnection = this;
                    synchronized (abstractConnection) {
                        if (this.socket == null) {
                            throw new IOException("socket was closed");
                        }
                        OutputStream out = this.socket.getOutputStream();
                        out.write(tock);
                        out.flush();
                    }
                } while (len == 0);
                byte[] tmpbuf = new byte[len];
                this.readSock(this.socket, tmpbuf);
                ibuf.close();
                ibuf = new OtpInputStream(tmpbuf, this.flags);
                if (ibuf.read1() != 112) break;
                OtpErlangObject reason = null;
                OtpErlangAtom cookie = null;
                OtpErlangObject tmp = null;
                OtpErlangTuple head = null;
                tmp = ibuf.read_any();
                if (!(tmp instanceof OtpErlangTuple) || !((head = (OtpErlangTuple)tmp).elementAt(0) instanceof OtpErlangLong)) break;
                int tag = (int)((OtpErlangLong)head.elementAt(0)).longValue();
                switch (tag) {
                    case 2: 
                    case 12: {
                        OtpErlangObject traceobj;
                        if (!this.cookieOk) {
                            if (!(head.elementAt(1) instanceof OtpErlangAtom)) break block20;
                            cookie = (OtpErlangAtom)head.elementAt(1);
                            if (this.sendCookie) {
                                if (!cookie.atomValue().equals(this.localNode.cookie())) {
                                    this.cookieError(this.localNode, cookie);
                                }
                            } else if (!cookie.atomValue().equals("")) {
                                this.cookieError(this.localNode, cookie);
                            }
                            this.cookieOk = true;
                        }
                        if (this.traceLevel >= sendThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                            ibuf.mark(0);
                            traceobj = ibuf.read_any();
                            if (traceobj != null) {
                                System.out.println("   " + traceobj);
                            } else {
                                System.out.println("   (null)");
                            }
                            ibuf.reset();
                        }
                        OtpErlangPid to = (OtpErlangPid)head.elementAt(2);
                        this.deliver(new OtpMsg(to, ibuf));
                        continue block20;
                    }
                    case 6: 
                    case 16: {
                        OtpErlangObject traceobj;
                        if (!this.cookieOk) {
                            if (!(head.elementAt(2) instanceof OtpErlangAtom)) break block20;
                            cookie = (OtpErlangAtom)head.elementAt(2);
                            if (this.sendCookie) {
                                if (!cookie.atomValue().equals(this.localNode.cookie())) {
                                    this.cookieError(this.localNode, cookie);
                                }
                            } else if (!cookie.atomValue().equals("")) {
                                this.cookieError(this.localNode, cookie);
                            }
                            this.cookieOk = true;
                        }
                        if (this.traceLevel >= sendThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                            ibuf.mark(0);
                            traceobj = ibuf.read_any();
                            if (traceobj != null) {
                                System.out.println("   " + traceobj);
                            } else {
                                System.out.println("   (null)");
                            }
                            ibuf.reset();
                        }
                        OtpErlangPid from = (OtpErlangPid)head.elementAt(1);
                        OtpErlangAtom toName = (OtpErlangAtom)head.elementAt(3);
                        this.deliver(new OtpMsg(from, toName.atomValue(), ibuf));
                        continue block20;
                    }
                    case 3: 
                    case 8: {
                        if (head.elementAt(3) == null) break block20;
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                        }
                        OtpErlangPid from = (OtpErlangPid)head.elementAt(1);
                        OtpErlangPid to = (OtpErlangPid)head.elementAt(2);
                        reason = head.elementAt(3);
                        this.deliver(new OtpMsg(tag, from, to, reason));
                        continue block20;
                    }
                    case 13: 
                    case 18: {
                        if (head.elementAt(4) == null) break block20;
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                        }
                        OtpErlangPid from = (OtpErlangPid)head.elementAt(1);
                        OtpErlangPid to = (OtpErlangPid)head.elementAt(2);
                        reason = head.elementAt(4);
                        this.deliver(new OtpMsg(tag, from, to, reason));
                        continue block20;
                    }
                    case 1: 
                    case 4: {
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                        }
                        OtpErlangPid from = (OtpErlangPid)head.elementAt(1);
                        OtpErlangPid to = (OtpErlangPid)head.elementAt(2);
                        this.deliver(new OtpMsg(tag, from, to, 0L));
                        continue block20;
                    }
                    case 35: 
                    case 36: {
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(head) + " " + head);
                        }
                        long unlink_id = ((OtpErlangLong)head.elementAt(1)).longValue();
                        OtpErlangPid from = (OtpErlangPid)head.elementAt(2);
                        OtpErlangPid to = (OtpErlangPid)head.elementAt(3);
                        this.deliver(new OtpMsg(tag, from, to, unlink_id));
                        continue block20;
                    }
                    case 7: {
                        if (this.traceLevel < ctrlThreshold) continue block20;
                        System.out.println("<- " + this.headerType(head) + " " + head);
                        continue block20;
                    }
                }
            }
            this.deliver(new OtpErlangExit("Remote is sending garbage"));
            return;
        }
        catch (OtpAuthException e) {
            this.deliver(e);
            return;
        }
        catch (OtpErlangDecodeException e) {
            this.deliver(new OtpErlangExit("Remote is sending garbage"));
            return;
        }
        catch (IOException e) {
            this.deliver(new OtpErlangExit("Remote has closed connection"));
            return;
        }
        finally {
            this.close();
        }
    }

    public int setTraceLevel(int level) {
        int oldLevel = this.traceLevel;
        int theLevel = level;
        if (level < 0) {
            theLevel = 0;
        } else if (level > 4) {
            theLevel = 4;
        }
        this.traceLevel = theLevel;
        return oldLevel;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.done = true;
        this.connected = false;
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            try {
                if (this.socket != null) {
                    if (this.traceLevel >= ctrlThreshold) {
                        System.out.println("-> CLOSE");
                    }
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected synchronized void do_send(OtpOutputStream header, OtpOutputStream payload) throws IOException {
        try {
            if (this.traceLevel >= sendThreshold) {
                try {
                    OtpErlangObject h = header.getOtpInputStream(5).read_any();
                    System.out.println("-> " + this.headerType(h) + " " + h);
                    OtpErlangObject o = payload.getOtpInputStream(0).read_any();
                    System.out.println("   " + o);
                    o = null;
                }
                catch (OtpErlangDecodeException e) {
                    System.out.println("   can't decode output buffer:" + e);
                }
            }
            OutputStream out = this.socket.getOutputStream();
            header.writeTo(out);
            payload.writeTo(out);
            out.flush();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    protected synchronized void do_send(OtpOutputStream header) throws IOException {
        try {
            if (this.traceLevel >= ctrlThreshold) {
                try {
                    OtpErlangObject h = header.getOtpInputStream(5).read_any();
                    System.out.println("-> " + this.headerType(h) + " " + h);
                }
                catch (OtpErlangDecodeException e) {
                    System.out.println("   can't decode output buffer: " + e);
                }
            }
            header.writeToAndFlush(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    protected String headerType(OtpErlangObject h) {
        int tag = -1;
        if (h instanceof OtpErlangTuple) {
            tag = (int)((OtpErlangLong)((OtpErlangTuple)h).elementAt(0)).longValue();
        }
        switch (tag) {
            case 1: {
                return "LINK";
            }
            case 2: {
                return "SEND";
            }
            case 3: {
                return "EXIT";
            }
            case 4: {
                return "UNLINK";
            }
            case 35: {
                return "UNLINK_ID";
            }
            case 36: {
                return "UNLINK_ID_ACK";
            }
            case 6: {
                return "REG_SEND";
            }
            case 7: {
                return "GROUP_LEADER";
            }
            case 8: {
                return "EXIT2";
            }
            case 12: {
                return "SEND_TT";
            }
            case 13: {
                return "EXIT_TT";
            }
            case 16: {
                return "REG_SEND_TT";
            }
            case 18: {
                return "EXIT2_TT";
            }
        }
        return "(unknown type)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readSock(OtpTransport s, byte[] b) throws IOException {
        int got;
        int i;
        int len = b.length;
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            if (s == null) {
                throw new IOException("expected " + len + " bytes, socket was closed");
            }
        }
        for (got = 0; got < len; got += i) {
            i = s.getInputStream().read(b, got, len - got);
            if (i < 0) {
                throw new IOException("expected " + len + " bytes, got EOF after " + got + " bytes");
            }
            if (i != 0 || len == 0) continue;
            throw new IOException("Remote connection closed");
        }
        return got;
    }

    protected void doAccept() throws IOException, OtpAuthException {
        int send_name_tag = this.recvName(this.peer);
        try {
            this.sendStatus("ok");
            int our_challenge = AbstractConnection.genChallenge();
            this.sendChallenge(this.peer.flags, this.localNode.flags, our_challenge);
            this.recvComplement(send_name_tag);
            int her_challenge = this.recvChallengeReply(our_challenge);
            byte[] our_digest = this.genDigest(her_challenge, this.localNode.cookie());
            this.sendChallengeAck(our_digest);
            this.connected = true;
            this.cookieOk = true;
            this.sendCookie = false;
        }
        catch (IOException ie) {
            this.close();
            throw ie;
        }
        catch (OtpAuthException ae) {
            this.close();
            throw ae;
        }
        catch (Exception e) {
            String nn = this.peer.node();
            this.close();
            IOException ioe = new IOException("Error accepting connection from " + nn);
            ioe.initCause(e);
            throw ioe;
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- MD5 ACCEPTED " + this.peer.host());
        }
    }

    protected void doPortConnect(int port) throws IOException, OtpAuthException {
        try {
            this.socket = this.peer.createTransport(this.peer.host(), port);
            if (this.traceLevel >= handshakeThreshold) {
                System.out.println("-> MD5 CONNECT TO " + this.peer.host() + ":" + port);
            }
            this.doConnect();
        }
        catch (OtpAuthException ae) {
            this.close();
            throw ae;
        }
        catch (Exception e) {
            this.close();
            IOException ioe = new IOException("Cannot connect to peer node");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected void doConnect() throws IOException, OtpAuthException {
        int send_name_tag = this.sendName(this.peer.distChoose, this.localNode.flags, this.localNode.creation());
        this.recvStatus();
        int her_challenge = this.recvChallenge();
        byte[] our_digest = this.genDigest(her_challenge, this.localNode.cookie());
        int our_challenge = AbstractConnection.genChallenge();
        this.sendChallengeReply(our_challenge, our_digest);
        this.recvChallengeAck(our_challenge);
        this.cookieOk = true;
        this.sendCookie = false;
    }

    protected void doGenericConnect() throws IOException, OtpAuthException {
        try {
            this.socket = this.peer.createTransport(this.peer);
            if (this.traceLevel >= handshakeThreshold) {
                System.out.println("-> MD5 CONNECT TO " + this.peer.node());
            }
            this.doConnect();
        }
        catch (OtpAuthException ae) {
            this.close();
            throw ae;
        }
        catch (Exception e) {
            this.close();
            IOException ioe = new IOException("Cannot connect to peer node");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected static int genChallenge() {
        return random.nextInt();
    }

    static String hex0(byte x) {
        int uint;
        char[] tab = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (x < 0) {
            uint = x & 0x7F;
            uint |= 0x80;
        } else {
            uint = x;
        }
        return "" + tab[uint >>> 4] + tab[uint & 0xF];
    }

    static String hex(byte[] b) {
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < b.length; ++i) {
                sb.append(AbstractConnection.hex0(b[i]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    protected byte[] genDigest(int challenge, String cookie) {
        long ch2;
        if (challenge < 0) {
            ch2 = 0x80000000L;
            ch2 |= (long)(challenge & Integer.MAX_VALUE);
        } else {
            ch2 = challenge;
        }
        OtpMD5 context = new OtpMD5();
        context.update(cookie);
        context.update("" + ch2);
        int[] tmp = context.final_bytes();
        byte[] res = new byte[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            res[i] = (byte)(tmp[i] & 0xFF);
        }
        return res;
    }

    protected int sendName(int dist, long aflags, int creation) throws IOException {
        OtpOutputStream obuf = new OtpOutputStream();
        String str = this.localNode.node();
        obuf.write2BE(15 + str.length());
        int send_name_tag = 78;
        obuf.write1(send_name_tag);
        obuf.write8BE(aflags);
        obuf.write4BE(creation);
        obuf.write2BE(str.length());
        obuf.write(str.getBytes());
        obuf.writeToAndFlush(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendName flags=" + aflags + " local=" + this.localNode);
        }
        return send_name_tag;
    }

    protected void sendChallenge(long her_flags, long our_flags, int challenge) throws IOException {
        OtpOutputStream obuf = new OtpOutputStream();
        String str = this.localNode.node();
        obuf.write2BE(19 + str.length());
        obuf.write1(78L);
        obuf.write8BE(our_flags);
        obuf.write4BE(challenge);
        obuf.write4BE(this.localNode.creation());
        obuf.write2BE(str.length());
        obuf.write(str.getBytes());
        obuf.writeToAndFlush(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendChallenge flags=" + our_flags + " challenge=" + challenge + " local=" + this.localNode);
        }
    }

    protected byte[] read2BytePackage() throws IOException, OtpErlangDecodeException {
        byte[] lbuf = new byte[2];
        this.readSock(this.socket, lbuf);
        OtpInputStream ibuf = new OtpInputStream(lbuf, 0);
        int len = ibuf.read2BE();
        byte[] tmpbuf = new byte[len];
        this.readSock(this.socket, tmpbuf);
        return tmpbuf;
    }

    protected int recvName(OtpPeer apeer) throws IOException {
        int send_name_tag;
        String hisname = "";
        try {
            long flag_mask;
            byte[] tmpbuf = this.read2BytePackage();
            OtpInputStream ibuf = new OtpInputStream(tmpbuf, 0);
            int len = tmpbuf.length;
            send_name_tag = ibuf.read1();
            switch (send_name_tag) {
                case 110: {
                    if (ibuf.read2BE() != 5) {
                        throw new IOException("Invalid handshake version");
                    }
                    apeer.flags = ibuf.read4BE();
                    flag_mask = 0xFFFFFFFFL;
                    if ((apeer.flags & 0x1000000L) == 0L) {
                        throw new IOException("Missing DFLAG_HANDSHAKE_23");
                    }
                    apeer.distHigh = 6;
                    apeer.distLow = 6;
                    byte[] tmpname = new byte[len - 7];
                    ibuf.readN(tmpname);
                    hisname = OtpErlangString.newString(tmpname);
                    break;
                }
                case 78: {
                    apeer.distHigh = 6;
                    apeer.distLow = 6;
                    apeer.flags = ibuf.read8BE();
                    flag_mask = -1L;
                    if ((apeer.flags & 0x4000000L) != 0L) {
                        apeer.flags |= 0x1070F94L;
                    }
                    if ((apeer.flags & 0x1000000L) == 0L) {
                        throw new IOException("Missing DFLAG_HANDSHAKE_23");
                    }
                    apeer.setCreation(ibuf.read4BE());
                    int namelen = ibuf.read2BE();
                    byte[] tmpname = new byte[namelen];
                    ibuf.readN(tmpname);
                    hisname = OtpErlangString.newString(tmpname);
                    break;
                }
                default: {
                    throw new IOException("Unknown remote node type");
                }
            }
            if (((apeer.flags ^ 0xFFFFFFFFFFFFFFFFL) & flag_mask & 0x403070F94L) != 0L) {
                throw new IOException("Handshake failed - peer cannot handle all mandatory capabilities");
            }
        }
        catch (OtpErlangDecodeException e) {
            throw new IOException("Handshake failed - not enough data");
        }
        int i = hisname.indexOf(64);
        apeer.node = hisname;
        apeer.alive = hisname.substring(0, i);
        apeer.host = hisname.substring(i + 1, hisname.length());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE ntype=" + apeer.ntype + " dist=" + apeer.distHigh + " remote=" + apeer);
        }
        return send_name_tag;
    }

    protected int recvChallenge() throws IOException {
        int challenge;
        try {
            int namelen;
            byte[] buf = this.read2BytePackage();
            OtpInputStream ibuf = new OtpInputStream(buf, 0);
            switch (ibuf.read1()) {
                case 78: {
                    this.peer.distChoose = 6;
                    this.peer.distHigh = 6;
                    this.peer.distLow = 6;
                    this.peer.flags = ibuf.read8BE();
                    if ((this.peer.flags & 0x4000000L) != 0L) {
                        this.peer.flags |= 0x1070F94L;
                    }
                    if ((this.peer.flags & 0x1000000L) == 0L) {
                        throw new IOException("New challenge missing DFLAG_HANDHAKE_23");
                    }
                    challenge = ibuf.read4BE();
                    this.peer.setCreation(ibuf.read4BE());
                    namelen = ibuf.read2BE();
                    break;
                }
                default: {
                    throw new IOException("Unexpected peer type");
                }
            }
            byte[] tmpname = new byte[namelen];
            ibuf.readN(tmpname);
            String hisname = OtpErlangString.newString(tmpname);
            if (!hisname.equals(this.peer.node)) {
                throw new IOException("Handshake failed - peer has wrong name: " + hisname);
            }
            if ((this.peer.flags & 0x403070F94L) != 17230663572L) {
                throw new IOException("Handshake failed - peer cannot handle all mandatory capabilities");
            }
        }
        catch (OtpErlangDecodeException e) {
            throw new IOException("Handshake failed - not enough data");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvChallenge from=" + this.peer.node + " challenge=" + challenge + " local=" + this.localNode);
        }
        return challenge;
    }

    protected void recvComplement(int send_name_tag) throws IOException {
        if (send_name_tag == 110) {
            try {
                byte[] tmpbuf = this.read2BytePackage();
                OtpInputStream ibuf = new OtpInputStream(tmpbuf, 0);
                if (ibuf.read1() != 99) {
                    throw new IOException("Not a complement tag");
                }
                long flagsHigh = ibuf.read4BE();
                this.peer.flags |= flagsHigh << 32;
                if (((this.peer.flags ^ 0xFFFFFFFFFFFFFFFFL) & 0x403070F94L) != 0L) {
                    throw new IOException("Handshake failed - peer missing mandatory capabilities");
                }
                this.peer.setCreation(ibuf.read4BE());
            }
            catch (OtpErlangDecodeException e) {
                throw new IOException("Handshake failed - not enough data");
            }
        }
    }

    protected void sendChallengeReply(int challenge, byte[] digest) throws IOException {
        OtpOutputStream obuf = new OtpOutputStream();
        obuf.write2BE(21L);
        obuf.write1(114L);
        obuf.write4BE(challenge);
        obuf.write(digest);
        obuf.writeToAndFlush(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendChallengeReply challenge=" + challenge + " digest=" + AbstractConnection.hex(digest) + " local=" + this.localNode);
        }
    }

    private boolean digests_equals(byte[] a, byte[] b) {
        for (int i = 0; i < 16; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected int recvChallengeReply(int our_challenge) throws IOException, OtpAuthException {
        int challenge;
        byte[] her_digest = new byte[16];
        try {
            byte[] buf = this.read2BytePackage();
            OtpInputStream ibuf = new OtpInputStream(buf, 0);
            int tag = ibuf.read1();
            if (tag != 114) {
                throw new IOException("Handshake protocol error");
            }
            challenge = ibuf.read4BE();
            ibuf.readN(her_digest);
            byte[] our_digest = this.genDigest(our_challenge, this.localNode.cookie());
            if (!this.digests_equals(her_digest, our_digest)) {
                throw new OtpAuthException("Peer authentication error.");
            }
        }
        catch (OtpErlangDecodeException e) {
            throw new IOException("Handshake failed - not enough data");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvChallengeReply from=" + this.peer.node + " challenge=" + challenge + " digest=" + AbstractConnection.hex(her_digest) + " local=" + this.localNode);
        }
        return challenge;
    }

    protected void sendChallengeAck(byte[] digest) throws IOException {
        OtpOutputStream obuf = new OtpOutputStream();
        obuf.write2BE(17L);
        obuf.write1(97L);
        obuf.write(digest);
        obuf.writeToAndFlush(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendChallengeAck digest=" + AbstractConnection.hex(digest) + " local=" + this.localNode);
        }
    }

    protected void recvChallengeAck(int our_challenge) throws IOException, OtpAuthException {
        byte[] her_digest = new byte[16];
        try {
            byte[] buf = this.read2BytePackage();
            OtpInputStream ibuf = new OtpInputStream(buf, 0);
            int tag = ibuf.read1();
            if (tag != 97) {
                throw new IOException("Handshake protocol error");
            }
            ibuf.readN(her_digest);
            byte[] our_digest = this.genDigest(our_challenge, this.localNode.cookie());
            if (!this.digests_equals(her_digest, our_digest)) {
                throw new OtpAuthException("Peer authentication error.");
            }
        }
        catch (OtpErlangDecodeException e) {
            throw new IOException("Handshake failed - not enough data");
        }
        catch (Exception e) {
            throw new OtpAuthException("Peer authentication error.");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvChallengeAck from=" + this.peer.node + " digest=" + AbstractConnection.hex(her_digest) + " local=" + this.localNode);
        }
    }

    protected void sendStatus(String status) throws IOException {
        OtpOutputStream obuf = new OtpOutputStream();
        obuf.write2BE(status.length() + 1);
        obuf.write1(115L);
        obuf.write(status.getBytes());
        obuf.writeToAndFlush(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendStatus status=" + status + " local=" + this.localNode);
        }
    }

    protected void recvStatus() throws IOException {
        try {
            byte[] buf = this.read2BytePackage();
            OtpInputStream ibuf = new OtpInputStream(buf, 0);
            int tag = ibuf.read1();
            if (tag != 115) {
                throw new IOException("Handshake protocol error");
            }
            byte[] tmpbuf = new byte[buf.length - 1];
            ibuf.readN(tmpbuf);
            String status = OtpErlangString.newString(tmpbuf);
            if (status.compareTo("ok") != 0) {
                throw new IOException("Peer replied with status '" + status + "' instead of 'ok'");
            }
        }
        catch (OtpErlangDecodeException e) {
            throw new IOException("Handshake failed - not enough data");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvStatus (ok) local=" + this.localNode);
        }
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    static {
        String trace = System.getProperties().getProperty("OtpConnection.trace");
        try {
            if (trace != null) {
                defaultLevel = Integer.valueOf(trace);
            }
        }
        catch (NumberFormatException e) {
            defaultLevel = 0;
        }
        random = new Random();
    }
}

