/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.AbstractNode;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpSocketTransportFactory;
import com.ericsson.otp.erlang.OtpTransport;
import com.ericsson.otp.erlang.OtpTransportFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class OtpEpmd {
    private static final byte stopReq = 115;
    private static final byte port4req = 122;
    private static final byte port4resp = 119;
    private static final byte ALIVE2_REQ = 120;
    private static final byte ALIVE2_RESP = 121;
    private static final byte ALIVE2_X_RESP = 118;
    private static final byte names4req = 110;
    private static int traceLevel = 0;
    private static final int traceThreshold = 4;

    private OtpEpmd() {
    }

    public static void useEpmdPort(int port) {
        EpmdPort.set(port);
    }

    public static int lookupPort(AbstractNode node) throws IOException {
        return OtpEpmd.r4_lookupPort(node);
    }

    public static boolean publishPort(OtpLocalNode node) throws IOException {
        OtpTransport s = null;
        s = OtpEpmd.r4_publish(node);
        node.setEpmd(s);
        return s != null;
    }

    public static void unPublishPort(OtpLocalNode node) {
        OtpTransport s = null;
        try {
            s = node.createTransport((String)null, EpmdPort.get());
            OtpOutputStream obuf = new OtpOutputStream();
            obuf.write2BE(node.alive().length() + 1);
            obuf.write1(115L);
            obuf.writeN(node.alive().getBytes());
            obuf.writeToAndFlush(s.getOutputStream());
            if (traceLevel >= 4) {
                System.out.println("-> UNPUBLISH " + node + " port=" + node.port());
                System.out.println("<- OK (assumed)");
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException iOException) {}
            s = null;
        }
    }

    private static int r4_lookupPort(AbstractNode node) throws IOException {
        int port = 0;
        OtpTransport s = null;
        try {
            int result;
            OtpOutputStream obuf = new OtpOutputStream();
            s = node.createTransport(node.host(), EpmdPort.get());
            obuf.write2BE(node.alive().length() + 1);
            obuf.write1(122L);
            obuf.writeN(node.alive().getBytes());
            obuf.writeToAndFlush(s.getOutputStream());
            if (traceLevel >= 4) {
                System.out.println("-> LOOKUP (r4) " + node);
            }
            byte[] tmpbuf = new byte[100];
            int n = s.getInputStream().read(tmpbuf);
            if (n < 0) {
                s.close();
                throw new IOException("Nameserver not responding on " + node.host() + " when looking up " + node.alive());
            }
            OtpInputStream ibuf = new OtpInputStream(tmpbuf, 0);
            int response = ibuf.read1();
            if (response == 119 && (result = ibuf.read1()) == 0) {
                port = ibuf.read2BE();
                node.ntype = ibuf.read1();
                node.proto = ibuf.read1();
                node.distHigh = ibuf.read2BE();
                node.distLow = ibuf.read2BE();
            }
        }
        catch (IOException e) {
            if (traceLevel >= 4) {
                System.out.println("<- (no response)");
            }
            throw new IOException("Nameserver not responding on " + node.host() + " when looking up " + node.alive(), e);
        }
        catch (OtpErlangDecodeException e) {
            if (traceLevel >= 4) {
                System.out.println("<- (invalid response)");
            }
            throw new IOException("Nameserver not responding on " + node.host() + " when looking up " + node.alive());
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException iOException) {}
            s = null;
        }
        if (traceLevel >= 4) {
            if (port == 0) {
                System.out.println("<- NOT FOUND");
            } else {
                System.out.println("<- PORT " + port);
            }
        }
        return port;
    }

    private static OtpTransport r4_publish(OtpLocalNode node) throws IOException {
        OtpTransport s = null;
        try {
            int result;
            OtpOutputStream obuf = new OtpOutputStream();
            s = node.createTransport((String)null, EpmdPort.get());
            obuf.write2BE(node.alive().length() + 13);
            obuf.write1(120L);
            obuf.write2BE(node.port());
            obuf.write1(node.type());
            obuf.write1(node.proto());
            obuf.write2BE(node.distHigh());
            obuf.write2BE(node.distLow());
            obuf.write2BE(node.alive().length());
            obuf.writeN(node.alive().getBytes());
            obuf.write2BE(0L);
            obuf.writeToAndFlush(s.getOutputStream());
            if (traceLevel >= 4) {
                System.out.println("-> PUBLISH (r4) " + node + " port=" + node.port());
            }
            byte[] tmpbuf = new byte[100];
            int n = s.getInputStream().read(tmpbuf);
            if (n < 0) {
                s.close();
                throw new IOException("Nameserver not responding on " + node.host() + " when publishing " + node.alive());
            }
            OtpInputStream ibuf = new OtpInputStream(tmpbuf, 0);
            int response = ibuf.read1();
            if ((response == 121 || response == 118) && (result = ibuf.read1()) == 0) {
                node.setCreation(response == 121 ? ibuf.read2BE() : ibuf.read4BE());
                if (traceLevel >= 4) {
                    System.out.println("<- OK");
                }
                return s;
            }
        }
        catch (IOException e) {
            if (s != null) {
                s.close();
            }
            if (traceLevel >= 4) {
                System.out.println("<- (no response)");
            }
            throw new IOException("Nameserver not responding on " + node.host() + " when publishing " + node.alive());
        }
        catch (OtpErlangDecodeException e) {
            s.close();
            if (traceLevel >= 4) {
                System.out.println("<- (invalid response)");
            }
            throw new IOException("Nameserver not responding on " + node.host() + " when publishing " + node.alive());
        }
        s.close();
        return null;
    }

    public static String[] lookupNames() throws IOException {
        return OtpEpmd.lookupNames(InetAddress.getByName(null), new OtpSocketTransportFactory());
    }

    public static String[] lookupNames(OtpTransportFactory transportFactory) throws IOException {
        return OtpEpmd.lookupNames(InetAddress.getByName(null), transportFactory);
    }

    public static String[] lookupNames(InetAddress address) throws IOException {
        return OtpEpmd.lookupNames(address, new OtpSocketTransportFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] lookupNames(InetAddress address, OtpTransportFactory transportFactory) throws IOException {
        String[] stringArray;
        block11: {
            OtpTransport s = null;
            OtpOutputStream obuf = new OtpOutputStream();
            try {
                int bytesRead;
                s = transportFactory.createTransport(address, EpmdPort.get());
                obuf.write2BE(1L);
                obuf.write1(110L);
                obuf.writeToAndFlush(s.getOutputStream());
                if (traceLevel >= 4) {
                    System.out.println("-> NAMES (r4) ");
                }
                byte[] buffer = new byte[256];
                ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                while ((bytesRead = s.getInputStream().read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                byte[] tmpbuf = out.toByteArray();
                OtpInputStream ibuf = new OtpInputStream(tmpbuf, 0);
                ibuf.read4BE();
                int n = tmpbuf.length;
                byte[] buf = new byte[n - 4];
                System.arraycopy(tmpbuf, 4, buf, 0, n - 4);
                String all = OtpErlangString.newString(buf);
                stringArray = all.split("\n");
                if (s == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        s.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (traceLevel >= 4) {
                        System.out.println("<- (no response)");
                    }
                    throw new IOException("Nameserver not responding when requesting names");
                }
                catch (OtpErlangDecodeException e) {
                    if (traceLevel >= 4) {
                        System.out.println("<- (invalid response)");
                    }
                    throw new IOException("Nameserver not responding when requesting names");
                }
            }
            s.close();
        }
        return stringArray;
    }

    static {
        String trace = System.getProperties().getProperty("OtpConnection.trace");
        try {
            if (trace != null) {
                traceLevel = Integer.valueOf(trace);
            }
        }
        catch (NumberFormatException e) {
            traceLevel = 0;
        }
    }

    private static class EpmdPort {
        private static int epmdPort = 0;

        private EpmdPort() {
        }

        public static int get() {
            if (epmdPort == 0) {
                String env;
                try {
                    env = System.getenv("ERL_EPMD_PORT");
                }
                catch (SecurityException e) {
                    env = null;
                }
                epmdPort = env != null ? Integer.parseInt(env) : 4369;
            }
            return epmdPort;
        }

        public static void set(int port) {
            epmdPort = port;
        }
    }
}

