/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class OtpErlangMap
extends OtpErlangObject {
    private static final long serialVersionUID = -6410770117696198497L;
    private OtpMap map;

    public OtpErlangMap() {
        this.map = new OtpMap();
    }

    public OtpErlangMap(OtpErlangObject[] keys, OtpErlangObject[] values) {
        this(keys, 0, keys.length, values, 0, values.length);
    }

    public OtpErlangMap(OtpErlangObject[] keys, int kstart, int kcount, OtpErlangObject[] values, int vstart, int vcount) {
        if (keys == null || values == null) {
            throw new IllegalArgumentException("Map content can't be null");
        }
        if (kcount != vcount) {
            throw new IllegalArgumentException("Map keys and values must have same arity");
        }
        this.map = new OtpMap();
        for (int i = 0; i < vcount; ++i) {
            OtpErlangObject key = keys[kstart + i];
            if (key == null) {
                throw new IllegalArgumentException("Map key cannot be null (element" + (kstart + i) + ")");
            }
            OtpErlangObject val = values[vstart + i];
            if (val == null) {
                throw new IllegalArgumentException("Map value cannot be null (element" + (vstart + i) + ")");
            }
            this.put(key, val);
        }
    }

    public OtpErlangMap(OtpInputStream buf) throws OtpErlangDecodeException {
        int arity = buf.read_map_head();
        if (arity > 0) {
            this.map = new OtpMap();
            for (int i = 0; i < arity; ++i) {
                OtpErlangObject key = buf.read_any();
                OtpErlangObject val = buf.read_any();
                this.put(key, val);
            }
        } else {
            this.map = new OtpMap();
        }
    }

    public int arity() {
        return this.map.size();
    }

    public OtpErlangObject put(OtpErlangObject key, OtpErlangObject value) {
        return this.map.put(key, value);
    }

    public OtpErlangObject remove(OtpErlangObject key) {
        return (OtpErlangObject)this.map.remove(key);
    }

    public OtpErlangObject get(OtpErlangObject key) {
        return (OtpErlangObject)this.map.get(key);
    }

    public OtpErlangObject[] keys() {
        return this.map.keySet().toArray(new OtpErlangObject[this.arity()]);
    }

    public OtpErlangObject[] values() {
        return this.map.values().toArray(new OtpErlangObject[this.arity()]);
    }

    public Set<Map.Entry<OtpErlangObject, OtpErlangObject>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("#{");
        boolean first = true;
        for (Map.Entry<OtpErlangObject, OtpErlangObject> e : this.entrySet()) {
            if (first) {
                first = false;
            } else {
                s.append(",");
            }
            s.append(e.getKey().toString());
            s.append(" => ");
            s.append(e.getValue().toString());
        }
        s.append("}");
        return s.toString();
    }

    @Override
    public void encode(OtpOutputStream buf) {
        int arity = this.arity();
        buf.write_map_head(arity);
        for (Map.Entry<OtpErlangObject, OtpErlangObject> e : this.entrySet()) {
            buf.write_any(e.getKey());
            buf.write_any(e.getValue());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangMap)) {
            return false;
        }
        OtpErlangMap t = (OtpErlangMap)o;
        int a = this.arity();
        if (a != t.arity()) {
            return false;
        }
        if (a == 0) {
            return true;
        }
        for (Map.Entry<OtpErlangObject, OtpErlangObject> e : this.entrySet()) {
            OtpErlangObject key = e.getKey();
            OtpErlangObject val = e.getValue();
            OtpErlangObject v = t.get(key);
            if (v != null && val.equals(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> boolean match(OtpErlangObject term, T binds) {
        if (!(term instanceof OtpErlangMap)) {
            return false;
        }
        OtpErlangMap t = (OtpErlangMap)term;
        int a = this.arity();
        if (a > t.arity()) {
            return false;
        }
        if (a == 0) {
            return true;
        }
        for (Map.Entry<OtpErlangObject, OtpErlangObject> e : this.entrySet()) {
            OtpErlangObject key = e.getKey();
            OtpErlangObject val = e.getValue();
            OtpErlangObject v = t.get(key);
            if (v != null && val.match(v, binds)) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> OtpErlangObject bind(T binds) throws OtpErlangException {
        OtpErlangMap ret = new OtpErlangMap();
        for (Map.Entry<OtpErlangObject, OtpErlangObject> e : this.entrySet()) {
            OtpErlangObject key = e.getKey();
            OtpErlangObject val = e.getValue();
            ret.put(key, val.bind(binds));
        }
        return ret;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(9);
        hash.combine(this.map.hashCode());
        return hash.valueOf();
    }

    @Override
    public Object clone() {
        OtpErlangMap newMap = (OtpErlangMap)super.clone();
        newMap.map = (OtpMap)this.map.clone();
        return newMap;
    }

    private static class OtpMap
    extends LinkedHashMap<OtpErlangObject, OtpErlangObject> {
        private static final long serialVersionUID = -2666505810905455082L;
    }
}

