/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpCookedConnection;
import com.ericsson.otp.erlang.OtpEpmd;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpGenericTransportFactory;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMbox;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpNodeStatus;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpServerTransport;
import com.ericsson.otp.erlang.OtpTransport;
import com.ericsson.otp.erlang.OtpTransportFactory;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class OtpNode
extends OtpLocalNode {
    private boolean initDone = false;
    private Acceptor acceptor = null;
    Hashtable<String, OtpCookedConnection> connections = null;
    Mailboxes mboxes = null;
    OtpNodeStatus handler;
    private int connFlags = 0;

    public OtpNode(String node) throws IOException {
        super(node);
        this.init(0);
    }

    public OtpNode(String node, OtpTransportFactory transportFactory) throws IOException {
        super(node, transportFactory);
        if (transportFactory instanceof OtpGenericTransportFactory) {
            this.init();
        } else {
            this.init(0);
        }
    }

    public OtpNode(String node, String cookie) throws IOException {
        this(node, cookie, 0);
    }

    public OtpNode(String node, String cookie, OtpTransportFactory transportFactory) throws IOException {
        super(node, cookie, transportFactory);
        if (transportFactory instanceof OtpGenericTransportFactory) {
            this.init();
        } else {
            this.init(0);
        }
    }

    public OtpNode(String node, String cookie, int port) throws IOException {
        super(node, cookie);
        this.init(port);
    }

    public OtpNode(String node, String cookie, int port, OtpTransportFactory transportFactory) throws IOException {
        super(node, cookie, transportFactory);
        this.init(port);
    }

    private synchronized void init(int aport) throws IOException {
        if (!this.initDone) {
            this.connections = new Hashtable(17, 0.95f);
            this.mboxes = new Mailboxes();
            this.acceptor = new Acceptor(aport);
            this.initDone = true;
        }
    }

    private synchronized void init() throws IOException {
        if (!this.initDone) {
            this.connections = new Hashtable(17, 0.95f);
            this.mboxes = new Mailboxes();
            this.acceptor = new Acceptor(this);
            this.initDone = true;
        }
    }

    public synchronized void close() {
        this.acceptor.quit();
        Collection<OtpCookedConnection> coll = this.connections.values();
        Iterator<OtpCookedConnection> it = coll.iterator();
        this.mboxes.clear();
        while (it.hasNext()) {
            OtpCookedConnection conn = it.next();
            it.remove();
            conn.close();
        }
        this.initDone = false;
    }

    protected void finalize() {
        this.close();
    }

    public OtpMbox createMbox() {
        return this.mboxes.create();
    }

    public void closeMbox(OtpMbox mbox) {
        this.closeMbox(mbox, new OtpErlangAtom("normal"));
    }

    public void closeMbox(OtpMbox mbox, OtpErlangObject reason) {
        if (mbox != null) {
            this.mboxes.remove(mbox);
            mbox.name = null;
            mbox.breakLinks(reason);
        }
    }

    public OtpMbox createMbox(String name) {
        return this.mboxes.create(name);
    }

    public boolean registerName(String name, OtpMbox mbox) {
        return this.mboxes.register(name, mbox);
    }

    public String[] getNames() {
        return this.mboxes.names();
    }

    public OtpErlangPid whereis(String name) {
        OtpMbox m = this.mboxes.get(name);
        if (m != null) {
            return m.self();
        }
        return null;
    }

    public synchronized void registerStatusHandler(OtpNodeStatus ahandler) {
        this.handler = ahandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(String anode, long timeout) {
        if (anode.equals(this.node)) {
            return true;
        }
        if (anode.indexOf(64) < 0 && anode.equals(this.node.substring(0, this.node.indexOf(64)))) {
            return true;
        }
        OtpMbox mbox = null;
        try {
            mbox = this.createMbox();
            mbox.send("net_kernel", anode, this.getPingTuple(mbox));
            OtpErlangObject reply = mbox.receive(timeout);
            OtpErlangTuple t = (OtpErlangTuple)reply;
            OtpErlangAtom a = (OtpErlangAtom)t.elementAt(1);
            boolean bl = "yes".equals(a.atomValue());
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.closeMbox(mbox);
        }
        return false;
    }

    private OtpErlangTuple getPingTuple(OtpMbox mbox) {
        OtpErlangObject[] ping = new OtpErlangObject[3];
        OtpErlangObject[] pid = new OtpErlangObject[2];
        OtpErlangObject[] anode = new OtpErlangObject[2];
        pid[0] = mbox.self();
        pid[1] = this.createRef();
        anode[0] = new OtpErlangAtom("is_auth");
        anode[1] = new OtpErlangAtom(this.node());
        ping[0] = new OtpErlangAtom("$gen_call");
        ping[1] = new OtpErlangTuple(pid);
        ping[2] = new OtpErlangTuple(anode);
        return new OtpErlangTuple(ping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean netKernel(OtpMsg m) {
        OtpMbox mbox = null;
        try {
            OtpErlangTuple t = (OtpErlangTuple)m.getMsg();
            OtpErlangTuple req = (OtpErlangTuple)t.elementAt(1);
            OtpErlangPid pid = (OtpErlangPid)req.elementAt(0);
            OtpErlangObject[] pong = new OtpErlangObject[]{req.elementAt(1), new OtpErlangAtom("yes")};
            mbox = this.createMbox();
            mbox.send(pid, (OtpErlangObject)new OtpErlangTuple(pong));
            boolean bl = true;
            this.closeMbox(mbox);
            return bl;
        }
        catch (Exception exception) {
            this.closeMbox(mbox);
        }
        catch (Throwable throwable) {
            this.closeMbox(mbox);
            throw throwable;
        }
        return false;
    }

    boolean deliver(OtpMsg m) {
        OtpMbox mbox = null;
        try {
            int t = m.type();
            if (t == 6) {
                String name = m.getRecipientName();
                if (name.equals("net_kernel")) {
                    return this.netKernel(m);
                }
                mbox = this.mboxes.get(name);
            } else {
                mbox = this.mboxes.get(m.getRecipientPid());
            }
            if (mbox == null) {
                return false;
            }
            mbox.deliver(m);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    void deliverError(OtpCookedConnection conn, Exception e) {
        this.removeConnection(conn);
        this.remoteStatus(conn.name, false, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OtpCookedConnection getConnection(String anode) {
        OtpPeer peer = null;
        OtpCookedConnection conn = null;
        Hashtable<String, OtpCookedConnection> hashtable = this.connections;
        synchronized (hashtable) {
            conn = this.connections.get(anode);
            if (conn == null && (conn = this.connections.get((peer = new OtpPeer(anode, this.transportFactory)).node())) == null) {
                try {
                    conn = new OtpCookedConnection(this, peer);
                    conn.setFlags(this.connFlags);
                    this.addConnection(conn);
                }
                catch (Exception e) {
                    this.connAttempt(peer.node(), false, e);
                }
            }
            return conn;
        }
    }

    void addConnection(OtpCookedConnection conn) {
        if (conn != null && conn.name != null) {
            this.connections.put(conn.name, conn);
            this.remoteStatus(conn.name, true, null);
        }
    }

    private void removeConnection(OtpCookedConnection conn) {
        if (conn != null && conn.name != null) {
            this.connections.remove(conn.name);
        }
    }

    private synchronized void remoteStatus(String anode, boolean up, Object info) {
        if (this.handler == null) {
            return;
        }
        try {
            this.handler.remoteStatus(anode, up, info);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void localStatus(String anode, boolean up, Object info) {
        if (this.handler == null) {
            return;
        }
        try {
            this.handler.localStatus(anode, up, info);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void connAttempt(String anode, boolean incoming, Object info) {
        if (this.handler == null) {
            return;
        }
        try {
            this.handler.connAttempt(anode, incoming, info);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFlags(int flags) {
        this.connFlags = flags;
    }

    public class Acceptor
    extends Thread {
        private final OtpServerTransport sock;
        private final int acceptorPort;
        private volatile boolean done = false;

        Acceptor(int port) throws IOException {
            this.sock = OtpNode.this.createServerTransport(port);
            OtpNode.this.port = this.acceptorPort = this.sock.getLocalPort();
            this.setDaemon(true);
            this.setName("acceptor");
            this.publishPort();
            this.start();
        }

        Acceptor(OtpLocalNode node) throws IOException {
            this.acceptorPort = 0;
            this.sock = OtpNode.this.createServerTransport(node);
            this.setDaemon(true);
            this.setName("acceptor");
            this.start();
        }

        private boolean publishPort() throws IOException {
            if (OtpNode.this.getEpmd() != null) {
                return false;
            }
            OtpEpmd.publishPort(OtpNode.this);
            return true;
        }

        private void unPublishPort() {
            if (OtpNode.this.transportFactory instanceof OtpGenericTransportFactory) {
                return;
            }
            OtpEpmd.unPublishPort(OtpNode.this);
            this.closeSock(OtpNode.this.epmd);
            OtpNode.this.epmd = null;
        }

        public void quit() {
            this.unPublishPort();
            this.done = true;
            this.closeSock(this.sock);
            OtpNode.this.localStatus(OtpNode.this.node, false, null);
        }

        private void closeSock(OtpServerTransport s) {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void closeSock(OtpTransport s) {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int port() {
            return this.acceptorPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OtpTransport newsock = null;
            OtpCookedConnection conn = null;
            OtpNode.this.localStatus(OtpNode.this.node, true, null);
            while (!this.done) {
                conn = null;
                try {
                    newsock = this.sock.accept();
                }
                catch (Exception e) {
                    if (this.done) break;
                    OtpNode.this.localStatus(OtpNode.this.node, false, e);
                    break;
                }
                try {
                    Hashtable<String, OtpCookedConnection> e = OtpNode.this.connections;
                    synchronized (e) {
                        conn = new OtpCookedConnection(OtpNode.this, newsock);
                        conn.setFlags(OtpNode.this.connFlags);
                        OtpNode.this.addConnection(conn);
                    }
                }
                catch (OtpAuthException e) {
                    if (conn != null && conn.name != null) {
                        OtpNode.this.connAttempt(conn.name, true, e);
                    } else {
                        OtpNode.this.connAttempt("unknown", true, e);
                    }
                    this.closeSock(newsock);
                }
                catch (IOException e) {
                    if (conn != null && conn.name != null) {
                        OtpNode.this.connAttempt(conn.name, true, e);
                    } else {
                        OtpNode.this.connAttempt("unknown", true, e);
                    }
                    this.closeSock(newsock);
                }
                catch (Exception e) {
                    this.closeSock(newsock);
                    this.closeSock(this.sock);
                    OtpNode.this.localStatus(OtpNode.this.node, false, e);
                    break;
                }
            }
            this.unPublishPort();
        }
    }

    public class Mailboxes {
        private Hashtable<OtpErlangPid, WeakReference<OtpMbox>> byPid = new Hashtable(17, 0.95f);
        private Hashtable<String, WeakReference<OtpMbox>> byName = new Hashtable(17, 0.95f);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OtpMbox create(String name) {
            OtpMbox m = null;
            Hashtable<String, WeakReference<OtpMbox>> hashtable = this.byName;
            synchronized (hashtable) {
                if (this.get(name) != null) {
                    return null;
                }
                OtpErlangPid pid = OtpNode.this.createPid();
                m = new OtpMbox(OtpNode.this, pid, name);
                this.byPid.put(pid, new WeakReference<OtpMbox>(m));
                this.byName.put(name, new WeakReference<OtpMbox>(m));
            }
            return m;
        }

        public OtpMbox create() {
            OtpErlangPid pid = OtpNode.this.createPid();
            OtpMbox m = new OtpMbox(OtpNode.this, pid);
            this.byPid.put(pid, new WeakReference<OtpMbox>(m));
            return m;
        }

        public void clear() {
            this.byPid.clear();
            this.byName.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] names() {
            String[] allnames = null;
            Hashtable<String, WeakReference<OtpMbox>> hashtable = this.byName;
            synchronized (hashtable) {
                int n = this.byName.size();
                Enumeration<String> keys = this.byName.keys();
                allnames = new String[n];
                int i = 0;
                while (keys.hasMoreElements()) {
                    allnames[i++] = keys.nextElement();
                }
            }
            return allnames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean register(String name, OtpMbox mbox) {
            if (name == null) {
                if (mbox.name != null) {
                    this.byName.remove(mbox.name);
                    mbox.name = null;
                }
            } else {
                Hashtable<String, WeakReference<OtpMbox>> hashtable = this.byName;
                synchronized (hashtable) {
                    if (this.get(name) != null) {
                        return false;
                    }
                    this.byName.put(name, new WeakReference<OtpMbox>(mbox));
                    mbox.name = name;
                }
            }
            return true;
        }

        public OtpMbox get(String name) {
            WeakReference<OtpMbox> wr = this.byName.get(name);
            if (wr != null) {
                OtpMbox m = (OtpMbox)wr.get();
                if (m != null) {
                    return m;
                }
                this.byName.remove(name);
            }
            return null;
        }

        public OtpMbox get(OtpErlangPid pid) {
            WeakReference<OtpMbox> wr = this.byPid.get(pid);
            if (wr != null) {
                OtpMbox m = (OtpMbox)wr.get();
                if (m != null) {
                    return m;
                }
                this.byPid.remove(pid);
            }
            return null;
        }

        public void remove(OtpMbox mbox) {
            this.byPid.remove(mbox.self);
            if (mbox.name != null) {
                this.byName.remove(mbox.name);
            }
        }
    }
}

