/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpGenericTransportFactory;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpServerTransport;
import com.ericsson.otp.erlang.OtpSocketTransportFactory;
import com.ericsson.otp.erlang.OtpTransport;
import com.ericsson.otp.erlang.OtpTransportFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AbstractNode
implements OtpTransportFactory {
    static String localHost = null;
    String node;
    String host;
    String alive;
    String cookie;
    static String defaultCookie = null;
    final OtpTransportFactory transportFactory;
    static final int NTYPE_R6 = 110;
    static final int dFlagPublished = 1;
    static final int dFlagAtomCache = 2;
    static final int dFlagExtendedReferences = 4;
    static final int dFlagDistMonitor = 8;
    static final int dFlagFunTags = 16;
    static final int dFlagDistMonitorName = 32;
    static final int dFlagHiddenAtomCache = 64;
    static final int dflagNewFunTags = 128;
    static final int dFlagExtendedPidsPorts = 256;
    static final int dFlagExportPtrTag = 512;
    static final int dFlagBitBinaries = 1024;
    static final int dFlagNewFloats = 2048;
    static final int dFlagUnicodeIo = 4096;
    static final int dFlagUtf8Atoms = 65536;
    static final int dFlagMapTag = 131072;
    static final int dFlagBigCreation = 262144;
    static final int dFlagHandshake23 = 0x1000000;
    static final int dFlagUnlinkId = 0x2000000;
    static final int dFlagMandatory25Digest = 0x4000000;
    static final long dFlagV4PidsRefs = 0x400000000L;
    static final long mandatoryFlags25 = 17239956L;
    static final long mandatoryFlags26 = 0x402000000L;
    static final long mandatoryFlags = 17230663572L;
    int ntype = 110;
    int proto = 0;
    int distHigh = 6;
    int distLow = 6;
    private int creation = 0x710000;
    long flags = 17297772436L;

    protected AbstractNode(OtpTransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }

    protected AbstractNode(String node) {
        this(node, defaultCookie, new OtpSocketTransportFactory());
    }

    protected AbstractNode(String node, OtpTransportFactory transportFactory) {
        this(node, defaultCookie, transportFactory);
    }

    protected AbstractNode(String name, String cookie) {
        this(name, cookie, new OtpSocketTransportFactory());
    }

    protected AbstractNode(String name, String cookie, OtpTransportFactory transportFactory) {
        this.cookie = cookie;
        this.transportFactory = transportFactory;
        int i = name.indexOf(64);
        if (i < 0) {
            this.alive = name;
            this.host = localHost;
        } else {
            this.alive = name.substring(0, i);
            this.host = name.substring(i + 1, name.length());
        }
        if (this.alive.length() > 255) {
            this.alive = this.alive.substring(0, 255);
        }
        this.node = this.alive + "@" + this.host;
    }

    public String node() {
        return this.node;
    }

    public String host() {
        return this.host;
    }

    public String alive() {
        return this.alive;
    }

    public String cookie() {
        return this.cookie;
    }

    int type() {
        return this.ntype;
    }

    int distHigh() {
        return this.distHigh;
    }

    int distLow() {
        return this.distLow;
    }

    int proto() {
        return this.proto;
    }

    int creation() {
        return this.creation;
    }

    void setCreation(int cr) throws OtpErlangDecodeException {
        if (cr == 0) {
            throw new OtpErlangDecodeException("Node creation 0 not allowed");
        }
        this.creation = cr;
    }

    public String setCookie(String cookie) {
        String prev = this.cookie;
        this.cookie = cookie;
        return prev;
    }

    public String toString() {
        return this.node();
    }

    private static String getHomeDir() {
        String home = System.getProperty("user.home");
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            String drive = System.getenv("HOMEDRIVE");
            String path = System.getenv("HOMEPATH");
            return drive != null && path != null ? drive + path : home;
        }
        return home;
    }

    @Override
    public OtpTransport createTransport(String addr, int port) throws IOException {
        return this.transportFactory.createTransport(addr, port);
    }

    @Override
    public OtpTransport createTransport(InetAddress addr, int port) throws IOException {
        return this.transportFactory.createTransport(addr, port);
    }

    @Override
    public OtpServerTransport createServerTransport(int port) throws IOException {
        return this.transportFactory.createServerTransport(port);
    }

    public OtpTransport createTransport(OtpPeer peer) throws IOException {
        if (this.transportFactory instanceof OtpGenericTransportFactory) {
            return ((OtpGenericTransportFactory)this.transportFactory).createTransport(peer);
        }
        throw new IOException("Method createTransport(OtpPeer) applicable only for Nodes with a transport factory instance of OtpGenericTransportFactory");
    }

    public OtpServerTransport createServerTransport(OtpLocalNode node) throws IOException {
        if (this.transportFactory instanceof OtpGenericTransportFactory) {
            return ((OtpGenericTransportFactory)this.transportFactory).createServerTransport(node);
        }
        throw new IOException("Method createServerTransport(OtpLocalNode) applicable only for Nodes with a transport factory instance of OtpGenericTransportFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            localHost = InetAddress.getLocalHost().getHostName();
            int dot = localHost.indexOf(".");
            if (dot != -1) {
                localHost = localHost.substring(0, dot);
            }
        }
        catch (UnknownHostException e) {
            localHost = "localhost";
        }
        String homeDir = AbstractNode.getHomeDir();
        String dotCookieFilename = homeDir + File.separator + ".erlang.cookie";
        BufferedReader br = null;
        try {
            File dotCookieFile = new File(dotCookieFilename);
            br = new BufferedReader(new FileReader(dotCookieFile));
            String line = br.readLine();
            defaultCookie = line == null ? "" : line.trim();
        }
        catch (IOException e) {
            defaultCookie = "";
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

