/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.Link;
import com.ericsson.otp.erlang.OtpErlangPid;

class Links {
    Link[] links;
    int count;
    int active;

    Links() {
        this(10);
    }

    Links(int initialSize) {
        this.links = new Link[initialSize];
        this.count = 0;
        this.active = 0;
    }

    synchronized boolean addLink(OtpErlangPid local, OtpErlangPid remote, boolean force) {
        int i = this.find(local, remote);
        if (i != -1) {
            if (this.links[i].getUnlinking() != 0L && force) {
                this.links[i].setUnlinking(0L);
                ++this.active;
                return true;
            }
            return false;
        }
        if (this.count >= this.links.length) {
            Link[] tmp = new Link[this.count * 2];
            System.arraycopy(this.links, 0, tmp, 0, this.count);
            this.links = tmp;
        }
        this.links[this.count++] = new Link(local, remote);
        ++this.active;
        return true;
    }

    synchronized boolean removeLink(OtpErlangPid local, OtpErlangPid remote) {
        int i = this.find(local, remote);
        if (i != -1) {
            long unlinking = this.links[i].getUnlinking();
            --this.count;
            this.links[i] = this.links[this.count];
            this.links[this.count] = null;
            if (unlinking == 0L) {
                --this.active;
                return true;
            }
        }
        return false;
    }

    synchronized boolean removeActiveLink(OtpErlangPid local, OtpErlangPid remote) {
        int i = this.find(local, remote);
        if (i != -1) {
            long unlinking = this.links[i].getUnlinking();
            if (unlinking != 0L) {
                return false;
            }
            --this.count;
            --this.active;
            this.links[i] = this.links[this.count];
            this.links[this.count] = null;
            return true;
        }
        return false;
    }

    synchronized boolean removeUnlinkingLink(OtpErlangPid local, OtpErlangPid remote, long unlink_id) {
        if (unlink_id == 0L) {
            return false;
        }
        int i = this.find(local, remote);
        if (i != -1) {
            long unlinking = this.links[i].getUnlinking();
            if (unlinking != unlink_id) {
                return false;
            }
            --this.count;
            this.links[i] = this.links[this.count];
            this.links[this.count] = null;
            return true;
        }
        return false;
    }

    synchronized boolean setUnlinking(OtpErlangPid local, OtpErlangPid remote, long unlink_id) {
        if (unlink_id == 0L) {
            return false;
        }
        int i = this.find(local, remote);
        if (i != -1 && this.links[i].getUnlinking() == 0L) {
            this.links[i].setUnlinking(unlink_id);
            --this.active;
            return true;
        }
        return false;
    }

    synchronized int find(OtpErlangPid local, OtpErlangPid remote) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.links[i].equals(local, remote)) continue;
            return i;
        }
        return -1;
    }

    synchronized OtpErlangPid[] remotePids() {
        OtpErlangPid[] ret = null;
        if (this.active != 0) {
            int a = 0;
            ret = new OtpErlangPid[this.active];
            int i = 0;
            while (a < this.active) {
                if (this.links[i].getUnlinking() == 0L) {
                    ret[a++] = this.links[i].remote();
                }
                ++i;
            }
        }
        return ret;
    }

    synchronized Link[] clearLinks() {
        Link[] ret = null;
        if (this.count != 0) {
            ret = new Link[this.count];
            for (int i = 0; i < this.count; ++i) {
                ret[i] = this.links[i];
                this.links[i] = null;
            }
            this.count = 0;
        }
        return ret;
    }
}

