/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;

public class OtpErlangDouble
extends OtpErlangObject {
    private static final long serialVersionUID = 132947104811974021L;
    private final double d;

    public OtpErlangDouble(double d) {
        this.d = d;
    }

    public OtpErlangDouble(OtpInputStream buf) throws OtpErlangDecodeException {
        this.d = buf.read_double();
    }

    public double doubleValue() {
        return this.d;
    }

    public float floatValue() throws OtpErlangRangeException {
        float f = (float)this.d;
        if ((double)f != this.d) {
            throw new OtpErlangRangeException("Value too large for float: " + this.d);
        }
        return f;
    }

    @Override
    public String toString() {
        return "" + this.d;
    }

    @Override
    public void encode(OtpOutputStream buf) {
        buf.write_double(this.d);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangDouble)) {
            return false;
        }
        OtpErlangDouble other = (OtpErlangDouble)o;
        return this.d == other.d;
    }

    @Override
    protected int doHashCode() {
        Double v = this.d;
        return v.hashCode();
    }
}

