/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="BoundOrAssignedEvalOrArguments", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class BoundOrAssignedEvalOrArgumentsCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        EcmaScriptGrammar g = (EcmaScriptGrammar)this.getContext().getGrammar();
        this.subscribeTo(new AstNodeType[]{g.functionDeclaration, g.functionExpression, g.catch_, g.variableDeclaration, g.variableDeclarationNoIn, g.propertySetParameterList, g.memberExpression});
    }

    public void visitNode(AstNode astNode) {
        EcmaScriptGrammar g = (EcmaScriptGrammar)this.getContext().getGrammar();
        if (astNode.is(new AstNodeType[]{g.functionDeclaration, g.functionExpression})) {
            this.checkFunction(astNode);
        } else if (astNode.is(new AstNodeType[]{g.catch_, g.variableDeclaration, g.variableDeclarationNoIn})) {
            this.checkVariableDeclaration(astNode);
        } else if (astNode.is(new AstNodeType[]{g.propertySetParameterList})) {
            this.checkPropertySetParameterList(astNode);
        } else if (astNode.is(new AstNodeType[]{g.memberExpression})) {
            this.checkModification(astNode);
        }
    }

    private void checkFunction(AstNode astNode) {
        AstNode formalParameterList;
        AstNode identifier = astNode.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).identifier});
        if (identifier != null && this.isEvalOrArguments(identifier.getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("function", identifier.getTokenValue()), identifier, new Object[0]);
        }
        if ((formalParameterList = astNode.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).formalParameterList})) != null) {
            for (int i = 0; i < formalParameterList.getNumberOfChildren(); i += 2) {
                identifier = formalParameterList.getChild(i);
                if (!this.isEvalOrArguments(identifier.getTokenValue())) continue;
                this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("parameter", identifier.getTokenValue()), identifier, new Object[0]);
            }
        }
    }

    private void checkVariableDeclaration(AstNode astNode) {
        AstNode identifier = astNode.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).identifier});
        if (this.isEvalOrArguments(identifier.getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("variable", identifier.getTokenValue()), identifier, new Object[0]);
        }
    }

    private void checkPropertySetParameterList(AstNode astNode) {
        AstNode identifier = astNode.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).identifier});
        if (this.isEvalOrArguments(identifier.getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, BoundOrAssignedEvalOrArgumentsCheck.createMessageFor("parameter", identifier.getTokenValue()), identifier, new Object[0]);
        }
    }

    private void checkModification(AstNode astNode) {
        if (this.isEvalOrArguments(astNode.getTokenValue()) && !astNode.hasDirectChildren(new AstNodeType[]{EcmaScriptPunctuator.LBRACKET}) && !astNode.getParent().is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).callExpression})) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the modification of '" + astNode.getTokenValue() + "'.", astNode, new Object[0]);
        }
    }

    private static String createMessageFor(String name, String value) {
        return "Do not use '" + value + "' to declare a " + name + " - use another name.";
    }

    private boolean isEvalOrArguments(String name) {
        return "eval".equals(name) || "arguments".equals(name);
    }
}

