/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="SameNameForFunctionAndVariable", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SameNameForFunctionAndVariableCheck
extends SquidCheck<EcmaScriptGrammar> {
    private Stack<Set<String>> variablesStack;
    private Stack<Set<String>> functionsStack;

    public void init() {
        EcmaScriptGrammar g = (EcmaScriptGrammar)this.getContext().getGrammar();
        this.subscribeTo(new AstNodeType[]{g.variableDeclaration, g.variableDeclarationNoIn, g.functionDeclaration, g.functionExpression});
    }

    public void visitFile(AstNode astNode) {
        this.variablesStack = new Stack();
        this.variablesStack.add(new HashSet());
        this.functionsStack = new Stack();
        this.functionsStack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).functionDeclaration})) {
            String functionName = astNode.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).identifier}).getTokenValue();
            this.check(astNode, this.variablesStack.peek(), functionName);
            this.functionsStack.peek().add(functionName);
        } else if (astNode.is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).variableDeclaration, ((EcmaScriptGrammar)this.getContext().getGrammar()).variableDeclarationNoIn})) {
            String variableName = astNode.getTokenValue();
            this.check(astNode, this.functionsStack.peek(), variableName);
            this.variablesStack.peek().add(variableName);
        }
        if (astNode.is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).functionDeclaration, ((EcmaScriptGrammar)this.getContext().getGrammar()).functionExpression})) {
            this.variablesStack.add(new HashSet());
            this.functionsStack.add(new HashSet());
        }
    }

    private void check(AstNode astNode, Set<String> names, String name) {
        if (names.contains(name)) {
            this.getContext().createLineViolation((CodeCheck)this, "Refactor the code to avoid using '" + name + "' for both a variable and a function.", astNode, new Object[0]);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).functionDeclaration, ((EcmaScriptGrammar)this.getContext().getGrammar()).functionExpression})) {
            this.variablesStack.pop();
            this.functionsStack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.variablesStack = null;
        this.functionsStack = null;
    }
}

