/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="SameNameForFunctionAndVariable", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SameNameForFunctionAndVariableCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Set<String>> variablesStack;
    private Stack<Set<String>> functionsStack;
    private static final GrammarRuleKey[] FUNCTION_NODES = new GrammarRuleKey[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.GENERATOR_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION};
    private static final GrammarRuleKey[] CONST_AND_VAR_NODES = new GrammarRuleKey[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN, EcmaScriptGrammar.LEXICAL_BINDING, EcmaScriptGrammar.LEXICAL_BINDING_NO_IN};

    public void init() {
        this.subscribeTo((AstNodeType[])CONST_AND_VAR_NODES);
        this.subscribeTo((AstNodeType[])FUNCTION_NODES);
    }

    public void visitFile(AstNode astNode) {
        this.variablesStack = new Stack();
        this.variablesStack.add(new HashSet());
        this.functionsStack = new Stack();
        this.functionsStack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.GENERATOR_DECLARATION})) {
            String functionName = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER, EcmaScriptGrammar.BINDING_IDENTIFIER}).getTokenValue();
            this.check(astNode, this.variablesStack.peek(), functionName);
            this.functionsStack.peek().add(functionName);
        } else if (astNode.is((AstNodeType[])CONST_AND_VAR_NODES)) {
            String variableName = astNode.getTokenValue();
            this.check(astNode, this.functionsStack.peek(), variableName);
            this.variablesStack.peek().add(variableName);
        }
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            this.variablesStack.add(new HashSet());
            this.functionsStack.add(new HashSet());
        }
    }

    private void check(AstNode astNode, Set<String> names, String name) {
        if (names.contains(name)) {
            this.getContext().createLineViolation((CodeCheck)this, "Refactor the code to avoid using \"" + name + "\" for both a variable and a function.", astNode, new Object[0]);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            this.variablesStack.pop();
            this.functionsStack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.variablesStack = null;
        this.functionsStack = null;
    }
}

