/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.resolve.Usage;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="BoundOrAssignedEvalOrArguments", name="\"eval\" and \"arguments\" should not be bound or assigned", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class BoundOrAssignedEvalOrArgumentsCheck
extends BaseTreeVisitor {
    private static final String DECLARATION_MESSAGE = "Do not use \"%s\" to declare a %s - use another name.";
    private static final String MODIFICATION_MESSAGE = "Remove the modification of \"%s\".";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        List symbols = symbolModel.getSymbols((List)ImmutableList.of((Object)"eval", (Object)"arguments"));
        for (Symbol symbol : symbols) {
            this.visitParameter(symbol);
            this.visitVariableOrFunction(symbol, symbolModel);
        }
        super.visitScript(tree);
    }

    private void visitVariableOrFunction(Symbol symbol, SymbolModel symbolModel) {
        if (symbol.is(Symbol.Kind.VARIABLE) || symbol.is(Symbol.Kind.FUNCTION)) {
            if (symbol.buildIn()) {
                for (Usage usage : symbolModel.getUsageFor(symbol)) {
                    if (usage.kind().equals((Object)Usage.Kind.READ)) continue;
                    this.getContext().addIssue((CodeVisitor)this, (Tree)usage.symbolTree(), String.format(MODIFICATION_MESSAGE, symbol.name()));
                }
            } else {
                this.getContext().addIssue((CodeVisitor)this, symbol.getFirstDeclaration().tree(), String.format(DECLARATION_MESSAGE, symbol.name(), symbol.kind().getValue()));
            }
        }
    }

    private void visitParameter(Symbol symbol) {
        if (symbol.is(Symbol.Kind.PARAMETER)) {
            this.getContext().addIssue((CodeVisitor)this, symbol.getFirstDeclaration().tree(), String.format(DECLARATION_MESSAGE, symbol.name(), symbol.kind().getValue()));
        }
    }
}

