/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.SubscriptionBaseVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.DotMemberExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2228", name="Console logging should not be used", priority=Priority.MAJOR, tags={"owasp-a6", "security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="5min")
public class ConsoleLoggingCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CALL_EXPRESSION);
    }

    public void visitNode(Tree tree) {
        DotMemberExpressionTree callee;
        CallExpressionTree callExpression = (CallExpressionTree)tree;
        if (callExpression.callee().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && this.isCalleeConsoleLogging(callee = (DotMemberExpressionTree)callExpression.callee())) {
            this.addIssue(tree, "Remove this logging statement.");
        }
    }

    private boolean isCalleeConsoleLogging(DotMemberExpressionTree callee) {
        return callee.object().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "console".equals(((IdentifierTree)callee.object()).name()) && "log".equals(((IdentifierTree)callee.property()).name());
    }
}

