/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQuerySelectorOptimizationCheck;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2714", name="Element type selectors should not be used with class selectors", priority=Priority.MAJOR, tags={"jquery", "performance", "user-experience"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="2min")
public class ElementUsedWithClassSelectorCheck
extends AbstractJQuerySelectorOptimizationCheck {
    private static final String MESSAGE = "Remove \"%s\" in this selector.";
    private static final Pattern elementUsedWithClassSelectorPattern = Pattern.compile("(\\w+)\\.([\\w_-]+)");

    @Override
    protected void visitSelector(String selector, Tree tree) {
        Matcher matcher = elementUsedWithClassSelectorPattern.matcher(selector);
        if (matcher.matches()) {
            this.getContext().addIssue((CodeVisitor)this, tree, String.format(MESSAGE, matcher.group(1)));
        }
    }
}

