/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQuerySelectorOptimizationCheck;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2715", name="\"find\" should be used to select the children of an element known by id", priority=Priority.MAJOR, tags={"jquery", "performance", "user-experience"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class IdChildrenSelectorCheck
extends AbstractJQuerySelectorOptimizationCheck {
    private static final String MESSAGE = "Move \"%s\" into \"find\" method.";
    private static final Pattern idChildrenSelectorPattern = Pattern.compile("(#[\\w_-]+)[ ]+([^ ]+)");

    @Override
    protected void visitSelector(String selector, Tree tree) {
        Matcher matcher = idChildrenSelectorPattern.matcher(selector);
        if (matcher.matches()) {
            this.getContext().addIssue((CodeVisitor)this, tree, String.format(MESSAGE, matcher.group(2)));
        }
    }
}

