/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.ast.visitors.SyntacticEquivalence;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.LiteralTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S1764", name="Identical expressions should not be used on both sides of a binary operator", priority=Priority.CRITICAL, tags={"bug", "cert"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class IdenticalExpressionOnBinaryOperatorCheck
extends BaseTreeVisitor {
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.MULTIPLY, Tree.Kind.PLUS, Tree.Kind.ASSIGNMENT}) && SyntacticEquivalence.areEquivalent((Tree)tree.leftOperand(), (Tree)tree.rightOperand()) && this.isExcluded(tree)) {
            this.getContext().addIssue((CodeVisitor)this, (Tree)tree, "Identical sub-expressions on both sides of operator \"" + tree.operator().text() + "\"");
        }
        super.visitBinaryExpression(tree);
    }

    private boolean isExcluded(BinaryExpressionTree tree) {
        return !this.isOneOntoOneShifting(tree) && !this.isPotentialNanComparison(tree);
    }

    private boolean isPotentialNanComparison(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.STRICT_NOT_EQUAL_TO}) && tree.leftOperand().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.IDENTIFIER, Tree.Kind.BRACKET_MEMBER_EXPRESSION, Tree.Kind.DOT_MEMBER_EXPRESSION});
    }

    private boolean isOneOntoOneShifting(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.LEFT_SHIFT}) && tree.leftOperand().is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && "1".equals(((LiteralTree)tree.leftOperand()).value());
    }
}

