/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.AbstractJQueryCheck;
import org.sonar.javascript.model.implementations.SeparatedList;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.FunctionDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.InitializedBindingElementTree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.javascript.model.interfaces.expression.ArrowFunctionTree;
import org.sonar.javascript.model.interfaces.expression.AssignmentExpressionTree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.FunctionExpressionTree;
import org.sonar.javascript.model.interfaces.expression.LiteralTree;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2762", name="Selections should be stored", priority=Priority.MAJOR, tags={"jquery", "performance", "user-experience"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="2min", effortToFixDescription="number of times selection is re-made.")
public class NotStoredSelectionCheck
extends AbstractJQueryCheck {
    private static final int DEFAULT = 2;
    @RuleProperty(key="threshold", description="Number of allowed repetition before triggering an issue", defaultValue="2")
    public int threshold = 2;
    private Deque<List<LiteralTree>> selectors;

    public void visitScript(ScriptTree tree) {
        this.selectors = new ArrayDeque<List<LiteralTree>>();
        this.startScopeBlock();
        super.visitScript(tree);
        this.finishScopeBlock();
    }

    private void finishScopeBlock() {
        this.checkForDuplications(this.selectors.pop());
    }

    private void checkForDuplications(List<LiteralTree> selectors) {
        class Entry {
            private Integer count;
            private LiteralTree literalTree;

            Entry(LiteralTree literalTree) {
                this.literalTree = literalTree;
                this.count = 1;
            }

            void inc() {
                Entry entry = this;
                Integer n = entry.count;
                Integer n2 = entry.count = Integer.valueOf(entry.count + 1);
            }
        }
        HashMap<String, Entry> duplications = new HashMap<String, Entry>();
        for (LiteralTree literal : selectors) {
            String value = literal.value();
            Entry entry = (Entry)duplications.get(value);
            if (entry != null) {
                entry.inc();
                continue;
            }
            duplications.put(value, new Entry(literal));
        }
        for (Entry entry : duplications.values()) {
            if (entry.count <= this.threshold) continue;
            String message = String.format("Selection \"$( %s )\" is made %s times. It should be stored in a variable and reused.", entry.literalTree.value(), entry.count);
            this.getContext().addIssue((CodeVisitor)this, (Tree)entry.literalTree, message, (double)entry.count.intValue() - (double)this.threshold);
        }
    }

    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.startScopeBlock();
        super.visitFunctionDeclaration(tree);
        this.finishScopeBlock();
    }

    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.startScopeBlock();
        super.visitFunctionExpression(tree);
        this.finishScopeBlock();
    }

    public void visitArrowFunction(ArrowFunctionTree tree) {
        this.startScopeBlock();
        super.visitArrowFunction(tree);
        this.finishScopeBlock();
    }

    private void startScopeBlock() {
        this.selectors.push(new LinkedList());
    }

    public void visitCallExpression(CallExpressionTree tree) {
        LiteralTree parameter;
        if (this.isSelector((ExpressionTree)tree) && (parameter = this.getSelectorParameter(tree)) != null) {
            List<LiteralTree> currentSelectors = this.selectors.peek();
            currentSelectors.add(parameter);
        }
        super.visitCallExpression(tree);
    }

    private LiteralTree getSelectorParameter(CallExpressionTree tree) {
        SeparatedList parameters = tree.arguments().parameters();
        if (parameters.size() == 1 && ((Tree)parameters.get(0)).is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return (LiteralTree)parameters.get(0);
        }
        return null;
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        this.checkForSelectors(tree.expression());
    }

    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        super.visitInitializedBindingElement(tree);
        this.checkForSelectors(tree.right());
    }

    private void checkForSelectors(ExpressionTree tree) {
        LiteralTree parameter;
        CallExpressionTree callExpressionTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION}) && this.isSelector((ExpressionTree)(callExpressionTree = (CallExpressionTree)tree)) && (parameter = this.getSelectorParameter(callExpressionTree)) != null) {
            this.selectors.peek().remove(parameter);
        }
    }
}

