/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolDeclaration;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2814", name="Variables and functions should not be redeclared", priority=Priority.MAJOR, tags={"bug", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class RedeclaredSymbolCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Rename \"%s\" as this name is already used in declaration at line %s.";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        List symbols = symbolModel.getSymbols(new Symbol.Kind[0]);
        for (Symbol symbol : symbols) {
            this.visitSymbol(symbol);
        }
    }

    private void visitSymbol(Symbol symbol) {
        List declarations = symbol.declarations();
        SymbolDeclaration firstDeclaration = symbol.getFirstDeclaration();
        int firstDeclarationLine = ((JavaScriptTree)firstDeclaration.tree()).getLine();
        for (int i = 1; i < declarations.size(); ++i) {
            if (firstDeclaration.is(SymbolDeclaration.Kind.PARAMETER) && ((SymbolDeclaration)declarations.get(i)).is(SymbolDeclaration.Kind.PARAMETER)) continue;
            this.getContext().addIssue((CodeVisitor)this, ((SymbolDeclaration)declarations.get(i)).tree(), String.format(MESSAGE, symbol.name(), firstDeclarationLine));
        }
    }
}

