/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.InitializedBindingElementTree;
import org.sonar.javascript.model.interfaces.expression.AssignmentExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2138", name="\"undefined\" should not be assigned", priority=Priority.CRITICAL, tags={"pitfall"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class UndefinedAssignmentCheck
extends BaseTreeVisitor {
    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        if (this.isUndefined(tree.right())) {
            this.reportIssue((Tree)tree);
        }
        super.visitInitializedBindingElement(tree);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && this.isUndefined(tree.expression())) {
            this.reportIssue((Tree)tree);
        }
        super.visitAssignmentExpression(tree);
    }

    private boolean isUndefined(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "undefined".equals(((IdentifierTree)expression).name());
    }

    private void reportIssue(Tree tree) {
        this.getContext().addIssue((CodeVisitor)this, tree, "Use null instead.");
    }
}

