/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQuerySelectorOptimizationCheck;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2716", name="Universal selectors should not be used", priority=Priority.MAJOR, tags={"jquery", "performance", "user-experience"})
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="10min")
public class UniversalSelectorCheck
extends AbstractJQuerySelectorOptimizationCheck {
    private static final String MESSAGE = "Remove the use of this universal selector.";

    @Override
    protected void visitSelector(String selector, Tree tree) {
        String[] parts = selector.split("[ >]");
        for (int i = 1; i < parts.length; ++i) {
            if (!"*".equals(parts[i])) continue;
            this.getContext().addIssue((CodeVisitor)this, tree, MESSAGE);
            return;
        }
    }
}

