/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.ast.visitors.SyntacticEquivalence;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.AssignmentExpressionTree;
import org.sonar.javascript.model.interfaces.expression.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2123", name="Values should not be uselessly incremented", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class UselessIncrementCheck
extends BaseTreeVisitor {
    public void visitAssignmentExpression(AssignmentExpressionTree assignment) {
        if (assignment.expression().is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT})) {
            UnaryExpressionTree postfix = (UnaryExpressionTree)assignment.expression();
            if (SyntacticEquivalence.areEquivalent((Tree)assignment.variable(), (Tree)postfix.expression())) {
                String type = postfix.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT}) ? "increment" : "decrement";
                String message = String.format("Remove this %s or correct the code not to waste it.", type);
                this.getContext().addIssue((CodeVisitor)this, (Tree)postfix, message);
            }
        }
        super.visitAssignmentExpression(assignment);
    }
}

