/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api.flow;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.flow.BarrierSignal;
import com.sonar.sslr.api.flow.Branch;
import com.sonar.sslr.api.flow.ExecutionFlow;
import com.sonar.sslr.api.flow.ExecutionFlowSignal;
import com.sonar.sslr.api.flow.ExecutionFlowVisitor;
import com.sonar.sslr.api.flow.FlowHandler;
import com.sonar.sslr.api.flow.Statement;
import com.sonar.sslr.api.flow.StopFlowExplorationSignal;
import com.sonar.sslr.api.flow.StopPathExplorationSignal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionFlowEngine
implements ExecutionFlow {
    private ExecutionFlowVisitor<Statement>[] visitors = new ExecutionFlowVisitor[0];
    private FunctionCallStack functionCallStack = new FunctionCallStack();
    private Stack<Branch> branchStack = new Stack();
    private int visitStackDepth = 0;
    private static final int MAXIMUM_VISIT_STACK_DEPTH = 200;
    private Statement lastStmt;
    private Statement lastEndPathStmt;
    private Statement firstStmt;
    private boolean executionFlowStarted = false;
    private final Map<AstNode, Statement> stmtAstNodes = new HashMap<AstNode, Statement>();

    public final void add(Statement stmt) {
        this.stmtAstNodes.put(stmt.getAstNode(), stmt);
    }

    public final Statement getStatement(AstNode stmtNode) {
        return this.stmtAstNodes.get(stmtNode);
    }

    public final void visitFlow(AstNode stmtToStartVisitFrom, ExecutionFlowVisitor ... visitors) {
        this.visitors = visitors;
        this.visitFlow(this.getStatement(stmtToStartVisitFrom));
        this.start();
    }

    public final void visitFlow(Statement stmtToStartVisitFrom, ExecutionFlowVisitor ... visitors) {
        this.visitors = visitors;
        this.visitFlow(stmtToStartVisitFrom);
        this.start();
    }

    public final Collection<Statement> getStatements() {
        return this.stmtAstNodes.values();
    }

    public final void visitFlow(Statement stmtToStartVisitFrom) {
        if (!this.executionFlowStarted) {
            this.branchStack = new Stack();
            this.functionCallStack = new FunctionCallStack();
            this.branchStack.push(new Branch());
            this.firstStmt = stmtToStartVisitFrom;
            return;
        }
        if (this.visitStackDepth > 200) {
            throw new BarrierSignal();
        }
        ++this.visitStackDepth;
        Branch branch = this.getCurrentBranch();
        try {
            Statement currentStmt = stmtToStartVisitFrom;
            while (currentStmt != null) {
                FlowHandler flowHandler;
                Statement stmt;
                this.lastStmt = currentStmt;
                this.callVisitStatementOnVisitors();
                if (currentStmt.hasFlowHandler() && (stmt = (flowHandler = currentStmt.getFlowHandler()).processFlow(this)) != null) {
                    currentStmt = stmt;
                    continue;
                }
                currentStmt = currentStmt.getNext();
            }
            if (this.firstStmt == stmtToStartVisitFrom) {
                this.callEndPathOnVisitors();
            }
        }
        catch (ExecutionFlowSignal signal) {
            while (this.getCurrentBranch() != branch) {
                this.branchStack.pop();
                if (!this.branchStack.empty()) continue;
                throw new IllegalStateException("The SSLR execution of flow engine is unable to recover branch state " + branch);
            }
            throw signal;
        }
        finally {
            --this.visitStackDepth;
        }
    }

    public void callEndPathOnVisitors() {
        if (this.lastStmt != this.lastEndPathStmt) {
            for (ExecutionFlowVisitor<Statement> visitor : this.visitors) {
                visitor.endPath(this.getCurrentBranch());
            }
        }
        this.lastEndPathStmt = this.lastStmt;
    }

    private void callVisitStatementOnVisitors() {
        for (ExecutionFlowVisitor<Statement> visitor : this.visitors) {
            visitor.visitStatement(this.lastStmt, this.getCurrentBranch());
        }
    }

    public void callVisitBranchOnVisitors(Statement conditionalStatement, AstNode condition) {
        Branch branch = new Branch(this.getCurrentBranch());
        branch.setCondition(condition);
        branch.setConditionalStatement(conditionalStatement);
        this.branchStack.push(branch);
        for (ExecutionFlowVisitor<Statement> visitor : this.visitors) {
            visitor.visitBranch(branch);
        }
    }

    public void callVisitMandatoryBranches() {
        for (ExecutionFlowVisitor<Statement> visitor : this.visitors) {
            visitor.visitMandatoryBranches();
        }
    }

    public void callLeaveMandatoryBranches() {
        for (ExecutionFlowVisitor<Statement> visitor : this.visitors) {
            visitor.leaveMandatoryBranches();
        }
    }

    public void callLeaveBranchOnVisitors() {
        for (ExecutionFlowVisitor<Statement> visitor : this.visitors) {
            visitor.leaveBranch(this.getCurrentBranch());
        }
        this.branchStack.pop();
    }

    private Branch getCurrentBranch() {
        return this.branchStack.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start() {
        this.executionFlowStarted = true;
        this.visitStackDepth = 0;
        this.callStartOnVisitors();
        try {
            this.visitFlow(this.firstStmt);
        }
        catch (StopPathExplorationSignal signal) {
        }
        catch (StopFlowExplorationSignal signal) {
        }
        catch (BarrierSignal signal) {
        }
        finally {
            try {
                this.callEndPathOnVisitors();
            }
            catch (ExecutionFlowSignal signal) {}
            this.executionFlowStarted = false;
            this.branchStack = new Stack();
            this.functionCallStack = new FunctionCallStack();
        }
        this.callStopOnVisitors();
        this.visitors = null;
    }

    private void callStopOnVisitors() {
        for (ExecutionFlowVisitor<Statement> visitor : this.visitors) {
            visitor.stop();
        }
    }

    private void callStartOnVisitors() {
        for (ExecutionFlowVisitor<Statement> visitor : this.visitors) {
            visitor.start();
        }
    }

    public FunctionCallStack getFunctionCallStack() {
        return this.functionCallStack;
    }

    public void setFunctionCallStackStack(FunctionCallStack functionCallStack) {
        this.functionCallStack = functionCallStack;
    }

    public void visitFlow(ExecutionFlowVisitor ... visitors) {
        throw new UnsupportedOperationException();
    }

    public final class FunctionCallStack
    implements Cloneable {
        private Stack<FlowHandler> branches = new Stack();

        public boolean isEmpty() {
            return this.branches.isEmpty();
        }

        public void add(FlowHandler flowHandler) {
            this.branches.push(flowHandler);
        }

        public FlowHandler peek() {
            return this.branches.peek();
        }

        public FlowHandler pop() {
            return this.branches.pop();
        }

        public boolean contains(FlowHandler flowHandler) {
            return this.branches.contains(flowHandler);
        }

        public FunctionCallStack clone() {
            FunctionCallStack clone = new FunctionCallStack();
            clone.branches = (Stack)this.branches.clone();
            return clone;
        }
    }
}

